/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaPatternBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class BreakpointMarkerUpdater
implements IMarkerUpdater {
    public String[] getAttribute() {
        return new String[]{"lineNumber"};
    }

    public String getMarkerType() {
        return "org.eclipse.debug.core.breakpointMarker";
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        if (position.isDeleted()) {
            return false;
        }
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint breakpoint = manager.getBreakpoint(marker);
        if (breakpoint instanceof IJavaStratumLineBreakpoint || breakpoint instanceof IJavaPatternBreakpoint) {
            return true;
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(document.get().toCharArray());
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        if (unit != null) {
            int line;
            block12: {
                block11: {
                    ValidBreakpointLocationLocator loc;
                    block10: {
                        loc = new ValidBreakpointLocationLocator(unit, document.getLineOfOffset(position.getOffset()) + 1, true, true);
                        unit.accept((ASTVisitor)loc);
                        if (loc.getLocationType() != 0) break block10;
                        return false;
                    }
                    line = loc.getLineLocation();
                    if (MarkerUtilities.getLineNumber((IMarker)marker) != line) break block11;
                    if (this.isLineBreakpoint(marker)) {
                        return this.lineBreakpointExists(marker.getResource(), ((IJavaLineBreakpoint)breakpoint).getTypeName(), line, marker) == null;
                    }
                    return true;
                }
                if (!(this.isLineBreakpoint(marker) & line == -1)) break block12;
                return false;
            }
            try {
                MarkerUtilities.setLineNumber((IMarker)marker, (int)line);
                return true;
            }
            catch (BadLocationException e) {
                JDIDebugUIPlugin.log(e);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return false;
    }

    private boolean isLineBreakpoint(IMarker marker) {
        return MarkerUtilities.isMarkerType((IMarker)marker, (String)"org.eclipse.jdt.debug.javaLineBreakpointMarker");
    }

    private IJavaLineBreakpoint lineBreakpointExists(IResource resource, String typeName, int lineNumber, IMarker currentmarker) throws CoreException {
        String modelId = JDIDebugPlugin.getUniqueIdentifier();
        String markerType = JavaLineBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            String breakpointTypeName;
            IJavaLineBreakpoint breakpoint;
            IMarker marker;
            if (breakpoints[i] instanceof IJavaLineBreakpoint && (marker = (breakpoint = (IJavaLineBreakpoint)breakpoints[i]).getMarker()) != null && marker.exists() && marker.getType().equals(markerType) && currentmarker.getId() != marker.getId() && ((breakpointTypeName = breakpoint.getTypeName()).equals(typeName) || breakpointTypeName.startsWith(String.valueOf(typeName) + '$')) && breakpoint.getLineNumber() == lineNumber && resource.equals((Object)marker.getResource())) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }
}

