/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class LinkAction
extends ProvisioningAction {
    public static final String ID = "ln";

    public IStatus execute(Map parameters) {
        String linkTarget;
        String targetDir = (String)parameters.get("targetDir");
        if (targetDir == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"targetDir", (Object)ID));
        }
        if (targetDir.equals("@artifact")) {
            try {
                targetDir = Util.resolveArtifactParam(parameters);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            File dir = new File(targetDir);
            if (!dir.isDirectory()) {
                return Util.createError(NLS.bind((String)Messages.artifact_not_directory, (Object)dir));
            }
        }
        if ((linkTarget = (String)parameters.get("linkTarget")) == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"linkTarget", (Object)ID));
        }
        String linkName = (String)parameters.get("linkName");
        if (linkName == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"linkName", (Object)ID));
        }
        String force = (String)parameters.get("force");
        this.ln(targetDir, linkTarget, linkName, Boolean.valueOf(force));
        return Status.OK_STATUS;
    }

    public IStatus undo(Map parameters) {
        return null;
    }

    private void ln(String targetDir, String linkTarget, String linkName, boolean force) {
        Runtime r = Runtime.getRuntime();
        try {
            r.exec(new String[]{ID, "-s" + (force ? "f" : ""), linkTarget, String.valueOf(targetDir) + '/' + linkName});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

