/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeWalker {
    private Direction direction = Direction.DOWN;
    private final TreeViewer treeViewer;
    private final Tree tree;
    private boolean expandNodes;

    public TreeWalker(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.tree = treeViewer.getTree();
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean getExpandNodes() {
        return this.expandNodes;
    }

    private TreePath getTreePath(TreeItem item) {
        ArrayList<Object> path = new ArrayList<Object>();
        do {
            path.add(0, item.getData());
        } while ((item = item.getParentItem()) != null);
        return new TreePath(path.toArray());
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setExpandNodes(boolean expandNodes) {
        this.expandNodes = expandNodes;
    }

    private TreePath visitChildren(TreeViewer viewer, TreePath itemPath, TreeItem item, TreeVisitor visitor) {
        boolean restoreCollapsedState = false;
        try {
            TreePath childPath;
            TreeItem[] children;
            boolean expandedState;
            if (this.getExpandNodes() && !(expandedState = item.getExpanded())) {
                restoreCollapsedState = true;
                viewer.setExpandedState((Object)itemPath, true);
            }
            if ((children = item.getItems()).length > 0 && children[0].getData() != null && (childPath = this.visitItems(viewer, itemPath, children, null, visitor)) != null) {
                TreePath treePath = childPath;
                return treePath;
            }
        }
        finally {
            if (restoreCollapsedState) {
                viewer.setExpandedState((Object)itemPath, false);
            }
        }
        return null;
    }

    private TreePath visitItems(TreeViewer viewer, TreePath parentPath, TreeItem[] items, TreeItem visitedItem, TreeVisitor visitor) {
        TreeItem parent;
        if (this.direction == Direction.UP) {
            Collections.reverse(Arrays.asList(items));
        }
        boolean found = visitedItem == null;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (!found) {
                if (item == visitedItem) {
                    found = true;
                }
            } else {
                TreePath itemPath = parentPath.createChildPath(item.getData());
                if (this.direction == Direction.DOWN && visitor.visit(item.getData())) {
                    return itemPath;
                }
                TreePath childPath = this.visitChildren(viewer, itemPath, item, visitor);
                if (childPath != null) {
                    return childPath;
                }
                if (this.direction == Direction.UP && visitor.visit(item.getData())) {
                    return itemPath;
                }
            }
            ++n2;
        }
        if (visitedItem != null && (parent = visitedItem.getParentItem()) != null) {
            if (this.direction == Direction.UP && visitor.visit(parent.getData())) {
                return parentPath;
            }
            return this.visitSiblings(viewer, parent, visitor);
        }
        return null;
    }

    private TreePath visitSiblings(TreeViewer viewer, TreeItem item, TreeVisitor visitor) {
        TreePath path;
        TreeItem[] siblings;
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            siblings = parent.getItems();
            path = this.getTreePath(parent);
        } else {
            siblings = viewer.getTree().getItems();
            path = TreePath.EMPTY;
        }
        return this.visitItems(viewer, path, siblings, item, visitor);
    }

    public TreePath walk(TreeVisitor visitor, TreeItem startItem) {
        TreePath path = null;
        if (startItem != null) {
            if (this.direction == Direction.DOWN) {
                path = this.visitChildren(this.treeViewer, this.getTreePath(startItem), startItem, visitor);
            }
            if (path == null) {
                path = this.visitSiblings(this.treeViewer, startItem, visitor);
            }
        } else {
            path = this.visitItems(this.treeViewer, TreePath.EMPTY, this.tree.getItems(), null, visitor);
        }
        return path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP,
        DOWN;

    }

    public static abstract class TreeVisitor {
        public abstract boolean visit(Object var1);
    }
}

