/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.AbstractDebugCheckboxSelectionDialog;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class SaveScopeResourcesHandler
implements IStatusHandler {
    Object[] fSaves = null;
    static /* synthetic */ Class class$0;

    public Object handleStatus(IStatus status, Object source) throws CoreException {
        Object[] objects;
        ILaunchConfiguration config = null;
        IProject[] projects = null;
        if (source instanceof Object[] && (objects = (Object[])source).length == 2) {
            config = (ILaunchConfiguration)objects[0];
            projects = (IProject[])objects[1];
        }
        if (config != null && DebugUITools.isPrivate(config)) {
            return Boolean.TRUE;
        }
        if (projects != null) {
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            String save = store.getString("org.eclipse.debug.ui.save_dirty_editors_before_launch");
            int ret = this.showSaveDialog(projects, !save.equals("never"), save.equals("prompt"));
            if (ret == 0) {
                this.doSave();
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        boolean cancel = DebugUIPlugin.preLaunchSave();
        return cancel;
    }

    protected IEditorPart[] getScopedDirtyEditors(IProject[] projects) {
        ArrayList<IEditorPart> dirtyparts = new ArrayList<IEditorPart>();
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int l = 0;
        while (l < windows.length) {
            IWorkbenchPage[] pages = windows[l].getPages();
            int i = 0;
            while (i < pages.length) {
                IEditorPart[] eparts = pages[i].getDirtyEditors();
                int j = 0;
                while (j < eparts.length) {
                    IResource resource;
                    IEditorInput iEditorInput = eparts[j].getEditorInput();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((resource = (IResource)iEditorInput.getAdapter((Class)clazz)) != null) {
                        int k = 0;
                        while (k < projects.length) {
                            if (projects[k].equals((Object)resource.getProject()) & !dirtyparts.contains(eparts[j])) {
                                dirtyparts.add(eparts[j]);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++l;
        }
        return dirtyparts.toArray(new IEditorPart[dirtyparts.size()]);
    }

    protected void doSave() {
        if (this.fSaves != null) {
            int i = 0;
            while (i < this.fSaves.length) {
                ((IEditorPart)this.fSaves[i]).doSave((IProgressMonitor)new NullProgressMonitor());
                ++i;
            }
        }
    }

    protected int showSaveDialog(IProject[] projects, boolean save, boolean prompt) {
        if (save) {
            Object[] editors = this.getScopedDirtyEditors(projects);
            if (prompt && editors.length > 0) {
                ScopedResourcesSelectionDialog lsd = new ScopedResourcesSelectionDialog(DebugUIPlugin.getShell(), new AdaptableList((IAdaptable[])editors), (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider());
                lsd.setInitialSelections(editors);
                lsd.setTitle(LaunchConfigurationsMessages.SaveScopeResourcesHandler_3);
                if (lsd.open() == 1) {
                    return 1;
                }
                this.fSaves = lsd.getResult();
            } else {
                this.fSaves = editors;
            }
        }
        return 0;
    }

    class ScopedResourcesSelectionDialog
    extends AbstractDebugCheckboxSelectionDialog {
        private final String SETTINGS_ID = "org.eclipse.debug.ui.SCOPED_SAVE_SELECTION_DIALOG";
        Button fSavePref;
        Object fInput;
        IStructuredContentProvider fContentProvider;
        ILabelProvider fLabelProvider;

        public ScopedResourcesSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
            super(parentShell);
            this.fInput = input;
            this.fContentProvider = contentProvider;
            this.fLabelProvider = labelProvider;
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.setShowSelectAllButtons(true);
        }

        protected IContentProvider getContentProvider() {
            return this.fContentProvider;
        }

        protected IBaseLabelProvider getLabelProvider() {
            return this.fLabelProvider;
        }

        protected String getDialogSettingsId() {
            return "org.eclipse.debug.ui.SCOPED_SAVE_SELECTION_DIALOG";
        }

        protected String getHelpContextId() {
            return "org.eclipse.debug.ui.select_resources_to_save_dialog";
        }

        protected Object getViewerInput() {
            return this.fInput;
        }

        protected String getViewerLabel() {
            return LaunchConfigurationsMessages.SaveScopeResourcesHandler_2;
        }

        protected void addCustomFooterControls(Composite parent) {
            super.addCustomFooterControls(parent);
            this.fSavePref = new Button(parent, 32);
            this.fSavePref.setText(LaunchConfigurationsMessages.SaveScopeResourcesHandler_1);
            this.fSavePref.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ScopedResourcesSelectionDialog this$1;
                {
                    this.this$1 = scopedResourcesSelectionDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    ScopedResourcesSelectionDialog.access$0(this.this$1).setAllChecked(this.this$1.fSavePref.getSelection());
                }
            });
        }

        protected void okPressed() {
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            String val = this.fSavePref.getSelection() ? "always" : "prompt";
            store.setValue("org.eclipse.debug.ui.save_dirty_editors_before_launch", val);
            super.okPressed();
        }

        protected void addViewerListeners(StructuredViewer viewer) {
        }

        protected boolean isValid() {
            return true;
        }

        static /* synthetic */ CheckboxTableViewer access$0(ScopedResourcesSelectionDialog scopedResourcesSelectionDialog) {
            return scopedResourcesSelectionDialog.getCheckBoxTableViewer();
        }
    }
}

