/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Activator;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Permissions;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Zip;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.LinkAction;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.Touchpoint;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointType;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class NativeTouchpoint
extends Touchpoint {
    private static final String PARM_TARGET_FILE = "targetFile";
    private static final String PARM_PERMISSIONS = "permissions";
    private static final String PARM_TARGET_DIR = "targetDir";
    private static final String PARM_TARGET = "target";
    private static final String ACTION_CHMOD = "chmod";
    private static final String PARM_IU = "iu";
    private static final String PIPE = "|";
    private static final String PARM_SOURCE = "source";
    private static final String PARM_ARTIFACT = "@artifact";
    private static final String PARM_INSTALL_FOLDER = "installFolder";
    private static final String NATIVE_TOUCHPOINT_TYPE = "org.eclipse.equinox.p2.native";
    private static final String ACTION_CLEANUPZIP = "cleanupzip";
    private static final String ACTION_UNZIP = "unzip";
    private static final String PARM_ARTIFACT_REQUESTS = "artifactRequests";
    private static final String PARM_OPERAND = "operand";
    private static final String PARM_PROFILE = "profile";
    private static final String ACTION_COLLECT = "collect";
    private static final String ID = "org.eclipse.equinox.p2.touchpoint.natives";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected static IStatus createError(String message) {
        return new Status(4, ID, message);
    }

    public ProvisioningAction getAction(String actionId) {
        if (actionId.equals(ACTION_COLLECT)) {
            return new ProvisioningAction(){

                public IStatus execute(Map parameters) {
                    IProfile profile = (IProfile)parameters.get(NativeTouchpoint.PARM_PROFILE);
                    InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get(NativeTouchpoint.PARM_OPERAND);
                    try {
                        IArtifactRequest[] requests = NativeTouchpoint.this.collect(operand.second(), profile);
                        Collection artifactRequests = (Collection)parameters.get(NativeTouchpoint.PARM_ARTIFACT_REQUESTS);
                        artifactRequests.add(requests);
                    }
                    catch (ProvisionException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }

                public IStatus undo(Map parameters) {
                    return Status.OK_STATUS;
                }
            };
        }
        if (actionId.equals(ACTION_UNZIP)) {
            return new ProvisioningAction(){

                public IStatus execute(Map parameters) {
                    return NativeTouchpoint.this.unzip(parameters);
                }

                public IStatus undo(Map parameters) {
                    return NativeTouchpoint.this.cleanupzip(parameters);
                }
            };
        }
        if (actionId.equals(ACTION_CLEANUPZIP)) {
            return new ProvisioningAction(){

                public IStatus execute(Map parameters) {
                    return NativeTouchpoint.this.cleanupzip(parameters);
                }

                public IStatus undo(Map parameters) {
                    return NativeTouchpoint.this.unzip(parameters);
                }
            };
        }
        if (actionId.equals(ACTION_CHMOD)) {
            return new ProvisioningAction(){

                public IStatus execute(Map parameters) {
                    String targetDir = (String)parameters.get(NativeTouchpoint.PARM_TARGET_DIR);
                    if (targetDir == null) {
                        return NativeTouchpoint.createError(NLS.bind((String)Messages.param_not_set, (Object)NativeTouchpoint.PARM_TARGET_DIR, (Object)NativeTouchpoint.ACTION_CHMOD));
                    }
                    String targetFile = (String)parameters.get(NativeTouchpoint.PARM_TARGET_FILE);
                    if (targetFile == null) {
                        return NativeTouchpoint.createError(NLS.bind((String)Messages.param_not_set, (Object)NativeTouchpoint.PARM_TARGET_FILE, (Object)NativeTouchpoint.ACTION_CHMOD));
                    }
                    String permissions = (String)parameters.get(NativeTouchpoint.PARM_PERMISSIONS);
                    if (permissions == null) {
                        return NativeTouchpoint.createError(NLS.bind((String)Messages.param_not_set, (Object)NativeTouchpoint.PARM_PERMISSIONS, (Object)NativeTouchpoint.ACTION_CHMOD));
                    }
                    new Permissions().chmod(targetDir, targetFile, permissions);
                    return Status.OK_STATUS;
                }

                public IStatus undo(Map parameters) {
                    return Status.OK_STATUS;
                }
            };
        }
        if (actionId.equals("ln")) {
            return new LinkAction();
        }
        return null;
    }

    public TouchpointType getTouchpointType() {
        return MetadataFactory.createTouchpointType((String)NATIVE_TOUCHPOINT_TYPE, (Version)new Version(1, 0, 0));
    }

    IArtifactRequest[] collect(IInstallableUnit installableUnit, IProfile profile) throws ProvisionException {
        IArtifactKey[] toDownload = installableUnit.getArtifacts();
        if (toDownload == null) {
            return new IArtifactRequest[0];
        }
        IFileArtifactRepository destination = NativeTouchpoint.getDownloadCacheRepo();
        IArtifactRequest[] requests = new IArtifactRequest[toDownload.length];
        int count = 0;
        int i = 0;
        while (i < toDownload.length) {
            requests[count++] = NativeTouchpoint.getArtifactRepositoryManager().createMirrorRequest(toDownload[i], (IArtifactRepository)destination);
            ++i;
        }
        if (requests.length == count) {
            return requests;
        }
        IArtifactRequest[] result = new IArtifactRequest[count];
        System.arraycopy(requests, 0, result, 0, count);
        return result;
    }

    private String getInstallFolder(IProfile profile) {
        return profile.getProperty("org.eclipse.equinox.p2.installFolder");
    }

    private static AgentLocation getAgentLocation() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AgentLocation)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    private static IArtifactRepositoryManager getArtifactRepositoryManager() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    private static IFileArtifactRepository getDownloadCacheRepo() throws ProvisionException {
        IFileArtifactRepository downloadCache;
        Class<?> clazz;
        IArtifactRepository repository;
        URL location = NativeTouchpoint.getDownloadCacheLocation();
        if (location == null) {
            throw new IllegalStateException(Messages.could_not_obtain_download_cache);
        }
        IArtifactRepositoryManager manager = NativeTouchpoint.getArtifactRepositoryManager();
        if (manager == null) {
            throw new IllegalStateException(Messages.artifact_repo_not_found);
        }
        try {
            repository = manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            String repositoryName = location + " - Agent download cache";
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("p2.system", Boolean.TRUE.toString());
            repository = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((downloadCache = (IFileArtifactRepository)repository.getAdapter((Class)clazz)) == null) {
            throw new ProvisionException(NLS.bind((String)Messages.download_cache_not_writeable, (Object)location));
        }
        return downloadCache;
    }

    private static URL getDownloadCacheLocation() {
        AgentLocation location = NativeTouchpoint.getAgentLocation();
        return location != null ? location.getArtifactRepositoryURL() : null;
    }

    public IStatus initializePhase(IProgressMonitor monitor, IProfile profile, String phaseId, Map touchpointParameters) {
        touchpointParameters.put(PARM_INSTALL_FOLDER, this.getInstallFolder(profile));
        return null;
    }

    IStatus unzip(Map parameters) {
        String source = (String)parameters.get(PARM_SOURCE);
        if (source == null) {
            return NativeTouchpoint.createError(NLS.bind((String)Messages.param_not_set, (Object)PARM_SOURCE, (Object)ACTION_UNZIP));
        }
        String originalSource = source;
        String target = (String)parameters.get(PARM_TARGET);
        if (target == null) {
            return NativeTouchpoint.createError(NLS.bind((String)Messages.param_not_set, (Object)PARM_TARGET, (Object)ACTION_UNZIP));
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get(PARM_IU);
        Profile profile = (Profile)parameters.get(PARM_PROFILE);
        if (source.equals(PARM_ARTIFACT)) {
            IFileArtifactRepository downloadCache;
            if (iu.getArtifacts() == null || iu.getArtifacts().length == 0) {
                return Status.OK_STATUS;
            }
            IArtifactKey artifactKey = iu.getArtifacts()[0];
            try {
                downloadCache = NativeTouchpoint.getDownloadCacheRepo();
            }
            catch (ProvisionException e) {
                return e.getStatus();
            }
            File fileLocation = downloadCache.getArtifactFile(artifactKey);
            if (fileLocation == null || !fileLocation.exists()) {
                return NativeTouchpoint.createError(NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = fileLocation.getAbsolutePath();
        }
        File[] unzippedFiles = new Zip().unzip(source, target, null);
        StringBuffer unzippedFileNameBuffer = new StringBuffer();
        int i = 0;
        while (i < unzippedFiles.length) {
            unzippedFileNameBuffer.append(unzippedFiles[i].getAbsolutePath()).append(PIPE);
            ++i;
        }
        profile.setInstallableUnitProperty(iu, "unzipped|" + originalSource + PIPE + target, unzippedFileNameBuffer.toString());
        return Status.OK_STATUS;
    }

    protected IStatus cleanupzip(Map parameters) {
        String source = (String)parameters.get(PARM_SOURCE);
        if (source == null) {
            return NativeTouchpoint.createError(NLS.bind((String)Messages.param_not_set, (Object)PARM_SOURCE, (Object)ACTION_CLEANUPZIP));
        }
        String target = (String)parameters.get(PARM_TARGET);
        if (target == null) {
            return NativeTouchpoint.createError(NLS.bind((String)Messages.param_not_set, (Object)PARM_TARGET, (Object)ACTION_CLEANUPZIP));
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get(PARM_IU);
        IProfile profile = (IProfile)parameters.get(PARM_PROFILE);
        String unzipped = profile.getInstallableUnitProperty(iu, "unzipped|" + source + PIPE + target);
        if (unzipped == null) {
            return Status.OK_STATUS;
        }
        StringTokenizer tokenizer = new StringTokenizer(unzipped, PIPE);
        ArrayList<File> directories = new ArrayList<File>();
        while (tokenizer.hasMoreTokens()) {
            String fileName = tokenizer.nextToken();
            File file = new File(fileName);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                directories.add(file);
                continue;
            }
            file.delete();
        }
        Iterator it = directories.iterator();
        while (it.hasNext()) {
            File directory = (File)it.next();
            directory.delete();
        }
        return Status.OK_STATUS;
    }
}

