/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup.containers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;

public abstract class AbstractSourceContainer
extends PlatformObject
implements ISourceContainer {
    public static final Object[] EMPTY = new Object[0];
    private ISourceLookupDirector fDirector;

    protected void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 125, message, exception);
        throw new CoreException((IStatus)status);
    }

    protected void warn(String message, Throwable exception) throws CoreException {
        Status status = new Status(2, DebugPlugin.getUniqueIdentifier(), 125, message, exception);
        throw new CoreException((IStatus)status);
    }

    public void dispose() {
        this.fDirector = null;
    }

    public ISourceContainer[] getSourceContainers() throws CoreException {
        return new ISourceContainer[0];
    }

    public boolean isComposite() {
        return false;
    }

    public void init(ISourceLookupDirector director) {
        this.fDirector = director;
    }

    protected ISourceLookupDirector getDirector() {
        return this.fDirector;
    }

    protected boolean isFindDuplicates() {
        if (this.getDirector() != null) {
            return this.getDirector().isFindDuplicates();
        }
        return false;
    }

    protected ISourceContainerType getSourceContainerType(String id) {
        return DebugPlugin.getDefault().getLaunchManager().getSourceContainerType(id);
    }
}

