/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectFacetsUiManagerImpl {
    private static final String WIZARD_PAGES_EXTENSION_ID = "wizardPages";
    private static final String WIZARD_PAGES_EXTENSION_ID_OLD = "wizard";
    private static final String IMAGES_EXTENSION_ID = "images";
    private static final String EL_WIZARD_PAGES = "wizard-pages";
    private static final String EL_PAGE = "page";
    private static final String EL_IMAGE = "image";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_RUNTIME_COMPONENT_TYPE = "runtime-component-type";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_FACET = "facet";
    private static final String ATTR_ACTION = "action";
    private static final Map<String, WizardPagesInfo> wizardPages;
    private static final Map<Object, ImageDescriptor> icons;
    private static ImageDescriptor defaultIcon;

    static {
        icons = new HashMap<Object, ImageDescriptor>();
        ProjectFacetsManager.getProjectFacets();
        RuntimeManager.getRuntimeComponentTypes();
        wizardPages = new HashMap<String, WizardPagesInfo>();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.project.facet.ui");
        URL url = bundle.getEntry("images/unknown.gif");
        defaultIcon = ImageDescriptor.createFromURL((URL)url);
        ProjectFacetsUiManagerImpl.readWizardPagesExtensions();
        ProjectFacetsUiManagerImpl.readWizardPagesExtensionsOld();
        ProjectFacetsUiManagerImpl.readImagesExtensions();
    }

    private ProjectFacetsUiManagerImpl() {
    }

    public static ImageDescriptor getIcon(Object obj) {
        ImageDescriptor imgdesc = icons.get(obj);
        return imgdesc != null ? imgdesc : defaultIcon;
    }

    public static List<IFacetWizardPage> getWizardPages(String actionId) {
        WizardPagesInfo info = wizardPages.get(actionId);
        if (info != null) {
            return ProjectFacetsUiManagerImpl.getWizardPages(info.plugin, info.pages);
        }
        return Collections.emptyList();
    }

    public static List getWizardPages(IFacetedProject.Action.Type actionType, IProjectFacetVersion fv) {
        if (fv.supports(actionType)) {
            try {
                IActionDefinition def = ((ProjectFacetVersion)fv).getActionDefinition(actionType);
                return ProjectFacetsUiManagerImpl.getWizardPages(def.getId());
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static List<IFacetWizardPage> getWizardPages(String plugin, List<String> clnames) {
        ArrayList<IFacetWizardPage> pages = new ArrayList<IFacetWizardPage>();
        for (String clname : clnames) {
            try {
                pages.add((IFacetWizardPage)ProjectFacetsUiManagerImpl.create(plugin, clname));
            }
            catch (CoreException e) {
                FacetUiPlugin.log((Exception)((Object)e));
            }
        }
        return pages;
    }

    private static Object create(String plugin, String clname) throws CoreException {
        Bundle bundle = Platform.getBundle((String)plugin);
        try {
            Class cl = bundle.loadClass(clname);
            return cl.newInstance();
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Resources.failedToCreate, (Object)clname);
            IStatus st = FacetUiPlugin.createErrorStatus(msg, e);
            throw new CoreException(st);
        }
    }

    private static void readWizardPagesExtensions() {
        for (IConfigurationElement config : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"org.eclipse.wst.common.project.facet.ui", (String)WIZARD_PAGES_EXTENSION_ID))) {
            String ename = config.getName();
            if (!ename.equals(EL_WIZARD_PAGES)) continue;
            String action = config.getAttribute(ATTR_ACTION);
            if (action == null) {
                ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_ACTION);
                return;
            }
            String pluginId = config.getContributor().getName();
            if (ProjectFacetsManager.isActionDefined((String)action)) {
                WizardPagesInfo pagesInfo = new WizardPagesInfo();
                pagesInfo.plugin = pluginId;
                pagesInfo.pages = ProjectFacetsUiManagerImpl.readPageList(config);
                wizardPages.put(action, pagesInfo);
                continue;
            }
            String msg = NLS.bind((String)Resources.actionNotDefined, (Object)pluginId, (Object)action);
            FacetUiPlugin.logError(msg);
        }
    }

    private static void readWizardPagesExtensionsOld() {
        for (IConfigurationElement config : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"org.eclipse.wst.common.project.facet.ui", (String)WIZARD_PAGES_EXTENSION_ID_OLD))) {
            String ename = config.getName();
            if (!ename.equals(EL_WIZARD_PAGES)) continue;
            ProjectFacetsUiManagerImpl.readWizardPagesOld(config);
        }
    }

    private static void readWizardPagesOld(IConfigurationElement config) {
        String pluginId = config.getContributor().getName();
        String depMsg = NLS.bind((String)Resources.wizardExtensionPointDeprecated, (Object)pluginId);
        FacetUiPlugin.logWarning(depMsg, true);
        String id = config.getAttribute(ATTR_FACET);
        if (id == null) {
            ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_FACET);
            return;
        }
        if (!ProjectFacetsManager.isProjectFacetDefined((String)id)) {
            String msg = NLS.bind((String)Resources.facetNotDefined, (Object)config.getContributor().getName(), (Object)id);
            FacetUiPlugin.log(msg);
            return;
        }
        IProjectFacet f = ProjectFacetsManager.getProjectFacet((String)id);
        String version = config.getAttribute(ATTR_VERSION);
        if (version == null) {
            ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_VERSION);
            return;
        }
        if (!f.hasVersion(version)) {
            Object[] params = new String[]{config.getContributor().getName(), id, version};
            String msg = NLS.bind((String)Resources.facetVersionNotDefined, (Object[])params);
            FacetUiPlugin.log(msg);
            return;
        }
        IProjectFacetVersion fv = f.getVersion(version);
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            IFacetedProject.Action.Type actionType = IFacetedProject.Action.Type.valueOf((String)childName);
            if (actionType == null) {
                String msg = NLS.bind((String)Resources.invalidActionType, (Object)config.getContributor().getName(), (Object)childName);
                FacetUiPlugin.log(msg);
                return;
            }
            if (fv.supports(actionType)) {
                IActionDefinition def;
                try {
                    def = ((ProjectFacetVersion)fv).getActionDefinition(actionType);
                }
                catch (CoreException e) {
                    FacetUiPlugin.log((Exception)((Object)e));
                    return;
                }
                WizardPagesInfo pagesInfo = new WizardPagesInfo();
                pagesInfo.plugin = pluginId;
                pagesInfo.pages = ProjectFacetsUiManagerImpl.readPageList(child);
                wizardPages.put(def.getId(), pagesInfo);
            }
            ++i;
        }
    }

    private static List<String> readPageList(IConfigurationElement config) {
        ArrayList<String> list = new ArrayList<String>();
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_PAGE)) {
                String clname = child.getAttribute(ATTR_CLASS);
                if (clname == null) {
                    ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_CLASS);
                } else {
                    list.add(clname);
                }
            }
            ++i;
        }
        return list;
    }

    private static void readImagesExtensions() {
        for (IConfigurationElement config : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"org.eclipse.wst.common.project.facet.ui", (String)IMAGES_EXTENSION_ID))) {
            String plugin;
            Bundle bundle;
            URL url;
            IProjectFacet target;
            String msg;
            String ename = config.getName();
            if (!ename.equals(EL_IMAGE)) continue;
            String fid = config.getAttribute(ATTR_FACET);
            String cid = config.getAttribute(ATTR_CATEGORY);
            String rct = config.getAttribute(ATTR_RUNTIME_COMPONENT_TYPE);
            if (fid != null) {
                if (!ProjectFacetsManager.isProjectFacetDefined((String)fid)) {
                    msg = NLS.bind((String)Resources.facetNotDefined, (Object)config.getContributor().getName(), (Object)fid);
                    FacetUiPlugin.log(msg);
                    break;
                }
                target = ProjectFacetsManager.getProjectFacet((String)fid);
            } else if (cid != null) {
                if (!ProjectFacetsManager.isCategoryDefined((String)cid)) {
                    msg = NLS.bind((String)Resources.categoryNotDefined, (Object)config.getContributor().getName(), (Object)fid);
                    FacetUiPlugin.log(msg);
                    break;
                }
                target = ProjectFacetsManager.getCategory((String)cid);
            } else if (rct != null) {
                if (!RuntimeManager.isRuntimeComponentTypeDefined((String)rct)) {
                    msg = NLS.bind((String)Resources.runtimeComponentTypeNotDefined, (Object)config.getContributor().getName(), (Object)rct);
                    FacetUiPlugin.log(msg);
                    break;
                }
                target = RuntimeManager.getRuntimeComponentType((String)rct);
            } else {
                ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_FACET);
                break;
            }
            String path = config.getAttribute(ATTR_PATH);
            if (path == null) {
                ProjectFacetsUiManagerImpl.reportMissingAttribute(config, ATTR_PATH);
            }
            if ((url = FileLocator.find((Bundle)(bundle = Platform.getBundle((String)(plugin = config.getContributor().getName()))), (IPath)new Path(path), null)) == null) {
                String msg2 = NLS.bind((String)Resources.iconNotFound, (Object)plugin, (Object)path);
                FacetUiPlugin.log(msg2);
                continue;
            }
            ImageDescriptor imgdesc = ImageDescriptor.createFromURL((URL)url);
            icons.put(target, imgdesc);
        }
    }

    private static void reportMissingAttribute(IConfigurationElement el, String attribute) {
        Object[] params = new String[]{el.getContributor().getName(), el.getName(), attribute};
        String msg = NLS.bind((String)Resources.missingAttribute, (Object[])params);
        FacetUiPlugin.log(msg);
    }

    private static final class Resources
    extends NLS {
        public static String missingAttribute;
        public static String facetNotDefined;
        public static String facetVersionNotDefined;
        public static String categoryNotDefined;
        public static String runtimeComponentTypeNotDefined;
        public static String failedToCreate;
        public static String invalidActionType;
        public static String iconNotFound;
        public static String wizardExtensionPointDeprecated;
        public static String actionNotDefined;

        static {
            Resources.initializeMessages((String)ProjectFacetsUiManagerImpl.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static class WizardPagesInfo {
        public String plugin;
        public List<String> pages;

        private WizardPagesInfo() {
        }
    }
}

