/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validate;

import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.validate.ValidationAdapter;
import org.eclipse.wst.xml.core.internal.validate.ValidationComponent;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractPropagatingValidator
extends ValidationComponent {
    protected abstract ValidationComponent getPropagatee();

    protected abstract ValidationAdapter getValidator();

    public void validate(IndexedRegion node) {
        if (node == null) {
            return;
        }
        this.getValidator().validate(node);
        this.propagateToChildElements(this.getPropagatee(), (Node)node);
    }

    private void propagateToChildElements(ValidationComponent validator, Node parent) {
        if (parent == null) {
            return;
        }
        Class<?> clazz = validator.getClass();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child != null && child.getNodeType() == 1) {
                INodeNotifier notifier = (INodeNotifier)child;
                ValidationAdapter va = (ValidationAdapter)notifier.getExistingAdapter(clazz);
                if (va == null) {
                    notifier.addAdapter((INodeAdapter)validator);
                    va = validator;
                }
                va.setReporter(validator.getReporter());
                va.validate((IndexedRegion)child);
            }
            ++i;
        }
    }
}

