/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.CommitCommentArea;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.ui.PlatformUI;

public class CommitSetDialog
extends TitleAreaDialog {
    public static final short NEW = 0;
    public static final short EDIT = 1;
    private static final int DEFAULT_WIDTH_IN_CHARS = 80;
    private final ActiveChangeSet set;
    private CommitCommentArea commitCommentArea;
    private Text nameText;
    private Button useTitleButton;
    private Button enterCommentButton;
    private final String title;
    private final String description;
    private String comment;
    private short mode;

    public CommitSetDialog(Shell parentShell, ActiveChangeSet set, IResource[] files, short mode) {
        super(parentShell);
        this.set = set;
        this.mode = mode;
        this.title = mode == 0 ? CVSUIMessages.WorkspaceChangeSetCapability_2 : CVSUIMessages.WorkspaceChangeSetCapability_7;
        String string = this.description = mode == 0 ? CVSUIMessages.WorkspaceChangeSetCapability_3 : CVSUIMessages.WorkspaceChangeSetCapability_8;
        if (files == null) {
            files = set.getResources();
        }
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10 | 0x400);
        this.commitCommentArea = new CommitCommentArea();
        if (files.length > 0) {
            this.commitCommentArea.setProject(files[0].getProject());
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.title);
        this.setMessage(this.description);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        this.createNameArea(composite);
        if (this.hasCommitTemplate()) {
            if (this.set.hasComment()) {
                this.comment = this.set.getComment();
                this.commitCommentArea.setProposedComment(this.comment);
            }
        } else {
            this.comment = this.set.getComment();
            this.commitCommentArea.setProposedComment(this.comment);
            this.createOptionsArea(composite);
        }
        this.commitCommentArea.createArea(composite);
        this.commitCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "OkRequested") {
                    CommitSetDialog.this.okPressed();
                } else if (event.getProperty() == "CommentModified") {
                    CommitSetDialog.this.comment = (String)event.getNewValue();
                    CommitSetDialog.this.updateEnablements();
                }
            }
        });
        this.initializeValues();
        this.updateEnablements();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x = this.convertWidthInCharsToPixels(80);
        size.y += this.convertHeightInCharsToPixels(8);
        return size;
    }

    private void createNameArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(CVSUIMessages.CommitSetDialog_0);
        label.setLayoutData((Object)new GridData(1));
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommitSetDialog.this.updateEnablements();
            }
        });
    }

    private void initializeValues() {
        String initialText = this.set.getTitle();
        if (initialText == null) {
            initialText = "";
        }
        this.nameText.setText(initialText);
        this.nameText.setSelection(0, initialText.length());
        if (this.useTitleButton != null) {
            this.useTitleButton.setSelection(!this.set.hasComment());
            this.enterCommentButton.setSelection(this.set.hasComment());
        }
    }

    private void createOptionsArea(Composite composite) {
        Composite radioArea = new Composite(composite, 0);
        RowLayout radioAreaLayout = new RowLayout(512);
        radioAreaLayout.marginLeft = 0;
        radioAreaLayout.marginRight = 0;
        radioAreaLayout.marginTop = 0;
        radioAreaLayout.marginBottom = 0;
        radioArea.setLayout((Layout)radioAreaLayout);
        this.useTitleButton = this.createRadioButton(radioArea, CVSUIMessages.CommitSetDialog_2);
        this.enterCommentButton = this.createRadioButton(radioArea, CVSUIMessages.CommitSetDialog_3);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitSetDialog.this.updateEnablements();
            }
        };
        this.useTitleButton.addSelectionListener((SelectionListener)listener);
        this.enterCommentButton.addSelectionListener((SelectionListener)listener);
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setText(label);
        return button;
    }

    private void updateEnablements() {
        this.commitCommentArea.setEnabled(this.isUseCustomComment());
        this.setErrorMessage(null);
        String name = this.nameText.getText();
        if (name.length() == 0) {
            this.setPageComplete(false);
            return;
        }
        if (this.mode == 0 && CVSUIPlugin.getPlugin().getChangeSetManager().getSet(name) != null) {
            this.setPageComplete(false);
            this.setErrorMessage(CVSUIMessages.WorkspaceChangeSetCapability_9);
            return;
        }
        if (this.mode == 1 && !name.equals(this.set.getName()) && CVSUIPlugin.getPlugin().getChangeSetManager().getSet(name) != null) {
            this.setPageComplete(false);
            this.setErrorMessage(CVSUIMessages.WorkspaceChangeSetCapability_9);
            return;
        }
        if (this.isUseCustomComment() && (this.comment == null || this.comment.length() == 0)) {
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    protected final void setPageComplete(boolean complete) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(complete);
        }
    }

    private boolean hasCommitTemplate() {
        return this.commitCommentArea.hasCommitTemplate();
    }

    protected void okPressed() {
        this.set.setTitle(this.nameText.getText());
        if (this.isUseCustomComment()) {
            this.set.setComment(this.commitCommentArea.getComment(true));
        } else {
            this.set.setComment(null);
        }
        super.okPressed();
    }

    private boolean isUseCustomComment() {
        return this.enterCommentButton == null || this.enterCommentButton.getSelection();
    }

    protected Label createWrappingLabel(Composite parent, String text) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 200;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.updateEnablements();
        return control;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.team.cvs.ui.commit_set_dialog_context");
    }
}

