/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.TypeDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.APTProblem;
import org.eclipse.jdt.apt.core.internal.env.AbstractCompilationEnv;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.env.BuildFilerImpl;
import org.eclipse.jdt.apt.core.internal.env.EnvUtil;
import org.eclipse.jdt.apt.core.internal.env.MarkerInfo;
import org.eclipse.jdt.apt.core.internal.env.MessagerImpl;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.apt.core.internal.util.Visitors;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildEnv
extends AbstractCompilationEnv {
    private boolean _hasRaisedErrors = false;
    private final BuildFilerImpl _filer;
    private Set<String> _typeDependencies = new HashSet<String>();
    private boolean _batchMode = false;
    private BuildContext[] _filesWithAnnotation = null;
    private BuildContext[] _additionFiles = null;
    private CompilationUnit[] _astRoots = null;
    private List<MarkerInfo> _markerInfos = null;

    BuildEnv(BuildContext[] filesWithAnnotations, BuildContext[] additionalFiles, IJavaProject javaProj) {
        super(null, null, javaProj, Phase.BUILD);
        this._filer = new BuildFilerImpl(this);
        this._filesWithAnnotation = filesWithAnnotations;
        this._additionFiles = additionalFiles;
        this._problems = new ArrayList();
        this._markerInfos = new ArrayList<MarkerInfo>();
        if (AptPlugin.DEBUG_COMPILATION_ENV) {
            AptPlugin.trace("constructed " + this + " for " + this._filesWithAnnotation.length + " files");
        }
    }

    @Override
    public Filer getFiler() {
        this.checkValid();
        return this._filer;
    }

    @Override
    public PackageDeclaration getPackage(String name) {
        this.checkValid();
        return super.getPackage(name);
    }

    @Override
    public TypeDeclaration getTypeDeclaration(String name) {
        this.checkValid();
        TypeDeclaration decl = super.getTypeDeclaration(name);
        if (!this._batchMode) {
            this.addTypeDependency(name);
        }
        return decl;
    }

    public boolean hasRaisedErrors() {
        return this._hasRaisedErrors;
    }

    public static InputStreamReader getFileReader(IFile file) throws IOException, CoreException {
        return new InputStreamReader(BuildEnv.getInputStream(file), file.getCharset());
    }

    public static InputStream getInputStream(IFile file) throws IOException, CoreException {
        return new BufferedInputStream(file.getContents());
    }

    public boolean hasGeneratedClassFiles() {
        return this._filer.hasGeneratedClassFile();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this._markerInfos = null;
        this._astRoot = null;
        this._file = null;
        this._astRoots = null;
        this._filesWithAnnotation = null;
        this._problems = null;
        this._modelCompUnit2astCompUnit.clear();
        this._hasRaisedErrors = false;
        super.close();
    }

    @Override
    void addMessage(IFile resource, int start, int end, MessagerImpl.Severity severity, String msg, int line, String[] arguments) {
        this.checkValid();
        if (resource == null) {
            resource = this.getFile();
        }
        this._hasRaisedErrors |= severity == MessagerImpl.Severity.ERROR;
        if (severity == MessagerImpl.Severity.INFO) {
            StringBuilder sb = new StringBuilder();
            sb.append("Informational message reported by annotation processor:\n");
            sb.append(msg);
            sb.append("\n");
            if (resource != null) {
                sb.append("Resource=");
                sb.append(resource.getName());
                sb.append("; ");
            }
            sb.append("starting offset=");
            sb.append(start);
            sb.append("; ending offset=");
            sb.append(end);
            sb.append("; line=");
            sb.append(line);
            if (arguments != null) {
                sb.append("; arguments:");
                String[] stringArray = arguments;
                int n = arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    sb.append("\n");
                    sb.append(s);
                    ++n2;
                }
            } else {
                sb.append("\n");
            }
            Status status = AptPlugin.createInfoStatus(null, sb.toString());
            AptPlugin.log((IStatus)status);
            return;
        }
        if (resource == null) {
            assert (this._batchMode) : "not in batch mode but don't know about current resource";
            this.addMarker(start, end, severity, msg, line, arguments);
        } else {
            this.addProblem(resource, start, end, severity, msg, line, arguments);
        }
    }

    private void addProblem(IFile resource, int start, int end, MessagerImpl.Severity severity, String msg, int line, String[] arguments) {
        APTProblem problem = this.createProblem(resource, start, end, severity, msg, line, arguments);
        this._problems.add(problem);
    }

    private void addMarker(int start, int end, MessagerImpl.Severity severity, String msg, int line, String[] arguments) {
        this._markerInfos.add(new MarkerInfo(start, end, severity, msg, line));
    }

    @Override
    public Map<String, AnnotationTypeDeclaration> getAnnotationTypes() {
        this.checkValid();
        assert (this._astRoot != null && this._file != null && !this._batchMode) : "operation not available under batch mode.";
        return super.getAnnotationTypes();
    }

    public Map<String, AnnotationTypeDeclaration> getAllAnnotationTypes(Map<BuildContext, Set<AnnotationTypeDeclaration>> file2Annotations) {
        this.checkValid();
        if (this._filesWithAnnotation == null) {
            return this.getAnnotationTypes();
        }
        ArrayList<Annotation> instances = new ArrayList<Annotation>();
        HashMap<String, AnnotationTypeDeclaration> decls = new HashMap<String, AnnotationTypeDeclaration>();
        Visitors.AnnotationVisitor visitor = new Visitors.AnnotationVisitor(instances);
        int astIndex = 0;
        int len = this._astRoots.length;
        while (astIndex < len) {
            if (this._astRoots == null || this._astRoots[astIndex] == null) {
                System.err.println();
            }
            this._astRoots[astIndex].accept((ASTVisitor)visitor);
            HashSet<AnnotationTypeDeclaration> perFileAnnos = new HashSet<AnnotationTypeDeclaration>();
            int instanceIndex = 0;
            int size = instances.size();
            while (instanceIndex < size) {
                TypeDeclarationImpl decl;
                Annotation instance = (Annotation)instances.get(instanceIndex);
                ITypeBinding annoType = instance.resolveTypeBinding();
                if (annoType != null && (decl = Factory.createReferenceType(annoType, this)).kind() == EclipseMirrorObject.MirrorKind.TYPE_ANNOTATION) {
                    AnnotationTypeDeclaration annoDecl = (AnnotationTypeDeclaration)((Object)decl);
                    decls.put(annoDecl.getQualifiedName(), annoDecl);
                    perFileAnnos.add(annoDecl);
                }
                ++instanceIndex;
            }
            if (file2Annotations != null && !perFileAnnos.isEmpty()) {
                file2Annotations.put(this._filesWithAnnotation[astIndex], perFileAnnos);
            }
            visitor.reset();
            ++astIndex;
        }
        return decls;
    }

    public Set<String> getTypeDependencies() {
        return this._typeDependencies;
    }

    public void beginBatchProcessing() {
        if (this._phase != Phase.BUILD) {
            throw new IllegalStateException("No batch processing outside build.");
        }
        if (this._batchMode) {
            return;
        }
        this.checkValid();
        this._batchMode = true;
        this._file = null;
        this._astRoot = null;
    }

    public void completedBatchProcessing() {
        this.postMarkers();
        this.completedProcessing();
    }

    void createASTs(BuildContext[] cpResults) {
        int len = cpResults.length;
        ICompilationUnit[] units = new ICompilationUnit[len];
        int i = 0;
        while (i < len) {
            units[i] = JavaCore.createCompilationUnitFrom((IFile)cpResults[i].getFile());
            ++i;
        }
        this._requestor = new CallbackRequestor(units);
        BuildEnv.createASTs(this._javaProject, units, this._requestor);
    }

    public void beginFileProcessing(BuildContext result) {
        if (result == null) {
            throw new IllegalStateException("missing compilation result");
        }
        this._batchMode = false;
        IFile file = result.getFile();
        if (file.equals((Object)this._file)) {
            return;
        }
        this._astRoot = null;
        this._file = null;
        if (this._filesWithAnnotation != null) {
            int i = 0;
            int len = this._filesWithAnnotation.length;
            while (i < len) {
                if (file.equals((Object)this._filesWithAnnotation[i].getFile())) {
                    this._file = file;
                    this._astRoot = this._astRoots[i];
                }
                ++i;
            }
        }
        if (this._file == null || this._astRoot == null) {
            throw new IllegalStateException("file " + file.getName() + " is not in the list to be processed.");
        }
    }

    public void completedFileProcessing() {
        this.completedProcessing();
    }

    @Override
    protected void completedProcessing() {
        this._problems.clear();
        this._typeDependencies.clear();
        super.completedProcessing();
    }

    @Override
    public List<? extends CategorizedProblem> getProblems() {
        if (!this._problems.isEmpty()) {
            EnvUtil.updateProblemLength(this._problems, this.getAstCompilationUnit());
        }
        return this._problems;
    }

    @Override
    public CompilationUnit getAST() {
        if (this._batchMode) {
            return null;
        }
        return this._astRoot;
    }

    @Override
    public void addTypeDependency(String fullyQualifiedTypeName) {
        if (!this._batchMode) {
            this._typeDependencies.add(fullyQualifiedTypeName);
        }
    }

    @Override
    protected List<AbstractTypeDeclaration> searchLocallyForTypeDeclarations() {
        if (!this._batchMode) {
            return super.searchLocallyForTypeDeclarations();
        }
        ArrayList<AbstractTypeDeclaration> typeDecls = new ArrayList<AbstractTypeDeclaration>();
        int i = 0;
        int len = this._astRoots.length;
        while (i < len) {
            typeDecls.addAll(this._astRoots[i].types());
            ++i;
        }
        this.getTypeDeclarationsFromAdditionFiles(typeDecls);
        return typeDecls;
    }

    private void getTypeDeclarationsFromAdditionFiles(List<AbstractTypeDeclaration> typeDecls) {
        CompilationUnit[] asts;
        if (this._additionFiles == null || this._additionFiles.length == 0) {
            return;
        }
        int len = this._additionFiles.length;
        ICompilationUnit[] units = new ICompilationUnit[len];
        int i = 0;
        while (i < len) {
            units[i] = JavaCore.createCompilationUnitFrom((IFile)this._additionFiles[i].getFile());
            ++i;
        }
        BaseProcessorEnv.BaseRequestor r = new BaseProcessorEnv.BaseRequestor(units);
        BuildEnv.createASTs(this._javaProject, units, r);
        CompilationUnit[] compilationUnitArray = asts = r.asts;
        int n = asts.length;
        int n2 = 0;
        while (n2 < n) {
            CompilationUnit ast = compilationUnitArray[n2];
            if (ast != null) {
                typeDecls.addAll(ast.types());
            }
            ++n2;
        }
    }

    @Override
    protected Map<ASTNode, List<Annotation>> getASTNodesWithAnnotations() {
        if (!this._batchMode) {
            return super.getASTNodesWithAnnotations();
        }
        HashMap<ASTNode, List<Annotation>> astNode2Anno = new HashMap<ASTNode, List<Annotation>>();
        Visitors.AnnotatedNodeVisitor visitor = new Visitors.AnnotatedNodeVisitor(astNode2Anno);
        int i = 0;
        int len = this._astRoots.length;
        while (i < len) {
            this._astRoots[i].accept((ASTVisitor)visitor);
            ++i;
        }
        return astNode2Anno;
    }

    @Override
    protected IFile getFileForNode(ASTNode node) {
        if (!this._batchMode) {
            return super.getFileForNode(node);
        }
        CompilationUnit curAST = (CompilationUnit)node.getRoot();
        int i = 0;
        int len = this._astRoots.length;
        while (i < len) {
            if (this._astRoots[i] == curAST) {
                return this._filesWithAnnotation[i].getFile();
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    @Override
    protected CompilationUnit searchLocallyForBinding(IBinding binding) {
        if (!this._batchMode) {
            return super.searchLocallyForBinding(binding);
        }
        int i = 0;
        int len = this._astRoots.length;
        while (i < len) {
            ASTNode node = this._astRoots[i].findDeclaringNode(binding);
            if (node != null) {
                return this._astRoots[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    protected IFile searchLocallyForIFile(IBinding binding) {
        if (!this._batchMode) {
            return super.searchLocallyForIFile(binding);
        }
        int i = 0;
        int len = this._astRoots.length;
        while (i < len) {
            ASTNode node = this._astRoots[i].findDeclaringNode(binding);
            if (node != null) {
                return this._filesWithAnnotation[i].getFile();
            }
            ++i;
        }
        return null;
    }

    @Override
    public CompilationUnit getASTFrom(IFile file) {
        if (file == null) {
            return null;
        }
        if (file.equals((Object)this._file)) {
            return this._astRoot;
        }
        if (this._astRoots != null) {
            int i = 0;
            int len = this._filesWithAnnotation.length;
            while (i < len) {
                if (file.equals((Object)this._filesWithAnnotation[i].getFile())) {
                    return this._astRoots[i];
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    protected AST getCurrentDietAST() {
        if (this._astRoot != null) {
            return this._astRoot.getAST();
        }
        if (this._astRoots == null) {
            throw new IllegalStateException("no AST is available");
        }
        return this._astRoots[0].getAST();
    }

    void postMarkers() {
        if (this._markerInfos == null || this._markerInfos.size() == 0) {
            return;
        }
        try {
            try {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) {
                        for (MarkerInfo markerInfo : BuildEnv.this._markerInfos) {
                            try {
                                IMarker marker = BuildEnv.this._javaProject.getProject().createMarker("org.eclipse.jdt.apt.core.marker");
                                markerInfo.copyIntoMarker(marker);
                            }
                            catch (CoreException e) {
                                AptPlugin.log(e, "Failure posting markers");
                            }
                        }
                    }
                };
                IWorkspace ws = this._javaProject.getProject().getWorkspace();
                ws.run(runnable, null);
            }
            catch (CoreException e) {
                AptPlugin.log(e, "Failed to post markers");
                this._markerInfos.clear();
            }
        }
        finally {
            this._markerInfos.clear();
        }
    }

    public BuildContext[] getFilesWithAnnotation() {
        return this._filesWithAnnotation;
    }

    public BuildContext[] getFilesWithoutAnnotation() {
        return this._additionFiles;
    }

    private class CallbackRequestor
    extends BaseProcessorEnv.BaseRequestor {
        CallbackRequestor(ICompilationUnit[] parseUnits) {
            super(parseUnits);
        }

        public void acceptBinding(String bindingKey, IBinding binding) {
            BuildEnv.this._astRoots = this.asts;
            BuildEnv.this._callback.run(BuildEnv.this);
        }
    }
}

