/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.web.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;

public class GzipPostMethod
extends PostMethod {
    private boolean gzipWanted;
    private boolean gzipReceived;

    public GzipPostMethod(String requestPath, boolean gzipWanted) {
        super(requestPath);
        this.gzipWanted = gzipWanted;
    }

    private boolean isZippedReply() {
        boolean zipped = this.getResponseHeader("Content-encoding") != null && this.getResponseHeader("Content-encoding").getValue().equals("gzip") || this.getResponseHeader("Content-Type") != null && this.getResponseHeader("Content-Type").getValue().equals("application/x-gzip");
        return zipped;
    }

    public int execute(HttpState state, HttpConnection conn) throws HttpException, IOException {
        if (this.gzipWanted) {
            this.setRequestHeader("Accept-encoding", "gzip");
        }
        int result = super.execute(state, conn);
        this.gzipReceived = this.isZippedReply();
        return result;
    }

    public void getResponseBodyNoop() throws IOException {
        super.getResponseBody();
    }

    public InputStream getResponseBodyAsUnzippedStream() throws IOException {
        InputStream input = super.getResponseBodyAsStream();
        if (this.gzipReceived) {
            try {
                return new GZIPInputStream(input);
            }
            catch (IOException iOException) {}
        }
        return input;
    }
}

