/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.tasklist;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskListFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaTaskListFactory
extends AbstractTaskListFactory {
    private static final String KEY_SEVERITY = "bugzilla.severity";
    private static final String KEY_PRODUCT = "bugzilla.product";
    private static final String TAG_BUGZILLA = "Bugzilla";
    private static final String TAG_BUGZILLA_QUERY = "BugzillaQuery";
    private static final String TAG_BUGZILLA_CUSTOM_QUERY = "BugzillaCustomQuery";
    private static final String TAG_BUGZILLA_REPORT = "BugzillaReport";

    public String getTaskElementName() {
        return TAG_BUGZILLA_REPORT;
    }

    public Set<String> getQueryElementNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(TAG_BUGZILLA_QUERY);
        names.add(TAG_BUGZILLA_CUSTOM_QUERY);
        return names;
    }

    public boolean canCreate(AbstractRepositoryQuery category) {
        return category instanceof BugzillaRepositoryQuery;
    }

    public boolean canCreate(AbstractTask task) {
        return task instanceof BugzillaTask;
    }

    public String getQueryElementName(AbstractRepositoryQuery query) {
        if (query instanceof BugzillaRepositoryQuery) {
            if (((BugzillaRepositoryQuery)query).isCustomQuery()) {
                return TAG_BUGZILLA_CUSTOM_QUERY;
            }
            return TAG_BUGZILLA_QUERY;
        }
        return null;
    }

    public AbstractRepositoryQuery createQuery(String repositoryUrl, String queryString, String label, Element element) {
        BugzillaRepositoryQuery query = new BugzillaRepositoryQuery(repositoryUrl, queryString, label);
        if (element.getNodeName().equals(TAG_BUGZILLA_CUSTOM_QUERY)) {
            query.setCustomQuery(true);
        }
        return query;
    }

    public void setAdditionalAttributes(AbstractTask task, Element element) {
        element.setAttribute(KEY_SEVERITY, ((BugzillaTask)task).getSeverity());
        element.setAttribute(KEY_PRODUCT, ((BugzillaTask)task).getProduct());
    }

    public AbstractTask createTask(String repositoryUrl, String taskId, String summary, Element element) {
        BugzillaTask task = new BugzillaTask(repositoryUrl, taskId, summary);
        if (element.hasAttribute(KEY_SEVERITY)) {
            task.setSeverity(element.getAttribute(KEY_SEVERITY));
        }
        if (element.hasAttribute(KEY_PRODUCT)) {
            task.setProduct(element.getAttribute(KEY_PRODUCT));
        }
        return task;
    }
}

