/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.AbstractNewRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NewBugzillaTaskEditor
extends AbstractNewRepositoryTaskEditor {
    protected Text assignedTo;

    public NewBugzillaTaskEditor(FormEditor editor) {
        super(editor);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.setExpandAttributeSection(true);
    }

    protected void saveTaskOffline(IProgressMonitor progressMonitor) {
        String text = this.descriptionTextViewer.getTextWidget().getText();
        if (this.repository.getVersion().startsWith("2.18")) {
            text = BugzillaUiPlugin.formatTextToLineWrap(text, true);
            this.descriptionTextViewer.getTextWidget().setText(text);
        }
        super.saveTaskOffline(progressMonitor);
    }

    protected void createPeopleLayout(Composite composite) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section peopleSection = this.createSection(composite, this.getSectionLabel(AbstractRepositoryTaskEditor.SECTION_NAME.PEOPLE_SECTION));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)peopleSection);
        Composite peopleComposite = toolkit.createComposite((Composite)peopleSection);
        GridLayout layout = new GridLayout(2, false);
        layout.marginRight = 5;
        peopleComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)peopleComposite);
        this.addAssignedTo(peopleComposite);
        this.addCCList(peopleComposite);
        this.getManagedForm().getToolkit().paintBordersFor(peopleComposite);
        peopleSection.setClient((Control)peopleComposite);
        peopleSection.setEnabled(true);
    }

    public void submitToRepository() {
        if (this.summaryText.getText().equals("")) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Submit Error", (String)"Please provide a brief summary with new reports.");
            this.summaryText.setFocus();
            return;
        }
        if (this.descriptionTextViewer.getTextWidget().getText().equals("")) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Submit Error", (String)"Please proved a detailed summary with new reports");
            this.descriptionTextViewer.getTextWidget().setFocus();
            return;
        }
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(BugzillaReportElement.COMPONENT.getKeyString());
        String componentValue = attribute.getValue();
        if (componentValue.equals("")) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Submit Error", (String)"Please select a component with new reports");
            this.descriptionTextViewer.getTextWidget().setFocus();
            return;
        }
        super.submitToRepository();
    }

    protected void createCustomAttributeLayout(Composite composite) {
        Text text;
        GridData textData;
        GridLayout textLayout;
        Composite textFieldComposite;
        Label label;
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(BugzillaReportElement.DEPENDSON.getKeyString());
        if (attribute != null && !attribute.isReadOnly()) {
            label = this.createLabel(composite, attribute);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
            textFieldComposite = this.getManagedForm().getToolkit().createComposite(composite);
            textLayout = new GridLayout();
            textLayout.marginWidth = 1;
            textLayout.marginHeight = 3;
            textLayout.verticalSpacing = 3;
            textFieldComposite.setLayout((Layout)textLayout);
            textData = new GridData(256);
            textData.horizontalSpan = 1;
            textData.widthHint = 135;
            text = this.createTextField(textFieldComposite, attribute, 0x800000);
            text.setLayoutData((Object)textData);
            this.getManagedForm().getToolkit().paintBordersFor(textFieldComposite);
        }
        if ((attribute = this.taskData.getAttribute(BugzillaReportElement.BLOCKED.getKeyString())) != null && !attribute.isReadOnly()) {
            label = this.createLabel(composite, attribute);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
            textFieldComposite = this.getManagedForm().getToolkit().createComposite(composite);
            textLayout = new GridLayout();
            textLayout.marginWidth = 1;
            textLayout.marginHeight = 3;
            textLayout.verticalSpacing = 3;
            textFieldComposite.setLayout((Layout)textLayout);
            textData = new GridData(256);
            textData.horizontalSpan = 1;
            textData.widthHint = 135;
            text = this.createTextField(textFieldComposite, attribute, 0x800000);
            text.setLayoutData((Object)textData);
            this.getManagedForm().getToolkit().paintBordersFor(textFieldComposite);
        }
    }

    protected boolean hasContentAssist(RepositoryTaskAttribute attribute) {
        return BugzillaReportElement.NEWCC.getKeyString().equals(attribute.getId());
    }

    protected void addAssignedTo(Composite peopleComposite) {
        RepositoryTaskAttribute assignedAttribute = this.taskData.getAttribute("task.common.user.assigned");
        if (assignedAttribute != null) {
            String bugzillaVersion;
            try {
                bugzillaVersion = BugzillaCorePlugin.getRepositoryConfiguration((TaskRepository)this.repository, (boolean)false).getInstallVersion();
            }
            catch (CoreException coreException) {
                bugzillaVersion = "2.18";
            }
            if (bugzillaVersion.compareTo("3.1") < 0) {
                super.addAssignedTo(peopleComposite);
                return;
            }
            Label label = this.createLabel(peopleComposite, assignedAttribute);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
            this.assignedTo = assignedAttribute.isReadOnly() ? this.createTextField(peopleComposite, assignedAttribute, 0x800008) : this.createTextField(peopleComposite, assignedAttribute, 0x800000);
            GridDataFactory.fillDefaults().hint(150, -1).applyTo((Control)this.assignedTo);
            this.assignedTo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String sel = NewBugzillaTaskEditor.this.assignedTo.getText();
                    RepositoryTaskAttribute a = ((AbstractRepositoryTaskEditor)NewBugzillaTaskEditor.this).taskData.getAttribute("task.common.user.assigned");
                    if (!a.getValue().equals(sel)) {
                        a.setValue(sel);
                        NewBugzillaTaskEditor.this.markDirty(true);
                    }
                }
            });
            ContentAssistCommandAdapter adapter = this.applyContentAssist(this.assignedTo, this.createContentProposalProvider(assignedAttribute));
            ILabelProvider propsalLabelProvider = this.createProposalLabelProvider(assignedAttribute);
            if (propsalLabelProvider != null) {
                adapter.setLabelProvider(propsalLabelProvider);
            }
            adapter.setProposalAcceptanceStyle(2);
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            Label dummylabel = toolkit.createLabel(peopleComposite, "");
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)dummylabel);
            RepositoryTaskAttribute attribute = this.taskData.getAttribute(BugzillaReportElement.SET_DEFAULT_ASSIGNEE.getKeyString());
            if (attribute == null) {
                this.taskData.setAttributeValue(BugzillaReportElement.SET_DEFAULT_ASSIGNEE.getKeyString(), "0");
                attribute = this.taskData.getAttribute(BugzillaReportElement.SET_DEFAULT_ASSIGNEE.getKeyString());
            }
            this.addButtonField(peopleComposite, attribute, 32);
        }
    }

    private Button addButtonField(Composite rolesComposite, RepositoryTaskAttribute attribute, int style) {
        if (attribute == null) {
            return null;
        }
        String name = attribute.getName();
        if (this.hasOutgoingChange(attribute)) {
            name = String.valueOf(name) + "*";
        }
        final Button button = this.getManagedForm().getToolkit().createButton(rolesComposite, name, style);
        if (!attribute.isReadOnly()) {
            button.setData((Object)attribute);
            button.setSelection(attribute.getValue().equals("1"));
            button.setLayoutData((Object)new GridData(256));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String sel = "1";
                    if (!button.getSelection()) {
                        sel = "0";
                    }
                    RepositoryTaskAttribute a = (RepositoryTaskAttribute)button.getData();
                    a.setValue(sel);
                    NewBugzillaTaskEditor.this.attributeChanged(a);
                }
            });
        }
        return button;
    }
}

