/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.editors;

import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.editors.ContextEditorFormPage;
import org.eclipse.mylyn.internal.context.ui.editors.ContextEditorInput;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.editor.FormEditor;

public class ContextEditorFactory
extends AbstractTaskEditorFactory {
    private static final String LABEL = "Context";

    public boolean canCreateEditorFor(AbstractTask task) {
        return task != null && ContextCorePlugin.getContextManager().hasContext(task.getHandleIdentifier());
    }

    public boolean canCreateEditorFor(IEditorInput input) {
        if (input instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput repositoryTaskEditorInput = (RepositoryTaskEditorInput)input;
            return repositoryTaskEditorInput.getRepositoryTask() != null;
        }
        return input instanceof TaskEditorInput;
    }

    public IEditorPart createEditor(TaskEditor parentEditor, IEditorInput editorInput) {
        ContextEditorFormPage formPage = new ContextEditorFormPage((FormEditor)parentEditor, "org.eclipse.mylyn.context.ui.editor.context", LABEL);
        return formPage;
    }

    public IEditorInput createEditorInput(AbstractTask task) {
        return new ContextEditorInput(task);
    }

    public String getTitle() {
        return LABEL;
    }

    public int getTabOrderPriority() {
        return 0;
    }
}

