/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.actions.TaskContextAction;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class ContextClearAction
extends TaskContextAction {
    public static final String ID = "org.eclipse.mylyn.ui.clear.context";
    private static final String ID_ACTION = "org.eclipse.mylyn.context.ui.task.clear";

    public ContextClearAction() {
        this.setText("Clear");
        this.setToolTipText("Clear");
        this.setId(ID_ACTION);
        this.setImageDescriptor(TasksUiImages.CONTEXT_CLEAR);
    }

    public void init(IViewPart view) {
    }

    public void run() {
        this.run((IAction)this);
    }

    public void run(IAction action) {
        AbstractTask task = TaskListView.getFromActivePerspective().getSelectedTask();
        if (task != null) {
            this.run(task);
        }
    }

    public boolean run(AbstractTask task) {
        boolean deleteConfirmed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Confirm clear context", (String)"Clear the context for the selected task?  This cannot be undone.");
        if (!deleteConfirmed) {
            return false;
        }
        ContextCorePlugin.getContextManager().deleteContext(task.getHandleIdentifier());
        TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(task, false);
        return true;
    }
}

