/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.ui.preferences.AddCustomDialog;
import org.eclipse.ant.internal.ui.preferences.AntObjectLabelProvider;
import org.eclipse.ant.internal.ui.preferences.AntPage;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntRuntimePreferencePage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class AntTypesPage
extends AntPage {
    public AntTypesPage(AntRuntimePreferencePage preferencePage) {
        super(preferencePage);
    }

    protected void addButtonsToButtonGroup(Composite parent) {
        this.createPushButton(parent, AntPreferencesMessages.AntTypesPage_2, 1025);
        this.editButton = this.createPushButton(parent, AntPreferencesMessages.AntTypesPage_3, 1026);
        this.removeButton = this.createPushButton(parent, AntPreferencesMessages.AntTypesPage_1, 1027);
    }

    protected void add() {
        String title = AntPreferencesMessages.AntTypesPage_addTypeDialogTitle;
        AddCustomDialog dialog = this.getCustomDialog(title, "org.eclipse.ant.ui.add_type_dialog_context");
        if (dialog.open() == 1) {
            return;
        }
        Type type = new Type();
        type.setTypeName(dialog.getName());
        type.setClassName(dialog.getClassName());
        type.setLibraryEntry(dialog.getLibraryEntry());
        this.addContent(type);
    }

    protected TabItem createTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.AntTypesPage_typesPageTitle);
        item.setImage(AntObjectLabelProvider.getTypeImage());
        item.setData((Object)this);
        Composite top = new Composite((Composite)folder, 0);
        top.setFont(folder.getFont());
        item.setControl((Control)this.createContents(top));
        this.connectToFolder(item, folder);
        return item;
    }

    protected void edit(IStructuredSelection selection) {
        Type type = (Type)selection.getFirstElement();
        String title = AntPreferencesMessages.AntTypesPage_editTypeDialogTitle;
        AddCustomDialog dialog = this.getCustomDialog(title, "org.eclipse.ant.ui.edit_type_dialog_context");
        dialog.setClassName(type.getClassName());
        dialog.setName(type.getTypeName());
        dialog.setLibraryEntry(type.getLibraryEntry());
        if (dialog.open() == 1) {
            return;
        }
        type.setTypeName(dialog.getName());
        type.setClassName(dialog.getClassName());
        type.setLibraryEntry(dialog.getLibraryEntry());
        this.updateContent(type);
    }

    private AddCustomDialog getCustomDialog(String title, String helpContext) {
        Iterator types = this.getContents(true).iterator();
        ArrayList<String> names = new ArrayList<String>();
        while (types.hasNext()) {
            Type aTask = (Type)types.next();
            names.add(aTask.getTypeName());
        }
        AddCustomDialog dialog = new AddCustomDialog(this.getShell(), this.getPreferencePage().getLibraryEntries(), names, helpContext);
        dialog.setTitle(title);
        dialog.setAlreadyExistsErrorMsg(AntPreferencesMessages.AntTypesPage_8);
        dialog.setNoNameErrorMsg(AntPreferencesMessages.AntTypesPage_9);
        return dialog;
    }

    protected void initialize() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.setInput(prefs.getTypes());
    }

    protected String getHelpContextId() {
        return "org.eclipse.ant.ui.ant_types_page_context";
    }
}

