/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.AntImageDescriptor;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntModelProblem;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.ant.internal.ui.model.IProblem;
import org.eclipse.ant.internal.ui.model.LocationProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class AntElementNode
implements IAdaptable {
    protected int fOffset = -1;
    protected int fLength = -1;
    protected int fSelectionLength;
    protected AntElementNode fParent;
    private AntElementNode fImportNode;
    protected List fChildNodes = null;
    protected String fName;
    private int fProblemSeverity = -1;
    private String fProblemMessage = null;
    private String fFilePath;
    private boolean fIsExternal = false;
    private String fElementPath;
    private String fElementIdentifier;
    private IProblem fProblem;
    private int fIndex = 0;
    private int fLine;
    private int fColumn;

    public AntElementNode(String aName) {
        this.fName = aName;
    }

    public AntElementNode() {
    }

    public String getName() {
        return this.fName;
    }

    public String getLabel() {
        return this.getName();
    }

    public List getChildNodes() {
        return this.fChildNodes;
    }

    public AntElementNode getParentNode() {
        return this.fParent;
    }

    public AntProjectNode getProjectNode() {
        AntElementNode projectParent = this.getParentNode();
        while (projectParent != null && !(projectParent instanceof AntProjectNode)) {
            projectParent = projectParent.getParentNode();
        }
        return (AntProjectNode)projectParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildNode(AntElementNode childElement) {
        childElement.setParent(this);
        AntElementNode antElementNode = this;
        synchronized (antElementNode) {
            if (this.fChildNodes == null) {
                this.fChildNodes = new ArrayList();
            }
            this.fChildNodes.add(childElement);
            childElement.setIndex(this.fChildNodes.size() - 1);
        }
    }

    private void setIndex(int index) {
        this.fIndex = index;
    }

    protected void setParent(AntElementNode node) {
        this.fParent = node;
    }

    public void setFilePath(String path) {
        if (path == null) {
            return;
        }
        URL url = null;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException malformedURLException) {
            this.fFilePath = path;
            return;
        }
        this.fFilePath = new Path(new File(url.getPath()).getAbsolutePath()).toString();
    }

    public String getFilePath() {
        return this.fFilePath;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void setOffset(int anOffset) {
        this.fOffset = anOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setLength(int aLength) {
        this.fLength = aLength;
        if (this.fProblem != null && this.fProblem instanceof AntModelProblem) {
            ((AntModelProblem)this.fProblem).setLength(aLength);
        }
    }

    public String toString() {
        return "Ant Element Node: " + this.getLabel() + " Offset: " + this.getOffset() + " Length: " + this.getLength();
    }

    public boolean isErrorNode() {
        return this.fProblemSeverity == 1 || this.fProblemSeverity == 2;
    }

    public boolean isWarningNode() {
        return this.fProblemSeverity == 0;
    }

    public void setProblemSeverity(int severity) {
        this.fProblemSeverity = severity;
    }

    public boolean isExternal() {
        return this.fIsExternal;
    }

    public void setExternal(boolean isExternal) {
        this.fIsExternal = isExternal;
    }

    public String getElementPath() {
        if (this.fElementPath == null) {
            StringBuffer buffer = new StringBuffer();
            String buildFileName = this.getProjectNode().getBuildFileName();
            if (buildFileName != null) {
                buffer.append(buildFileName);
            }
            buffer.append(this.getParentNode() != null ? this.getParentNode().getElementPath() : "");
            buffer.append('/');
            buffer.append(this.getElementIdentifier());
            buffer.append('[');
            buffer.append(this.fIndex);
            buffer.append(']');
            this.fElementPath = buffer.toString();
        }
        return this.fElementPath;
    }

    private String getElementIdentifier() {
        if (this.fElementIdentifier == null) {
            StringBuffer buffer = this.escape(new StringBuffer(this.getName() != null ? this.getName() : ""), '\\', "$/[]\\");
            buffer.append('$');
            buffer.append(this.escape(new StringBuffer(this.getLabel() != null ? this.getLabel() : ""), '\\', "$/[]\\").toString());
            this.fElementIdentifier = buffer.toString();
        }
        return this.fElementIdentifier;
    }

    private StringBuffer escape(StringBuffer sb, char esc, String special) {
        int i = 0;
        while (i < sb.length()) {
            if (special.indexOf(sb.charAt(i)) >= 0) {
                sb.insert(i++, esc);
            }
            ++i;
        }
        return sb;
    }

    public boolean equals(Object o2) {
        AntElementNode o1 = this;
        if (o1 == o2) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o1 instanceof AntElementNode) && !(o2 instanceof AntElementNode)) {
            return o2.equals(o1);
        }
        if (!(o1 instanceof AntElementNode) || !(o2 instanceof AntElementNode)) {
            return false;
        }
        AntElementNode e1 = o1;
        AntElementNode e2 = (AntElementNode)o2;
        return e1.getElementPath().equals(e2.getElementPath());
    }

    public int hashCode() {
        return this.getElementPath().hashCode();
    }

    public int getSelectionLength() {
        return this.fSelectionLength;
    }

    public void setSelectionLength(int selectionLength) {
        this.fSelectionLength = selectionLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AntElementNode getNode(int sourceOffset) {
        AntElementNode antElementNode = this;
        synchronized (antElementNode) {
            if (this.fChildNodes != null) {
                Iterator iter = this.fChildNodes.iterator();
                while (iter.hasNext()) {
                    AntElementNode node = (AntElementNode)iter.next();
                    AntElementNode containingNode = node.getNode(sourceOffset);
                    if (containingNode == null) continue;
                    return containingNode;
                }
            }
        }
        if (this.fLength == -1 && this.fOffset <= sourceOffset && !this.isExternal()) {
            return this;
        }
        if (this.fOffset <= sourceOffset && sourceOffset <= this.fOffset + this.fLength - 2) {
            return this;
        }
        return null;
    }

    public Image getImage() {
        int flags = 0;
        if (this.isErrorNode()) {
            flags |= 1;
        } else if (this.isWarningNode()) {
            flags |= 4;
        }
        if (this.fImportNode != null || this.isExternal()) {
            flags |= 2;
        }
        ImageDescriptor base = this.getBaseImageDescriptor();
        return AntUIImages.getImage(new AntImageDescriptor(base, flags));
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.html_tab_obj");
    }

    protected IAntModel getAntModel() {
        AntElementNode parentNode = this.getParentNode();
        while (!(parentNode instanceof AntProjectNode)) {
            parentNode = parentNode.getParentNode();
        }
        return parentNode.getAntModel();
    }

    public void associatedProblem(IProblem problem) {
        this.fProblem = problem;
    }

    public IProblem getProblem() {
        return this.fProblem;
    }

    protected void appendEntityName(StringBuffer displayName) {
        String path = this.getFilePath();
        if (this.getImportNode() != null) {
            displayName.append(MessageFormat.format((String)AntModelMessages.AntElementNode_9, (Object[])new String[]{this.getImportNode().getLabel()}));
        } else {
            String entityName = this.getAntModel().getEntityName(path);
            displayName.append(MessageFormat.format((String)AntModelMessages.AntElementNode_9, (Object[])new String[]{entityName}));
        }
    }

    public AntElementNode getImportNode() {
        return this.fImportNode;
    }

    public void setImportNode(AntElementNode importNode) {
        this.fImportNode = importNode;
    }

    public boolean hasChildren() {
        if (this.fChildNodes == null) {
            return false;
        }
        return !this.fChildNodes.isEmpty();
    }

    public void reset() {
        this.fChildNodes = null;
    }

    public void setExternalInfo(int line, int column) {
        this.fLine = line;
        this.fColumn = column;
    }

    public int[] getExternalInfo() {
        return new int[]{this.fLine, this.fColumn};
    }

    public IFile getIFile() {
        if (this.isExternal()) {
            return AntUtil.getFileForLocation(this.fFilePath, null);
        }
        return this.getBuildFileResource();
    }

    public IFile getBuildFileResource() {
        LocationProvider locationProvider = this.getAntModel().getLocationProvider();
        return locationProvider.getFile();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean isStructuralNode() {
        return true;
    }

    public boolean collapseProjection() {
        return false;
    }

    public void dispose() {
        this.getAntModel().dispose();
    }

    public String getReferencedElement(int offset) {
        return null;
    }

    public String getProblemMessage() {
        return this.fProblemMessage;
    }

    public void setProblemMessage(String problemMessage) {
        this.fProblemMessage = problemMessage;
    }

    public boolean containsOccurrence(String identifier) {
        return false;
    }

    public String getOccurrencesIdentifier() {
        return this.getLabel();
    }

    public boolean isRegionPotentialReference(IRegion region) {
        return region.getOffset() >= this.fOffset;
    }

    public List computeIdentifierOffsets(String identifier) {
        return null;
    }

    public boolean isFromDeclaration(IRegion region) {
        return false;
    }

    protected boolean checkReferenceRegion(IRegion region, String textToSearch, String attributeName) {
        int attributeOffset = textToSearch.indexOf(attributeName);
        while (attributeOffset > 0 && !Character.isWhitespace(textToSearch.charAt(attributeOffset - 1))) {
            attributeOffset = textToSearch.indexOf(attributeName, attributeOffset + 1);
        }
        if (attributeOffset != -1) {
            int attributeOffsetEnd = textToSearch.indexOf(34, attributeOffset += attributeName.length());
            attributeOffsetEnd = textToSearch.indexOf(34, attributeOffsetEnd + 1);
            return region.getOffset() >= this.getOffset() + attributeOffset && region.getOffset() + region.getLength() <= this.getOffset() + attributeOffsetEnd;
        }
        return false;
    }
}

