/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.sef;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SelfEncapsulateFieldInputPage
extends UserInputWizardPage {
    private SelfEncapsulateFieldRefactoring fRefactoring;
    private IDialogSettings fSettings;
    private List fEnablements;
    private static final String GENERATE_JAVADOC = "GenerateJavadoc";

    public SelfEncapsulateFieldInputPage() {
        super("InputPage");
        this.setDescription(RefactoringMessages.SelfEncapsulateFieldInputPage_description);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_REFACTOR_CU);
    }

    public void createControl(Composite parent) {
        this.fRefactoring = (SelfEncapsulateFieldRefactoring)this.getRefactoring();
        this.fEnablements = new ArrayList();
        this.loadSettings();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        this.initializeDialogUnits((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 8;
        result.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(25);
        Label label = new Label(result, 16384);
        label.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_getter_name);
        Text getter = new Text(result, 2048);
        getter.setText(this.fRefactoring.getGetterName());
        getter.setLayoutData((Object)gd);
        TextFieldNavigationHandler.install(getter);
        final Label reUseGetter = new Label(result, 16384);
        GridData getterGD = new GridData();
        getterGD.widthHint = this.convertWidthInCharsToPixels(23);
        reUseGetter.setLayoutData((Object)getterGD);
        this.updateUseGetter(reUseGetter);
        getter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String getterName = ((Text)e.widget).getText();
                SelfEncapsulateFieldInputPage.this.fRefactoring.setGetterName(getterName);
                SelfEncapsulateFieldInputPage.this.updateUseGetter(reUseGetter);
                SelfEncapsulateFieldInputPage.this.processValidation();
            }
        });
        if (this.needsSetter()) {
            label = new Label(result, 16384);
            label.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_setter_name);
            Text setter = new Text(result, 2048);
            setter.setText(this.fRefactoring.getSetterName());
            setter.setLayoutData((Object)new GridData(768));
            final Label reUseSetter = new Label(result, 16384);
            GridData setterGD = new GridData();
            setterGD.widthHint = this.convertWidthInCharsToPixels(23);
            reUseSetter.setLayoutData((Object)setterGD);
            this.updateUseSetter(reUseSetter);
            setter.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String setterName = ((Text)e.widget).getText();
                    SelfEncapsulateFieldInputPage.this.fRefactoring.setSetterName(setterName);
                    SelfEncapsulateFieldInputPage.this.updateUseSetter(reUseSetter);
                    SelfEncapsulateFieldInputPage.this.processValidation();
                }
            });
            TextFieldNavigationHandler.install(setter);
        }
        this.createFieldAccessBlock(result);
        label = new Label(result, 16384);
        label.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_insert_after);
        this.fEnablements.add(label);
        final Combo combo = new Combo(result, 8);
        this.fillWithPossibleInsertPositions(combo, this.fRefactoring.getField());
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelfEncapsulateFieldInputPage.this.fRefactoring.setInsertionIndex(combo.getSelectionIndex() - 1);
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        combo.setLayoutData((Object)gridData);
        this.fEnablements.add(combo);
        this.createAccessModifier(result);
        Button checkBox = new Button(result, 32);
        checkBox.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_generateJavadocComment);
        checkBox.setSelection(this.fRefactoring.getGenerateJavadoc());
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelfEncapsulateFieldInputPage.this.setGenerateJavadoc(((Button)e.widget).getSelection());
            }
        });
        GridData checkGD = new GridData(768);
        checkGD.horizontalSpan = 3;
        checkBox.setLayoutData((Object)checkGD);
        this.fEnablements.add(checkBox);
        this.updateEnablements();
        this.processValidation();
        getter.setFocus();
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.self_encapsulate_field_wizard_page_context");
    }

    private void updateUseSetter(Label reUseSetter) {
        if (this.fRefactoring.isUsingLocalSetter()) {
            reUseSetter.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_useexistingsetter_label);
        } else {
            reUseSetter.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_usenewgetter_label);
        }
        this.updateEnablements();
    }

    private void updateEnablements() {
        boolean enable = !this.fRefactoring.isUsingLocalSetter() || !this.fRefactoring.isUsingLocalGetter();
        Iterator iter = this.fEnablements.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            control.setEnabled(enable);
        }
    }

    private void updateUseGetter(Label reUseGetter) {
        if (this.fRefactoring.isUsingLocalGetter()) {
            reUseGetter.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_useexistinggetter_label);
        } else {
            reUseGetter.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_usenewsetter_label);
        }
        this.updateEnablements();
    }

    private void loadSettings() {
        this.fSettings = this.getDialogSettings().getSection("SelfEncapsulateFieldWizard");
        if (this.fSettings == null) {
            this.fSettings = this.getDialogSettings().addNewSection("SelfEncapsulateFieldWizard");
            this.fSettings.put(GENERATE_JAVADOC, JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)this.fRefactoring.getField().getJavaProject()).createComments);
        }
        this.fRefactoring.setGenerateJavadoc(this.fSettings.getBoolean(GENERATE_JAVADOC));
    }

    private void createAccessModifier(Composite result) {
        int visibility = this.fRefactoring.getVisibility();
        if (Flags.isPublic((int)visibility)) {
            return;
        }
        Label label = new Label(result, 0);
        label.setText(RefactoringMessages.SelfEncapsulateFieldInputPage_access_Modifiers);
        this.fEnablements.add(label);
        Composite group = new Composite(result, 0);
        group.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        Object[] info = this.createData(visibility);
        String[] labels = (String[])info[0];
        Integer[] data = (Integer[])info[1];
        int i = 0;
        while (i < labels.length) {
            Button radio = new Button(group, 16);
            radio.setText(labels[i]);
            radio.setData((Object)data[i]);
            int iData = data[i];
            if (iData == visibility) {
                radio.setSelection(true);
            }
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfEncapsulateFieldInputPage.this.fRefactoring.setVisibility((Integer)event.widget.getData());
                }
            });
            this.fEnablements.add(radio);
            ++i;
        }
    }

    private void createFieldAccessBlock(Composite result) {
        Label label = new Label(result, 16384);
        label.setText(RefactoringMessages.SelfEncapsulateField_field_access);
        Composite group = new Composite(result, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        Button radio = new Button(group, 16);
        radio.setText(RefactoringMessages.SelfEncapsulateField_use_setter_getter);
        radio.setSelection(true);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelfEncapsulateFieldInputPage.this.fRefactoring.setEncapsulateDeclaringClass(true);
            }
        });
        radio.setLayoutData((Object)new GridData());
        radio = new Button(group, 16);
        radio.setText(RefactoringMessages.SelfEncapsulateField_keep_references);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelfEncapsulateFieldInputPage.this.fRefactoring.setEncapsulateDeclaringClass(false);
            }
        });
        radio.setLayoutData((Object)new GridData());
    }

    private Object[] createData(int visibility) {
        String pub = RefactoringMessages.SelfEncapsulateFieldInputPage_public;
        String pro = RefactoringMessages.SelfEncapsulateFieldInputPage_protected;
        String def = RefactoringMessages.SelfEncapsulateFieldInputPage_default;
        String priv = RefactoringMessages.SelfEncapsulateFieldInputPage_private;
        String[] labels = null;
        Integer[] data = null;
        if (Flags.isPrivate((int)visibility)) {
            labels = new String[]{pub, pro, def, priv};
            data = new Integer[]{new Integer(1), new Integer(4), new Integer(0), new Integer(2)};
        } else if (Flags.isProtected((int)visibility)) {
            labels = new String[]{pub, pro};
            data = new Integer[]{new Integer(1), new Integer(4)};
        } else {
            labels = new String[]{pub, def};
            data = new Integer[]{new Integer(1), new Integer(0)};
        }
        return new Object[]{labels, data};
    }

    private void fillWithPossibleInsertPositions(Combo combo, IField field) {
        int select = 0;
        combo.add(RefactoringMessages.SelfEncapsulateFieldInputPage_first_method);
        try {
            IMethod[] methods = field.getDeclaringType().getMethods();
            int i = 0;
            while (i < methods.length) {
                combo.add(JavaElementLabels.getElementLabel((IJavaElement)methods[i], 1L));
                ++i;
            }
            if (methods.length > 0) {
                select = methods.length;
            }
        }
        catch (JavaModelException javaModelException) {}
        combo.select(select);
        this.fRefactoring.setInsertionIndex(select - 1);
    }

    private void setGenerateJavadoc(boolean value) {
        this.fSettings.put(GENERATE_JAVADOC, value);
        this.fRefactoring.setGenerateJavadoc(value);
    }

    private void processValidation() {
        RefactoringStatus status = this.fRefactoring.checkMethodNames();
        String message = null;
        boolean valid = true;
        if (status.hasFatalError()) {
            message = status.getMessageMatchingSeverity(4);
            valid = false;
        }
        this.setErrorMessage(message);
        this.setPageComplete(valid);
    }

    private boolean needsSetter() {
        try {
            return !JdtFlags.isFinal((IMember)this.fRefactoring.getField());
        }
        catch (JavaModelException javaModelException) {
            return true;
        }
    }
}

