/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.RenderingViewPane;
import org.eclipse.debug.internal.ui.views.memory.renderings.ErrorRendering;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.progress.WorkbenchJob;

public class MemoryViewTab
implements IMemoryViewTab,
IPropertyChangeListener,
Listener {
    private IMemoryRendering fRendering;
    private TabItem fTabItem;
    private DisposeListener fDisposeListener;
    private boolean fEnabled;
    private boolean fIsDisposed = false;
    private Control fControl;
    private RenderingViewPane fContainer;

    public MemoryViewTab(TabItem tabItem, IMemoryRendering rendering, RenderingViewPane container) {
        this.fTabItem = tabItem;
        this.fRendering = rendering;
        this.fContainer = container;
        if (container.getMemoryRenderingSite().getSynchronizationService() != null) {
            container.getMemoryRenderingSite().getSynchronizationService().setSynchronizationProvider(rendering);
        }
        Control control = this.createViewTab();
        control.addListener(26, (Listener)this);
        control.addListener(27, (Listener)this);
        this.fTabItem.setControl(control);
        this.fTabItem.setData((Object)this);
        this.fTabItem.setText(this.getLabel());
        this.fTabItem.setImage(this.getImage());
        this.fDisposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MemoryViewTab.this.fTabItem.removeDisposeListener(MemoryViewTab.this.fDisposeListener);
                MemoryViewTab.this.dispose();
            }
        };
        this.fTabItem.addDisposeListener(this.fDisposeListener);
    }

    private Control createViewTab() {
        ISafeRunnable safeRunnable = new ISafeRunnable(){

            public void handleException(Throwable exception) {
                ErrorRendering rendering = new ErrorRendering(MemoryViewTab.this.fRendering.getRenderingId(), exception);
                rendering.init(MemoryViewTab.this.fContainer, MemoryViewTab.this.fRendering.getMemoryBlock());
                MemoryViewTab.this.fRendering.dispose();
                MemoryViewTab.this.fRendering = rendering;
                MemoryViewTab.this.fControl = rendering.createControl((Composite)MemoryViewTab.this.fTabItem.getParent());
            }

            public void run() throws Exception {
                MemoryViewTab.this.fControl = MemoryViewTab.this.fRendering.createControl((Composite)MemoryViewTab.this.fTabItem.getParent());
                MemoryViewTab.this.fRendering.addPropertyChangeListener(MemoryViewTab.this.getInstance());
            }
        };
        SafeRunner.run((ISafeRunnable)safeRunnable);
        return this.fControl;
    }

    private String getLabel() {
        return this.fRendering.getLabel();
    }

    private Image getImage() {
        return this.fRendering.getImage();
    }

    public void dispose() {
        if (this.fIsDisposed) {
            return;
        }
        this.fIsDisposed = true;
        this.fRendering.removePropertyChangeListener(this);
        if (!this.fControl.isDisposed()) {
            this.fControl.removeListener(26, (Listener)this);
            this.fControl.removeListener(27, (Listener)this);
        }
        this.fRendering.deactivated();
        this.fRendering.dispose();
    }

    public boolean isDisposed() {
        return this.fIsDisposed;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        if (this.fEnabled) {
            this.fRendering.becomesVisible();
        } else {
            this.fRendering.becomesHidden();
        }
    }

    public void setTabLabel(String label) {
        this.fTabItem.setText(label);
    }

    public String getTabLabel() {
        return this.fTabItem.getText();
    }

    public IMemoryRendering getRendering() {
        return this.fRendering;
    }

    public void propertyChange(final PropertyChangeEvent event) {
        WorkbenchJob job = new WorkbenchJob("MemoryViewTab PropertyChanged"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (MemoryViewTab.this.isDisposed()) {
                    return Status.OK_STATUS;
                }
                if (event.getSource() == MemoryViewTab.this.fRendering) {
                    Object value;
                    if (event.getProperty().equals("org.eclipse.jface.text")) {
                        value = event.getNewValue();
                        if (value != null && value instanceof String) {
                            String label = (String)value;
                            MemoryViewTab.this.setTabLabel(label);
                        } else {
                            MemoryViewTab.this.setTabLabel(MemoryViewTab.this.fRendering.getLabel());
                        }
                    }
                    if (event.getProperty().equals("org.eclipse.jface.image")) {
                        value = event.getNewValue();
                        if (value != null && value instanceof Image) {
                            Image image = (Image)value;
                            MemoryViewTab.this.fTabItem.setImage(image);
                        } else {
                            MemoryViewTab.this.fTabItem.setImage(MemoryViewTab.this.fRendering.getImage());
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private MemoryViewTab getInstance() {
        return this;
    }

    public void handleEvent(Event event) {
        if (event.type == 26) {
            this.fRendering.activated();
            this.fContainer.setRenderingSelection(this.fRendering);
        }
        if (event.type == 27) {
            this.fRendering.deactivated();
        }
    }
}

