/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

public class MarkerFilter
implements Cloneable {
    static final String TAG_ENABLED = "enabled";
    private static final String TAG_ON_RESOURCE = "onResource";
    private static final String TAG_SELECTED_TYPES = "selectedType";
    private static final String TAG_WORKING_SET = "workingSet";
    private static final String TAG_TYPES_DELIMITER = ":";
    private static final String TAG_SELECTION_STATUS = "selectionStatus";
    private static final String SELECTED_FALSE = "false";
    private static final String SELECTED_TRUE = "true";
    public static final int ON_ANY = 0;
    public static final int ON_SELECTED_ONLY = 1;
    public static final int ON_SELECTED_AND_CHILDREN = 2;
    public static final int ON_ANY_IN_SAME_CONTAINER = 3;
    public static final int ON_WORKING_SET = 4;
    static final int DEFAULT_ON_RESOURCE = 0;
    static final boolean DEFAULT_ACTIVATION_STATUS = true;
    protected List rootTypes = new ArrayList();
    protected List selectedTypes = new ArrayList();
    protected IWorkingSet workingSet;
    protected int onResource;
    protected boolean enabled;
    private IResource[] focusResource;
    private Set cachedWorkingSet;
    private String name;
    static /* synthetic */ Class class$0;

    MarkerFilter(String filterName, String[] rootTypes) {
        this.name = filterName;
        int i = 0;
        while (i < rootTypes.length) {
            MarkerType type = MarkerTypesModel.getInstance().getType(rootTypes[i]);
            if (!this.rootTypes.contains(type)) {
                this.rootTypes.add(type);
            }
            ++i;
        }
        this.resetState();
    }

    public void addAllSubTypes(List types) {
        int i = 0;
        while (i < this.rootTypes.size()) {
            MarkerType rootType = (MarkerType)this.rootTypes.get(i);
            this.addAllSubTypes(types, rootType);
            ++i;
        }
    }

    private void addAllSubTypes(List types, MarkerType type) {
        if (type == null) {
            return;
        }
        if (!types.contains(type)) {
            types.add(type);
        }
        MarkerType[] subTypes = type.getSubtypes();
        int i = 0;
        while (i < subTypes.length) {
            this.addAllSubTypes(types, subTypes[i]);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List findMarkers(IResource[] resources, int depth, int limit, IProgressMonitor mon, boolean ignoreExceptions) throws CoreException {
        if (resources == null) {
            return Collections.EMPTY_LIST;
        }
        resultList = new ArrayList<ConcreteMarker>(resources.length * 2);
        typesToSearch = new HashSet<E>(this.selectedTypes.size());
        includeAllSubtypes = new HashSet<MarkerType>(this.selectedTypes.size());
        typesToSearch.addAll(this.selectedTypes);
        iter = this.selectedTypes.iterator();
        while (iter.hasNext()) {
            type = (MarkerType)iter.next();
            subtypes = Arrays.asList(type.getAllSubTypes());
            if (!this.selectedTypes.containsAll(subtypes)) continue;
            typesToSearch.removeAll(subtypes);
            includeAllSubtypes.add(type);
        }
        mon.beginTask(MarkerMessages.MarkerFilter_searching, typesToSearch.size() * resources.length);
        resourcesToSearch = new HashSet<IResource>();
        idx = 0;
        while (idx < resources.length) {
            next = resources[idx];
            if (next.exists()) {
                if (resourcesToSearch.contains(next)) {
                    mon.worked(typesToSearch.size());
                } else {
                    resourcesToSearch.add(next);
                }
            }
            ++idx;
        }
        resourceIdx = 0;
        while (resourceIdx < resources.length) {
            block17: {
                iter = typesToSearch.iterator();
                resource = resources[resourceIdx];
                if (!resource.isAccessible()) break block17;
                if (depth != 2) ** GOTO lbl66
                parent = resource.getParent();
                found = false;
                while (parent != null) {
                    if (resourcesToSearch.contains(parent)) {
                        found = true;
                    }
                    parent = parent.getParent();
                }
                if (!found) ** GOTO lbl66
                break block17;
lbl-1000:
                // 1 sources

                {
                    markerType = (MarkerType)iter.next();
                    markers = resource.findMarkers(markerType.getId(), includeAllSubtypes.contains(markerType), depth);
                    mon.worked(1);
                    idx = 0;
                    while (idx < markers.length) {
                        block16: {
                            try {
                                marker = MarkerList.createMarker(markers[idx]);
                            }
                            catch (CoreException e) {
                                if (!ignoreExceptions) {
                                    throw e;
                                }
                                break block16;
                            }
                            if (limit != -1 && resultList.size() >= limit) {
                                return resultList;
                            }
                            if (this.selectMarker(marker)) {
                                resultList.add(marker);
                            }
                        }
                        ++idx;
                    }
lbl66:
                    // 3 sources

                    ** while (iter.hasNext())
                }
            }
            ++resourceIdx;
        }
        mon.done();
        return resultList;
    }

    protected boolean selectMarker(ConcreteMarker marker) {
        return true;
    }

    Collection findMarkers(IProgressMonitor mon, boolean ignoreExceptions) throws CoreException {
        List unfiltered = Collections.EMPTY_LIST;
        if (!this.isEnabled()) {
            unfiltered = this.findMarkers(new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, 2, -1, mon, ignoreExceptions);
        } else {
            int limit = -1;
            switch (this.getOnResource()) {
                case 0: {
                    unfiltered = this.findMarkers(new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, 2, limit, mon, ignoreExceptions);
                    break;
                }
                case 1: {
                    unfiltered = this.findMarkers(this.focusResource, 0, limit, mon, ignoreExceptions);
                    break;
                }
                case 2: {
                    unfiltered = this.findMarkers(this.focusResource, 2, limit, mon, ignoreExceptions);
                    break;
                }
                case 3: {
                    unfiltered = this.findMarkers((IResource[])MarkerFilter.getProjects(this.focusResource), 2, limit, mon, ignoreExceptions);
                    break;
                }
                case 4: {
                    unfiltered = this.findMarkers(this.getResourcesInWorkingSet(), 2, limit, mon, ignoreExceptions);
                }
            }
        }
        if (unfiltered == null) {
            unfiltered = Collections.EMPTY_LIST;
        }
        return unfiltered;
    }

    IResource[] getResourcesInWorkingSet() {
        if (this.workingSet == null) {
            return new IResource[0];
        }
        if (this.workingSet.isEmpty()) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        IAdaptable[] elements = this.workingSet.getElements();
        ArrayList<IResource> result = new ArrayList<IResource>(elements.length);
        int idx = 0;
        while (idx < elements.length) {
            IResource next;
            IAdaptable iAdaptable = elements[idx];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((next = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                result.add(next);
            }
            ++idx;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private Set getWorkingSetAsSetOfPaths() {
        if (this.cachedWorkingSet == null) {
            HashSet result = new HashSet();
            this.addResourcesAndChildren(result, this.getResourcesInWorkingSet());
            this.cachedWorkingSet = result;
        }
        return this.cachedWorkingSet;
    }

    private void addResourcesAndChildren(HashSet result, IResource[] resources) {
        int idx = 0;
        while (idx < resources.length) {
            IResource currentResource = resources[idx];
            result.add(currentResource.getFullPath().toString());
            if (currentResource instanceof IContainer) {
                IContainer cont = (IContainer)currentResource;
                try {
                    this.addResourcesAndChildren(result, cont.members());
                }
                catch (CoreException coreException) {}
            }
            ++idx;
        }
    }

    static IProject[] getProjects(IResource[] resources) {
        if (resources == null) {
            return new IProject[0];
        }
        Collection projects = MarkerFilter.getProjectsAsCollection(resources);
        return projects.toArray(new IProject[projects.size()]);
    }

    static Collection getProjectsAsCollection(Object[] elements) {
        HashSet<IProject> projects = new HashSet<IProject>();
        int idx = 0;
        while (idx < elements.length) {
            if (elements[idx] instanceof IResource) {
                projects.add(((IResource)elements[idx]).getProject());
            } else {
                IProject[] mappingProjects = ((ResourceMapping)elements[idx]).getProjects();
                int i = 0;
                while (i < mappingProjects.length) {
                    projects.add(mappingProjects[i]);
                    ++i;
                }
            }
            ++idx;
        }
        return projects;
    }

    public boolean select(ConcreteMarker marker) {
        if (!this.isEnabled()) {
            return true;
        }
        return this.selectByType(marker) && this.selectBySelection(marker) && this.selectMarker(marker);
    }

    private boolean selectByType(ConcreteMarker marker) {
        return this.selectedTypes.contains(MarkerTypesModel.getInstance().getType(marker.getType()));
    }

    private boolean selectBySelection(ConcreteMarker marker) {
        block12: {
            IResource resource;
            block14: {
                block13: {
                    block11: {
                        if (this.onResource == 0 || marker == null) {
                            return true;
                        }
                        if (this.focusResource == null) {
                            return true;
                        }
                        resource = marker.getResource();
                        if (this.onResource != 4) break block11;
                        if (resource != null) {
                            return this.isEnclosed(resource);
                        }
                        break block12;
                    }
                    if (this.onResource != 3) break block13;
                    IProject project = resource.getProject();
                    if (project == null) {
                        return false;
                    }
                    int i = 0;
                    while (i < this.focusResource.length) {
                        IProject selectedProject = this.focusResource[i].getProject();
                        if (selectedProject != null && project.equals((Object)selectedProject)) {
                            return true;
                        }
                        ++i;
                    }
                    break block12;
                }
                if (this.onResource != 1) break block14;
                int i = 0;
                while (i < this.focusResource.length) {
                    if (resource.equals((Object)this.focusResource[i])) {
                        return true;
                    }
                    ++i;
                }
                break block12;
            }
            if (this.onResource != 2) break block12;
            int i = 0;
            while (i < this.focusResource.length) {
                IResource parentResource = resource;
                while (parentResource != null) {
                    if (parentResource.equals((Object)this.focusResource[i])) {
                        return true;
                    }
                    parentResource = parentResource.getParent();
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isEnclosed(IResource element) {
        if (this.workingSet == null) {
            return false;
        }
        if (this.workingSet.isEmpty()) {
            return true;
        }
        Set workingSetPaths = this.getWorkingSetAsSetOfPaths();
        return workingSetPaths.contains(element.getFullPath().toString());
    }

    public int getOnResource() {
        return this.onResource;
    }

    void setOnResource(int onResource) {
        if (onResource >= 0 && onResource <= 4) {
            this.onResource = onResource;
        }
    }

    IResource[] getFocusResource() {
        return this.focusResource;
    }

    public void setFocusResource(IResource[] resources) {
        this.focusResource = resources;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List getRootTypes() {
        return this.rootTypes;
    }

    public List getSelectedTypes() {
        return this.selectedTypes;
    }

    public MarkerType getMarkerType(String id) {
        return MarkerTypesModel.getInstance().getType(id);
    }

    IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
        this.cachedWorkingSet = null;
    }

    void resetState() {
        this.enabled = true;
        this.onResource = 0;
        this.selectedTypes.clear();
        this.addAllSubTypes(this.selectedTypes);
        this.setWorkingSet(null);
    }

    public final void restoreState(IMemento memento) {
        this.resetState();
        this.restoreFilterSettings(memento);
    }

    public void restoreFilterSettings(IDialogSettings settings) {
        this.resetState();
        String setting = settings.get(TAG_ENABLED);
        if (setting != null) {
            this.enabled = Boolean.valueOf(setting);
        }
        if ((setting = settings.get(TAG_ON_RESOURCE)) != null) {
            try {
                this.onResource = Integer.parseInt(setting);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((setting = settings.get(TAG_SELECTION_STATUS)) != null) {
            this.selectedTypes.clear();
            ArrayList newTypes = new ArrayList();
            this.addAllSubTypes(newTypes);
            StringTokenizer stringTokenizer = new StringTokenizer(setting);
            while (stringTokenizer.hasMoreTokens()) {
                MarkerType markerType;
                String id = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                String status = null;
                if (stringTokenizer.hasMoreTokens()) {
                    status = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                }
                if ((markerType = MarkerTypesModel.getInstance().getType(id)) == null) continue;
                newTypes.remove(markerType);
                if (SELECTED_FALSE.equals(status) || this.selectedTypes.contains(markerType)) continue;
                this.selectedTypes.add(markerType);
            }
            int i = 0;
            while (i < newTypes.size()) {
                this.selectedTypes.add(newTypes.get(i));
                ++i;
            }
        } else {
            setting = settings.get(TAG_SELECTED_TYPES);
            if (setting != null) {
                this.generateSelectedTypes(setting);
            }
        }
        setting = settings.get(TAG_WORKING_SET);
        if (setting != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(setting));
        }
    }

    void generateSelectedTypes(String selectedTypesValue) {
        this.selectedTypes.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(selectedTypesValue);
        while (stringTokenizer.hasMoreTokens()) {
            MarkerType markerType = this.getMarkerType(stringTokenizer.nextToken(TAG_TYPES_DELIMITER));
            if (markerType == null || this.selectedTypes.contains(markerType)) continue;
            this.selectedTypes.add(markerType);
        }
    }

    MarkerType findMarkerType(String typeName) {
        return MarkerTypesModel.getInstance().getType(typeName);
    }

    protected void restoreFilterSettings(IMemento memento) {
        Integer resourceSetting;
        String setting = memento.getString(TAG_ENABLED);
        if (setting != null) {
            this.enabled = Boolean.valueOf(setting);
        }
        if ((resourceSetting = memento.getInteger(TAG_ON_RESOURCE)) != null) {
            this.onResource = resourceSetting;
        }
        if ((setting = memento.getString(TAG_SELECTION_STATUS)) != null) {
            this.selectedTypes.clear();
            ArrayList newTypes = new ArrayList();
            this.addAllSubTypes(newTypes);
            StringTokenizer stringTokenizer = new StringTokenizer(setting);
            while (stringTokenizer.hasMoreTokens()) {
                MarkerType markerType;
                String id = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                String status = null;
                if (stringTokenizer.hasMoreTokens()) {
                    status = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                }
                if ((markerType = MarkerTypesModel.getInstance().getType(id)) == null) continue;
                newTypes.remove(markerType);
                if (SELECTED_FALSE.equals(status) || this.selectedTypes.contains(markerType)) continue;
                this.selectedTypes.add(markerType);
            }
            int i = 0;
            while (i < newTypes.size()) {
                this.selectedTypes.add(newTypes.get(i));
                ++i;
            }
        } else {
            setting = memento.getString(TAG_SELECTED_TYPES);
            if (setting != null) {
                this.generateSelectedTypes(setting);
            }
        }
        setting = memento.getString(TAG_WORKING_SET);
        if (setting != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(setting));
        }
    }

    public void saveFilterSettings(IMemento settings) {
        settings.putString(TAG_ENABLED, String.valueOf(this.enabled));
        settings.putInteger(TAG_ON_RESOURCE, this.onResource);
        String markerTypeIds = "";
        ArrayList includedTypes = new ArrayList();
        this.addAllSubTypes(includedTypes);
        int i = 0;
        while (i < includedTypes.size()) {
            MarkerType markerType = (MarkerType)includedTypes.get(i);
            markerTypeIds = String.valueOf(markerTypeIds) + markerType.getId() + TAG_TYPES_DELIMITER;
            markerTypeIds = this.selectedTypes.contains(markerType) ? String.valueOf(markerTypeIds) + "true:" : String.valueOf(markerTypeIds) + "false:";
            ++i;
        }
        settings.putString(TAG_SELECTION_STATUS, markerTypeIds);
        if (this.workingSet != null) {
            settings.putString(TAG_WORKING_SET, this.workingSet.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public MarkerFilter makeClone() throws CloneNotSupportedException {
        return (MarkerFilter)this.clone();
    }

    public void setSelectedTypes(List selectedTypes) {
        this.selectedTypes = selectedTypes;
    }
}

