/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class EditorOpener {
    private IEditorReference fReusedEditor;

    public IEditorPart open(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage wbPage = SearchPlugin.getActivePage();
        if (NewSearchUI.reuseEditor()) {
            return this.showWithReuse(file, wbPage, activate);
        }
        return this.showWithoutReuse(file, wbPage, activate);
    }

    private IEditorPart showWithoutReuse(IFile file, IWorkbenchPage wbPage, boolean activate) throws PartInitException {
        return IDE.openEditor((IWorkbenchPage)wbPage, (IFile)file, (boolean)activate);
    }

    private IEditorPart showWithReuse(IFile file, IWorkbenchPage wbPage, boolean activate) throws PartInitException {
        String editorID = this.getEditorID(file);
        return this.showInEditor(wbPage, file, editorID, activate);
    }

    private String getEditorID(IFile file) throws PartInitException {
        IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
        if (desc == null) {
            return SearchPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return desc.getId();
    }

    private IEditorPart showInEditor(IWorkbenchPage page, IFile file, String editorId, boolean activate) throws PartInitException {
        IEditorReference reference;
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
            if (activate) {
                page.activate((IWorkbenchPart)editor);
            }
            return editor;
        }
        IEditorReference reusedEditorRef = this.fReusedEditor;
        if (reusedEditorRef != null) {
            boolean canBeReused;
            boolean isOpen = reusedEditorRef.getEditor(false) != null;
            boolean bl = canBeReused = isOpen && !reusedEditorRef.isDirty() && !reusedEditorRef.isPinned();
            if (canBeReused) {
                boolean showsSameInputType = reusedEditorRef.getId().equals(editorId);
                if (!showsSameInputType) {
                    if (this.isOkToClose(page)) {
                        page.closeEditors(new IEditorReference[]{reusedEditorRef}, false);
                    }
                    this.fReusedEditor = null;
                } else {
                    editor = reusedEditorRef.getEditor(true);
                    if (editor instanceof IReusableEditor) {
                        ((IReusableEditor)editor).setInput((IEditorInput)input);
                        page.bringToTop((IWorkbenchPart)editor);
                        if (activate) {
                            page.activate((IWorkbenchPart)editor);
                        }
                        return editor;
                    }
                }
            }
        }
        this.fReusedEditor = (editor = page.openEditor((IEditorInput)input, editorId, activate)) instanceof IReusableEditor ? (reference = (IEditorReference)page.getReference((IWorkbenchPart)editor)) : null;
        return editor;
    }

    private boolean isOkToClose(IWorkbenchPage page) {
        IWorkbenchPartReference searchViewRef = page.getActivePartReference();
        return searchViewRef == null || !"org.eclipse.search.ui.views.SearchView".equals(searchViewRef.getId()) || !((IViewReference)searchViewRef).isFastView();
    }
}

