/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.bugzilla.core.AbstractReportFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.SaxMultiBugReportContentHandler;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBugReportFactory
extends AbstractReportFactory {
    private static BugzillaAttributeFactory bugzillaAttributeFactory = new BugzillaAttributeFactory();

    public MultiBugReportFactory(InputStream inStream, String encoding) {
        super(inStream, encoding);
    }

    public void populateReport(Map<String, RepositoryTaskData> bugMap) throws IOException, CoreException {
        SaxMultiBugReportContentHandler contentHandler = new SaxMultiBugReportContentHandler(bugzillaAttributeFactory, bugMap);
        this.collectResults(contentHandler, false);
        if (contentHandler.errorOccurred()) {
            String errorResponse = contentHandler.getErrorMessage().toLowerCase(Locale.ENGLISH);
            if (errorResponse.equals("notfound") || errorResponse.equals("invalidbugid")) {
                throw new CoreException((IStatus)new BugzillaStatus(2, "org.eclipse.mylyn.bugzilla", 1, "", "Invalid bug id. The requested bug id does not exist."));
            }
            if (errorResponse.equals("notpermitted")) {
                throw new CoreException((IStatus)new BugzillaStatus(2, "org.eclipse.mylyn.bugzilla", 1, "", "The requested operation is not permitted."));
            }
        }
    }
}

