/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.RepositoryOperation;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaTaskDataHandler
extends AbstractTaskDataHandler {
    private static final String OPERATION_INPUT_ASSIGNED_TO = "assigned_to";
    private static final String OPERATION_INPUT_DUP_ID = "dup_id";
    private static final String OPERATION_OPTION_RESOLUTION = "resolution";
    private static final String OPERATION_LABEL_CLOSE = "Mark as CLOSED";
    private static final String OPERATION_LABEL_VERIFY = "Mark as VERIFIED";
    private static final String OPERATION_LABEL_REOPEN = "Reopen bug";
    private static final String OPERATION_LABEL_REASSIGN_DEFAULT = "Reassign to default assignee";
    private static final String OPERATION_LABEL_REASSIGN = "Reassign to";
    private static final String OPERATION_LABEL_DUPLICATE = "Mark as duplicate of #";
    private static final String OPERATION_LABEL_RESOLVE = "Resolve as";
    private static final String OPERATION_LABEL_ACCEPT = "Accept (change status to ASSIGNED)";
    private AbstractAttributeFactory attributeFactory = new BugzillaAttributeFactory();
    private BugzillaRepositoryConnector connector;

    public BugzillaTaskDataHandler(BugzillaRepositoryConnector connector) {
        this.connector = connector;
    }

    public RepositoryTaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        try {
            RepositoryTaskData taskData;
            BugzillaClient client = this.connector.getClientManager().getClient(repository);
            int bugId = BugzillaRepositoryConnector.getBugId(taskId);
            try {
                taskData = client.getTaskData(bugId);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 3) {
                    taskData = client.getTaskData(bugId);
                }
                throw e;
            }
            if (taskData != null) {
                block8: {
                    try {
                        this.configureTaskData(repository, taskData);
                    }
                    catch (CoreException coreException) {
                        taskData = client.getTaskData(bugId);
                        if (taskData == null) break block8;
                        this.configureTaskData(repository, taskData);
                    }
                }
                return taskData;
            }
            return null;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, repository.getUrl(), e));
        }
    }

    /*
     * Unable to fully structure code
     */
    public Set<RepositoryTaskData> getMultiTaskData(TaskRepository repository, Set<String> taskIds, IProgressMonitor monitor) throws CoreException {
        try {
            block9: {
                block10: {
                    result = new HashSet<RepositoryTaskData>();
                    client = this.connector.getClientManager().getClient(repository);
                    try {
                        dataReturned = client.getTaskData(taskIds);
                        for (RepositoryTaskData repositoryTaskData : dataReturned.values()) {
                            result.add(repositoryTaskData);
                        }
                        break block9;
                    }
                    catch (CoreException e) {
                        if (e.getStatus().getCode() != 3) break block10;
                        dataReturned = client.getTaskData(taskIds);
                        ** for (repositoryTaskData : dataReturned.values())
                    }
lbl-1000:
                    // 1 sources

                    {
                        result.add(repositoryTaskData);
                        continue;
lbl18:
                        // 1 sources

                        break block9;
                    }
                }
                throw e;
            }
            for (RepositoryTaskData repositoryTaskData : result) {
                try {
                    this.configureTaskData(repository, repositoryTaskData);
                }
                catch (CoreException v0) {
                    this.configureTaskData(repository, repositoryTaskData);
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, repository.getUrl(), e));
        }
    }

    public String postTaskData(TaskRepository repository, RepositoryTaskData taskData, IProgressMonitor monitor) throws CoreException {
        try {
            BugzillaClient client = this.connector.getClientManager().getClient(repository);
            try {
                return client.postTaskData(taskData);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 3) {
                    return client.postTaskData(taskData);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, repository.getUrl(), e));
        }
    }

    public AbstractAttributeFactory getAttributeFactory(String repositoryUrl, String repositoryKind, String taskKind) {
        return this.attributeFactory;
    }

    public AbstractAttributeFactory getAttributeFactory(RepositoryTaskData taskData) {
        return this.getAttributeFactory(taskData.getRepositoryUrl(), taskData.getRepositoryKind(), taskData.getTaskKind());
    }

    public void configureTaskData(TaskRepository repository, RepositoryTaskData taskData) throws CoreException {
        this.updateAttributeOptions(repository, taskData);
        this.addValidOperations(taskData, repository.getUserName(), repository);
    }

    private void addValidOperations(RepositoryTaskData bugReport, String userName, TaskRepository repository) throws CoreException {
        String bugzillaVersion;
        IBugzillaConstants.BUGZILLA_REPORT_STATUS status;
        try {
            status = IBugzillaConstants.BUGZILLA_REPORT_STATUS.valueOf(bugReport.getStatus());
        }
        catch (RuntimeException e) {
            StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.bugzilla", "Unrecognized status: " + bugReport.getStatus(), (Throwable)e));
            status = IBugzillaConstants.BUGZILLA_REPORT_STATUS.NEW;
        }
        switch (status) {
            case UNCONFIRMED: 
            case NEW: 
            case REOPENED: {
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.none, userName);
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.accept, userName);
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.resolve, userName);
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.duplicate, userName);
                break;
            }
            case ASSIGNED: {
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.none, userName);
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.resolve, userName);
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.duplicate, userName);
                break;
            }
            case RESOLVED: {
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.none, userName);
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.reopen, userName);
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.verify, userName);
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.close, userName);
                break;
            }
            case CLOSED: {
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.none, userName);
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.reopen, userName);
                break;
            }
            case VERIFIED: {
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.none, userName);
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.reopen, userName);
                this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.close, userName);
            }
        }
        try {
            bugzillaVersion = BugzillaCorePlugin.getRepositoryConfiguration(repository, false).getInstallVersion();
        }
        catch (CoreException coreException) {
            bugzillaVersion = "2.18";
        }
        if (bugzillaVersion.compareTo("3.1") < 0 && (status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.NEW || status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.ASSIGNED || status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.REOPENED || status == IBugzillaConstants.BUGZILLA_REPORT_STATUS.UNCONFIRMED)) {
            this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.reassign, userName);
            this.addOperation(repository, bugReport, IBugzillaConstants.BUGZILLA_OPERATION.reassignbycomponent, userName);
        }
    }

    private void addOperation(TaskRepository repository, RepositoryTaskData bugReport, IBugzillaConstants.BUGZILLA_OPERATION opcode, String userName) {
        RepositoryOperation newOperation = null;
        switch (opcode) {
            case none: {
                newOperation = new RepositoryOperation(opcode.toString(), "Leave as " + bugReport.getStatus() + " " + bugReport.getResolution());
                newOperation.setChecked(true);
                break;
            }
            case accept: {
                newOperation = new RepositoryOperation(opcode.toString(), OPERATION_LABEL_ACCEPT);
                break;
            }
            case resolve: {
                RepositoryConfiguration config;
                newOperation = new RepositoryOperation(opcode.toString(), OPERATION_LABEL_RESOLVE);
                newOperation.setUpOptions(OPERATION_OPTION_RESOLUTION);
                try {
                    config = BugzillaCorePlugin.getRepositoryConfiguration(repository, false);
                }
                catch (CoreException coreException) {
                    config = null;
                }
                if (config != null) {
                    for (String resolution : config.getResolutions()) {
                        if (resolution.compareTo("DUPLICATE") == 0 || resolution.compareTo("MOVED") == 0) continue;
                        newOperation.addOption(resolution, resolution);
                    }
                } else if (repository.getVersion().compareTo("3.0") >= 0) {
                    IBugzillaConstants.BUGZILLA_RESOLUTION_3_0[] bUGZILLA_RESOLUTION_3_0Array = IBugzillaConstants.BUGZILLA_RESOLUTION_3_0.values();
                    int n = bUGZILLA_RESOLUTION_3_0Array.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBugzillaConstants.BUGZILLA_RESOLUTION_3_0 resolution = bUGZILLA_RESOLUTION_3_0Array[n2];
                        newOperation.addOption(resolution.toString(), resolution.toString());
                        ++n2;
                    }
                } else {
                    IBugzillaConstants.BUGZILLA_RESOLUTION_2_0[] bUGZILLA_RESOLUTION_2_0Array = IBugzillaConstants.BUGZILLA_RESOLUTION_2_0.values();
                    int n = bUGZILLA_RESOLUTION_2_0Array.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IBugzillaConstants.BUGZILLA_RESOLUTION_2_0 resolution = bUGZILLA_RESOLUTION_2_0Array[n3];
                        newOperation.addOption(resolution.toString(), resolution.toString());
                        ++n3;
                    }
                }
                break;
            }
            case duplicate: {
                newOperation = new RepositoryOperation(opcode.toString(), OPERATION_LABEL_DUPLICATE);
                newOperation.setInputName(OPERATION_INPUT_DUP_ID);
                newOperation.setInputValue("");
                break;
            }
            case reassign: {
                String localUser = userName;
                newOperation = new RepositoryOperation(opcode.toString(), OPERATION_LABEL_REASSIGN);
                newOperation.setInputName(OPERATION_INPUT_ASSIGNED_TO);
                newOperation.setInputValue(localUser);
                break;
            }
            case reassignbycomponent: {
                newOperation = new RepositoryOperation(opcode.toString(), OPERATION_LABEL_REASSIGN_DEFAULT);
                break;
            }
            case reopen: {
                newOperation = new RepositoryOperation(opcode.toString(), OPERATION_LABEL_REOPEN);
                break;
            }
            case verify: {
                newOperation = new RepositoryOperation(opcode.toString(), OPERATION_LABEL_VERIFY);
                break;
            }
            case close: {
                newOperation = new RepositoryOperation(opcode.toString(), OPERATION_LABEL_CLOSE);
                break;
            }
        }
        if (newOperation != null) {
            bugReport.addOperation(newOperation);
        }
    }

    public boolean initializeTaskData(TaskRepository repository, RepositoryTaskData data, IProgressMonitor monitor) throws CoreException {
        if (data == null) {
            return false;
        }
        String product = data.getProduct();
        if (product.equals("")) {
            return false;
        }
        data.removeAllAttributes();
        RepositoryConfiguration repositoryConfiguration = BugzillaCorePlugin.getRepositoryConfiguration(repository, false);
        RepositoryTaskAttribute a = BugzillaClient.makeNewAttribute(BugzillaReportElement.PRODUCT);
        List<String> optionValues = repositoryConfiguration.getProducts();
        Collections.sort(optionValues);
        a.setValue(product);
        a.setReadOnly(true);
        data.addAttribute(BugzillaReportElement.PRODUCT.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.BUG_STATUS);
        optionValues = repositoryConfiguration.getStatusValues();
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        a.setValue("NEW");
        data.addAttribute(BugzillaReportElement.BUG_STATUS.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.SHORT_DESC);
        data.addAttribute(BugzillaReportElement.SHORT_DESC.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.VERSION);
        optionValues = repositoryConfiguration.getVersions(data.getProduct());
        Collections.sort(optionValues);
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() > 0) {
            a.setValue(optionValues.get(optionValues.size() - 1));
        }
        data.addAttribute(BugzillaReportElement.VERSION.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.COMPONENT);
        optionValues = repositoryConfiguration.getComponents(data.getProduct());
        Collections.sort(optionValues);
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() == 1) {
            a.setValue(optionValues.get(0));
        }
        data.addAttribute(BugzillaReportElement.COMPONENT.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.REP_PLATFORM);
        optionValues = repositoryConfiguration.getPlatforms();
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() > 0) {
            a.setValue(optionValues.get(0));
        }
        data.addAttribute(BugzillaReportElement.REP_PLATFORM.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.OP_SYS);
        optionValues = repositoryConfiguration.getOSs();
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() > 0) {
            a.setValue(optionValues.get(0));
        }
        data.addAttribute(BugzillaReportElement.OP_SYS.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.PRIORITY);
        optionValues = repositoryConfiguration.getPriorities();
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() > 0) {
            a.setValue(optionValues.get(optionValues.size() / 2));
        }
        data.addAttribute(BugzillaReportElement.PRIORITY.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.BUG_SEVERITY);
        optionValues = repositoryConfiguration.getSeverities();
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() > 0) {
            a.setValue(optionValues.get(optionValues.size() / 2));
        }
        data.addAttribute(BugzillaReportElement.BUG_SEVERITY.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.ASSIGNED_TO);
        a.setValue("");
        a.setReadOnly(false);
        data.addAttribute(BugzillaReportElement.ASSIGNED_TO.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.BUG_FILE_LOC);
        a.setValue("http://");
        a.setHidden(false);
        data.addAttribute(BugzillaReportElement.BUG_FILE_LOC.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.DEPENDSON);
        a.setValue("");
        a.setReadOnly(false);
        data.addAttribute(BugzillaReportElement.DEPENDSON.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.BLOCKED);
        a.setValue("");
        a.setReadOnly(false);
        data.addAttribute(BugzillaReportElement.BLOCKED.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.NEWCC);
        a.setValue("");
        a.setReadOnly(false);
        data.addAttribute(BugzillaReportElement.NEWCC.getKeyString(), a);
        return true;
    }

    public Set<String> getSubTaskIds(RepositoryTaskData taskData) {
        HashSet<String> result = new HashSet<String>();
        RepositoryTaskAttribute attribute = taskData.getAttribute(BugzillaReportElement.DEPENDSON.getKeyString());
        if (attribute != null) {
            String[] ids;
            String[] stringArray = ids = attribute.getValue().split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if ((id = id.trim()).length() != 0) {
                    result.add(id);
                }
                ++n2;
            }
        }
        return result;
    }

    public boolean canGetMultiTaskData() {
        return true;
    }

    public boolean initializeSubTaskData(TaskRepository taskRepository, RepositoryTaskData taskData, RepositoryTaskData parentTaskData, IProgressMonitor monitor) throws CoreException {
        String project = parentTaskData.getProduct();
        taskData.setAttributeValue("task.common.product", project);
        this.initializeTaskData(taskRepository, taskData, monitor);
        this.cloneTaskData(parentTaskData, taskData);
        taskData.setAttributeValue(BugzillaReportElement.BLOCKED.getKeyString(), parentTaskData.getId());
        taskData.setAttributeValue("task.common.user.assigned", parentTaskData.getAssignedTo());
        taskData.setDescription("");
        taskData.setSummary("");
        return true;
    }

    public boolean canInitializeSubTaskData(AbstractTask task, RepositoryTaskData parentTaskData) {
        return true;
    }

    public void updateAttributeOptions(TaskRepository taskRepository, RepositoryTaskData existingReport) throws CoreException {
        String product = existingReport.getAttributeValue(BugzillaReportElement.PRODUCT.getKeyString());
        for (RepositoryTaskAttribute attribute : existingReport.getAttributes()) {
            BugzillaReportElement element = BugzillaReportElement.valueOf(attribute.getId().trim().toUpperCase(Locale.ENGLISH));
            attribute.clearOptions();
            List<String> optionValues = BugzillaCorePlugin.getRepositoryConfiguration(taskRepository, false).getOptionValues(element, product);
            if (element != BugzillaReportElement.OP_SYS && element != BugzillaReportElement.BUG_SEVERITY && element != BugzillaReportElement.PRIORITY && element != BugzillaReportElement.BUG_STATUS) {
                Collections.sort(optionValues);
            }
            if (element == BugzillaReportElement.TARGET_MILESTONE && optionValues.isEmpty()) {
                existingReport.removeAttribute((Object)BugzillaReportElement.TARGET_MILESTONE);
                continue;
            }
            attribute.clearOptions();
            for (String option : optionValues) {
                attribute.addOption(option, option);
            }
        }
    }
}

