/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttachmentHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.UnrecognizedReponseException;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.ITaskFactory;
import org.eclipse.mylyn.tasks.core.QueryHitCollector;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaRepositoryConnector
extends AbstractRepositoryConnector {
    private static final String BUG_ID = "&bug_id=";
    private static final String CHANGED_BUGS_CGI_ENDDATE = "&chfieldto=Now";
    private static final String CHANGED_BUGS_CGI_QUERY = "/buglist.cgi?query_format=advanced&chfieldfrom=";
    private static final String CLIENT_LABEL = "Bugzilla (supports uncustomized 2.18-3.0)";
    private static final String COMMENT_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String DEADLINE_FORMAT = "yyyy-MM-dd";
    private BugzillaAttachmentHandler attachmentHandler;
    private BugzillaTaskDataHandler taskDataHandler;
    private BugzillaClientManager clientManager;
    private Set<BugzillaLanguageSettings> languages = new LinkedHashSet<BugzillaLanguageSettings>();

    public void init(TaskList taskList) {
        super.init(taskList);
        this.taskDataHandler = new BugzillaTaskDataHandler(this);
        this.attachmentHandler = new BugzillaAttachmentHandler(this);
        BugzillaCorePlugin.setConnector(this);
        BugzillaLanguageSettings enSetting = new BugzillaLanguageSettings("en (default)");
        enSetting.addLanguageAttribute("error_login", "Login");
        enSetting.addLanguageAttribute("error_login", "log in");
        enSetting.addLanguageAttribute("error_login", "check e-mail");
        enSetting.addLanguageAttribute("error_login", "Invalid Username Or Password");
        enSetting.addLanguageAttribute("error_collision", "Mid-air collision!");
        enSetting.addLanguageAttribute("error_comment_required", "Comment Required");
        enSetting.addLanguageAttribute("error_logged_out", "logged out");
        enSetting.addLanguageAttribute("bad_login", "Login");
        enSetting.addLanguageAttribute("bad_login", "log in");
        enSetting.addLanguageAttribute("bad_login", "check e-mail");
        enSetting.addLanguageAttribute("bad_login", "Invalid Username Or Password");
        enSetting.addLanguageAttribute("bad_login", "error");
        enSetting.addLanguageAttribute("processed", "processed");
        enSetting.addLanguageAttribute("changes_submitted", "Changes submitted");
        this.languages.add(enSetting);
    }

    public String getLabel() {
        return CLIENT_LABEL;
    }

    public AbstractAttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler;
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public String getConnectorKind() {
        return "bugzilla";
    }

    public AbstractTask createTask(String repositoryUrl, String id, String summary) {
        BugzillaTask task = new BugzillaTask(repositoryUrl, id, summary);
        task.setCreationDate(new Date());
        return task;
    }

    public void updateTaskFromTaskData(TaskRepository repository, AbstractTask repositoryTask, RepositoryTaskData taskData) {
        BugzillaTask bugzillaTask = (BugzillaTask)repositoryTask;
        if (taskData != null) {
            String severity;
            Date dateCreated;
            String createdString;
            String summary = taskData.getSummary();
            bugzillaTask.setSummary(summary);
            String owner = taskData.getAssignedTo();
            if (owner != null && !owner.equals("")) {
                bugzillaTask.setOwner(owner);
            }
            if ((createdString = taskData.getCreated()) != null && createdString.length() > 0 && (dateCreated = taskData.getAttributeFactory().getDateForAttributeType("task.common.date.created", taskData.getCreated())) != null) {
                bugzillaTask.setCreationDate(dateCreated);
            }
            boolean isComplete = false;
            if (taskData.getStatus() != null) {
                isComplete = taskData.getStatus().equals("RESOLVED") || taskData.getStatus().equals("CLOSED") || taskData.getStatus().equals("VERIFIED");
            }
            bugzillaTask.setCompleted(isComplete);
            if (isComplete) {
                Date completionDate = null;
                try {
                    List taskComments = taskData.getComments();
                    if (taskComments != null && !taskComments.isEmpty()) {
                        completionDate = new SimpleDateFormat(COMMENT_FORMAT).parse(((TaskComment)taskComments.get(taskComments.size() - 1)).getCreated());
                    }
                }
                catch (Exception exception) {}
                if (bugzillaTask.getCompletionDate() != null) {
                    // empty if block
                }
                bugzillaTask.setCompletionDate(completionDate);
            }
            String priority = AbstractTask.PriorityLevel.getDefault().toString();
            if (taskData.getAttribute("task.common.priority") != null) {
                priority = taskData.getAttribute("task.common.priority").getValue();
            }
            bugzillaTask.setPriority(priority);
            String url = this.getTaskUrl(repository.getUrl(), taskData.getId());
            if (url != null) {
                bugzillaTask.setUrl(url);
            }
            if (taskData.getProduct() != null) {
                bugzillaTask.setProduct(taskData.getProduct());
            }
            if ((severity = taskData.getAttributeValue(BugzillaReportElement.BUG_SEVERITY.getKeyString())) != null && !severity.equals("")) {
                bugzillaTask.setSeverity(severity);
            }
            if (taskData.getAttribute(BugzillaReportElement.ESTIMATED_TIME.getKeyString()) != null) {
                Date dueDate = null;
                try {
                    String dueStr = taskData.getAttributeValue(BugzillaReportElement.DEADLINE.getKeyString());
                    if (dueStr != null) {
                        dueDate = new SimpleDateFormat(DEADLINE_FORMAT).parse(dueStr);
                    }
                }
                catch (Exception exception) {}
                bugzillaTask.setDueDate(dueDate);
            }
        }
    }

    public boolean updateTaskFromQueryHit(TaskRepository repository, AbstractTask existingTask, AbstractTask newTask) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean markStaleTasks(TaskRepository repository, Set<AbstractTask> tasks, IProgressMonitor monitor) throws CoreException {
        try {
            if (tasks.isEmpty()) lbl-1000:
            // 3 sources

            {
                return true;
            }
            try {
                block13: {
                    monitor.beginTask("Checking for changed tasks", -1);
                    if (repository.getSynchronizationTimeStamp() != null) break block13;
                    var5_4 = tasks.iterator();
                    while (true) {
                        if (!var5_4.hasNext()) ** GOTO lbl-1000
                        task = var5_4.next();
                        task.setStale(true);
                    }
                }
                dateString = repository.getSynchronizationTimeStamp();
                if (dateString == null) {
                    dateString = "";
                }
                urlQueryBase = String.valueOf(repository.getUrl()) + "/buglist.cgi?query_format=advanced&chfieldfrom=" + URLEncoder.encode(dateString, repository.getCharacterEncoding()) + "&chfieldto=Now";
                urlQueryString = String.valueOf(urlQueryBase) + "&bug_id=";
                changedTasks = new HashSet<AbstractTask>();
                itr = tasks.iterator();
                queryCounter = 0;
                checking = new HashSet<AbstractTask>();
                while (itr.hasNext()) {
                    task = itr.next();
                    checking.add(task);
                    newurlQueryString = URLEncoder.encode(String.valueOf(task.getTaskId()) + ",", repository.getCharacterEncoding());
                    urlQueryString = String.valueOf(urlQueryString) + newurlQueryString;
                    if (++queryCounter >= 1000) {
                        this.queryForChanged(repository, changedTasks, urlQueryString);
                        queryCounter = 0;
                        urlQueryString = String.valueOf(urlQueryBase) + "&bug_id=";
                        newurlQueryString = "";
                    }
                    if (itr.hasNext() || queryCounter == 0) continue;
                    this.queryForChanged(repository, changedTasks, urlQueryString);
                }
                var12_15 = tasks.iterator();
                while (true) {
                    if (var12_15.hasNext()) ** break;
                    ** continue;
                    task = var12_15.next();
                    if (!changedTasks.contains(task)) continue;
                    task.setStale(true);
                }
            }
            catch (UnsupportedEncodingException e) {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Repository configured with unsupported encoding: " + repository.getCharacterEncoding() + "\n\n Unable to determine changed tasks.", (Throwable)e));
                return false;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void queryForChanged(TaskRepository repository, Set<AbstractTask> changedTasks, String urlQueryString) throws UnsupportedEncodingException, CoreException {
        QueryHitCollector collector = new QueryHitCollector(new ITaskFactory(){

            public AbstractTask createTask(RepositoryTaskData taskData, IProgressMonitor monitor) {
                return BugzillaRepositoryConnector.this.taskList.getTask(taskData.getRepositoryUrl(), taskData.getId());
            }
        });
        BugzillaRepositoryQuery query = new BugzillaRepositoryQuery(repository.getUrl(), urlQueryString, "");
        this.performQuery(query, repository, (IProgressMonitor)new NullProgressMonitor(), (ITaskCollector)collector);
        changedTasks.addAll(collector.getTasks());
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public IStatus performQuery(AbstractRepositoryQuery query, TaskRepository repository, IProgressMonitor monitor, ITaskCollector resultCollector) {
        try {
            monitor.beginTask("Running query", -1);
            BugzillaClient client = this.getClientManager().getClient(repository);
            boolean hitsReceived = client.getSearchHits(query, resultCollector);
            if (!hitsReceived) {
                client.logout();
                client.getSearchHits(query, resultCollector);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (UnrecognizedReponseException e) {
            Status status = new Status(4, "org.eclipse.mylyn.bugzilla", 1, "Unrecognized response from server", (Throwable)e);
            return status;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.mylyn.bugzilla", 4, "Check repository configuration: " + e.getMessage(), (Throwable)e);
            return status;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("/show_bug.cgi?id=");
        return index == -1 ? null : url.substring(0, index);
    }

    public String getTaskIdFromTaskUrl(String url) {
        int index;
        if (url == null) {
            return null;
        }
        int anchorIndex = url.lastIndexOf("#");
        String bugUrl = url;
        if (anchorIndex != -1) {
            bugUrl = url.substring(0, anchorIndex);
        }
        return (index = bugUrl.indexOf("/show_bug.cgi?id=")) == -1 ? null : bugUrl.substring(index + "/show_bug.cgi?id=".length());
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        try {
            return BugzillaClient.getBugUrlWithoutLogin(repositoryUrl, taskId);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Error constructing task url for " + repositoryUrl + "  id:" + taskId, (Throwable)e));
            return null;
        }
    }

    public void updateTaskFromRepository(TaskRepository repository, AbstractTask repositoryTask, IProgressMonitor monitor) throws CoreException {
        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "updateTaskFromRepository called!" + repositoryTask.getTaskKey() + " [" + repositoryTask.getRepositoryUrl() + "]"));
        throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "Unable to retrieve data for task"));
    }

    public String getTaskIdPrefix() {
        return "bug";
    }

    public BugzillaClientManager getClientManager() {
        if (this.clientManager == null) {
            this.clientManager = new BugzillaClientManager();
        }
        return this.clientManager;
    }

    public void updateAttributes(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        if (repository != null) {
            BugzillaCorePlugin.getRepositoryConfiguration(repository, true);
        }
    }

    public boolean isRepositoryConfigurationStale(TaskRepository repository) throws CoreException {
        if (super.isRepositoryConfigurationStale(repository)) {
            boolean result = true;
            try {
                String timestamp;
                BugzillaClient client = this.getClientManager().getClient(repository);
                if (client != null && (timestamp = client.getConfigurationTimestamp()) != null) {
                    String oldTimestamp = repository.getProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp");
                    if (oldTimestamp != null) {
                        result = !timestamp.equals(oldTimestamp);
                    }
                    repository.setProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp", timestamp);
                }
            }
            catch (MalformedURLException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Error retrieving configuration timestamp for " + repository.getUrl(), (Throwable)e));
            }
            return result;
        }
        return false;
    }

    public static int getBugId(String taskId) throws CoreException {
        try {
            return Integer.parseInt(taskId);
        }
        catch (NumberFormatException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", 0, "Invalid bug id: " + taskId, (Throwable)e));
        }
    }

    public void addLanguageSetting(BugzillaLanguageSettings language) {
        if (!this.languages.contains(language)) {
            this.languages.add(language);
        }
    }

    public Set<BugzillaLanguageSettings> getLanguageSettings() {
        return this.languages;
    }

    public BugzillaLanguageSettings getLanguageSetting(String label) {
        for (BugzillaLanguageSettings language : this.getLanguageSettings()) {
            if (!language.getLanguageName().equals(label)) continue;
            return language;
        }
        return BugzillaCorePlugin.getDefault().getLanguageSetting("en (default)");
    }
}

