/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.AttachmentPartSource;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylyn.internal.bugzilla.core.MultiBugReportFactory;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfigurationFactory;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryQueryResultsFactory;
import org.eclipse.mylyn.internal.bugzilla.core.history.TaskHistory;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.RepositoryOperation;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.web.core.GzipGetMethod;
import org.eclipse.mylyn.web.core.GzipPostMethod;
import org.eclipse.mylyn.web.core.HtmlStreamTokenizer;
import org.eclipse.mylyn.web.core.HtmlTag;
import org.eclipse.mylyn.web.core.WebClientUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaClient {
    private static final int MAX_RETRIEVED_PER_QUERY = 100;
    private static final String QUERY_DELIMITER = "?";
    private static final String KEY_ID = "id";
    private static final String VAL_TRUE = "true";
    private static final String KEY_REMOVECC = "removecc";
    private static final String KEY_CC = "cc";
    private static final String POST_BUG_CGI = "/post_bug.cgi";
    private static final String PROCESS_BUG_CGI = "/process_bug.cgi";
    public static final int WRAP_LENGTH = 90;
    private static final String VAL_PROCESS_BUG = "process_bug";
    private static final String KEY_FORM_NAME = "form_name";
    private static final String VAL_NONE = "none";
    private static final String KEY_KNOB = "knob";
    private static final String KEY_COMMENT = "comment";
    private static final String KEY_SHORT_DESC = "short_desc";
    private static final String LOGIN_REQUIRED = "goaheadandlogin=1";
    private static final String VALUE_CONTENTTYPEMETHOD_MANUAL = "manual";
    private static final String VALUE_ISPATCH = "1";
    private static final String VALUE_ACTION_INSERT = "insert";
    private static final String ATTRIBUTE_CONTENTTYPEENTRY = "contenttypeentry";
    private static final String ATTRIBUTE_CONTENTTYPEMETHOD = "contenttypemethod";
    private static final String ATTRIBUTE_ISPATCH = "ispatch";
    private static final String CONTENT_TYPE_APP_RDF_XML = "application/rdf+xml";
    private static final String CONTENT_TYPE_APP_XML = "application/xml";
    private static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    private static final String[] VALID_CONFIG_CONTENT_TYPES = new String[]{"application/rdf+xml", "application/xml", "text/xml"};
    private static final String ATTR_CHARSET = "charset";
    private static final BugzillaAttributeFactory attributeFactory = new BugzillaAttributeFactory();
    protected Proxy proxy = Proxy.NO_PROXY;
    protected String username;
    protected String password;
    protected URL repositoryUrl;
    protected String characterEncoding;
    private boolean authenticated;
    private String htAuthUser;
    private String htAuthPass;
    private Map<String, String> configParameters;
    private HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    private boolean lastModifiedSupported = true;
    private BugzillaLanguageSettings bugzillaLanguageSettings;

    public BugzillaClient(URL url, String username, String password, String htAuthUser, String htAuthPass, String characterEncoding) {
        this(url, username, password, htAuthUser, htAuthPass, characterEncoding, new HashMap<String, String>(), BugzillaCorePlugin.getDefault().getLanguageSetting("en (default)"));
    }

    public BugzillaClient(URL url, String username, String password, String htAuthUser, String htAuthPass, String characterEncoding, Map<String, String> configParameters, BugzillaLanguageSettings languageSettings) {
        this.username = username;
        this.password = password;
        this.repositoryUrl = url;
        this.htAuthUser = htAuthUser;
        this.htAuthPass = htAuthPass;
        this.characterEncoding = characterEncoding;
        this.configParameters = configParameters;
        this.bugzillaLanguageSettings = languageSettings;
    }

    public void validate() throws IOException, CoreException {
        GzipGetMethod method = null;
        try {
            this.logout();
            method = this.getConnect(this.repositoryUrl + "/");
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    protected boolean hasAuthenticationCredentials() {
        return this.username != null && this.username.length() > 0;
    }

    private GzipGetMethod getConnect(String serverURL) throws IOException, CoreException {
        return this.connectInternal(serverURL, false);
    }

    private GzipGetMethod getConnectGzip(String serverURL) throws IOException, CoreException {
        return this.connectInternal(serverURL, true);
    }

    private GzipGetMethod connectInternal(String requestURL, boolean gzip) throws IOException, CoreException {
        WebClientUtil.setupHttpClient((HttpClient)this.httpClient, (Proxy)this.proxy, (String)requestURL, (String)this.htAuthUser, (String)this.htAuthPass);
        int attempt = 0;
        while (attempt < 2) {
            int code;
            if (!this.authenticated && this.hasAuthenticationCredentials()) {
                this.authenticate();
            }
            GzipGetMethod getMethod = new GzipGetMethod(WebClientUtil.getRequestPath((String)requestURL), gzip);
            if (requestURL.contains(QUERY_DELIMITER)) {
                getMethod.setQueryString(requestURL.substring(requestURL.indexOf(QUERY_DELIMITER)));
            }
            getMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.characterEncoding);
            if (gzip) {
                getMethod.setRequestHeader("Accept-encoding", "gzip");
            }
            this.httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
            getMethod.setDoAuthentication(true);
            try {
                code = this.httpClient.executeMethod((HttpMethod)getMethod);
            }
            catch (IOException e) {
                getMethod.getResponseBodyNoop();
                getMethod.releaseConnection();
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), e));
            }
            if (code == 200) {
                return getMethod;
            }
            if (code != 401 && code != 403) {
                if (code == 407) {
                    this.authenticated = false;
                    getMethod.getResponseBodyNoop();
                    getMethod.releaseConnection();
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Proxy authentication required"));
                }
                getMethod.getResponseBodyNoop();
                getMethod.releaseConnection();
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, "Http error: " + HttpStatus.getStatusText((int)code)));
            }
            getMethod.getResponseBodyNoop();
            getMethod.releaseConnection();
            this.authenticated = false;
            this.authenticate();
            ++attempt;
        }
        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 7, "All connection attempts to " + this.repositoryUrl.toString() + " failed. Please verify connection and authentication information."));
    }

    /*
     * Exception decompiling
     */
    public void logout() throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void authenticate() throws CoreException {
        if (!this.hasAuthenticationCredentials()) {
            this.authenticated = false;
            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Authentication credentials missing."));
        }
        GzipPostMethod postMethod = null;
        try {
            try {
                WebClientUtil.setupHttpClient((HttpClient)this.httpClient, (Proxy)this.proxy, (String)this.repositoryUrl.toString(), (String)this.htAuthUser, (String)this.htAuthPass);
                NameValuePair[] formData = new NameValuePair[]{new NameValuePair("Bugzilla_login", this.username), new NameValuePair("Bugzilla_password", this.password)};
                postMethod = new GzipPostMethod(WebClientUtil.getRequestPath((String)(String.valueOf(this.repositoryUrl.toString()) + "/index.cgi")), true);
                postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.characterEncoding);
                postMethod.setRequestBody(formData);
                postMethod.setDoAuthentication(true);
                postMethod.setFollowRedirects(false);
                this.httpClient.getParams().setAuthenticationPreemptive(true);
                int code = this.httpClient.executeMethod((HttpMethod)postMethod);
                if (code == 401 || code == 403) {
                    this.authenticated = false;
                    postMethod.getResponseBodyNoop();
                    postMethod.releaseConnection();
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "HTTP authentication failed."));
                }
                if (code == 407) {
                    this.authenticated = false;
                    postMethod.getResponseBodyNoop();
                    postMethod.releaseConnection();
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Proxy authentication required"));
                }
                if (code != 200) {
                    this.authenticated = false;
                    postMethod.getResponseBodyNoop();
                    postMethod.releaseConnection();
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, "Http error: " + HttpStatus.getStatusText((int)code)));
                }
                if (this.hasAuthenticationCredentials()) {
                    BufferedReader responseReader = new BufferedReader(new InputStreamReader(postMethod.getResponseBodyAsUnzippedStream(), this.characterEncoding));
                    HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)responseReader, null);
                    HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                    while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                        String id;
                        HtmlTag tag;
                        if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HtmlTag.Type.A && (id = tag.getAttribute("href")) != null && id.toLowerCase(Locale.ENGLISH).contains(LOGIN_REQUIRED)) {
                            responseReader.close();
                            this.authenticated = false;
                            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Invalid repository credentials."));
                        }
                        token = tokenizer.nextToken();
                    }
                }
                this.authenticated = true;
            }
            catch (ParseException parseException) {
                this.authenticated = false;
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 7, "Unable to parse response from " + this.repositoryUrl.toString() + "."));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), e));
            }
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
            this.httpClient.getParams().setAuthenticationPreemptive(false);
        }
    }

    public RepositoryTaskData getTaskData(int id) throws IOException, CoreException {
        String idString = String.valueOf(id);
        HashSet<String> data = new HashSet<String>();
        data.add(idString);
        Map<String, RepositoryTaskData> returnedData = this.getTaskData(data);
        return returnedData.get(idString);
    }

    public boolean getSearchHits(AbstractRepositoryQuery query, ITaskCollector collector) throws IOException, CoreException {
        GzipPostMethod postMethod = null;
        try {
            NameValuePair ctypePair;
            int n;
            String[] result;
            String queryUrl = query.getUrl();
            int start = queryUrl.indexOf(63);
            ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
            if (start != -1 && (result = (queryUrl = queryUrl.substring(start + 1)).split("&")).length > 0) {
                String[] stringArray = result;
                n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    String[] nameValue = string.split("=");
                    if (nameValue.length == 1) {
                        pairs.add(new NameValuePair(nameValue[0].trim(), ""));
                    } else if (nameValue.length == 2 && nameValue[0] != null && nameValue[1] != null) {
                        pairs.add(new NameValuePair(nameValue[0].trim(), URLDecoder.decode(nameValue[1].trim(), this.characterEncoding)));
                    }
                    ++n2;
                }
            }
            if (!pairs.contains(ctypePair = new NameValuePair("ctype", "rdf"))) {
                pairs.add(ctypePair);
            }
            if ((postMethod = this.postFormData("/buglist.cgi", pairs.toArray(new NameValuePair[pairs.size()]))).getResponseHeader("Content-Type") != null) {
                Header responseTypeHeader = postMethod.getResponseHeader("Content-Type");
                String[] stringArray = VALID_CONFIG_CONTENT_TYPES;
                int n3 = VALID_CONFIG_CONTENT_TYPES.length;
                n = 0;
                while (n < n3) {
                    String type = stringArray[n];
                    if (responseTypeHeader.getValue().toLowerCase(Locale.ENGLISH).contains(type)) {
                        RepositoryQueryResultsFactory queryFactory = new RepositoryQueryResultsFactory(postMethod.getResponseBodyAsUnzippedStream(), this.characterEncoding);
                        queryFactory.performQuery(this.repositoryUrl.toString(), collector, 5000);
                        boolean bl = !collector.getTasks().isEmpty();
                        return bl;
                    }
                    ++n;
                }
            }
            this.parseHtmlError(new BufferedReader(new InputStreamReader(postMethod.getResponseBodyAsUnzippedStream(), this.characterEncoding)));
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return false;
    }

    public static void setupExistingBugAttributes(String serverUrl, RepositoryTaskData existingReport) {
        BugzillaReportElement[] reportElements;
        BugzillaReportElement[] bugzillaReportElementArray = reportElements = new BugzillaReportElement[]{BugzillaReportElement.SHORT_DESC, BugzillaReportElement.BUG_STATUS, BugzillaReportElement.RESOLUTION, BugzillaReportElement.BUG_ID, BugzillaReportElement.REP_PLATFORM, BugzillaReportElement.PRODUCT, BugzillaReportElement.OP_SYS, BugzillaReportElement.COMPONENT, BugzillaReportElement.VERSION, BugzillaReportElement.PRIORITY, BugzillaReportElement.BUG_SEVERITY, BugzillaReportElement.ASSIGNED_TO, BugzillaReportElement.TARGET_MILESTONE, BugzillaReportElement.REPORTER, BugzillaReportElement.DEPENDSON, BugzillaReportElement.BLOCKED, BugzillaReportElement.BUG_FILE_LOC, BugzillaReportElement.NEWCC, BugzillaReportElement.KEYWORDS, BugzillaReportElement.CC, BugzillaReportElement.NEW_COMMENT, BugzillaReportElement.QA_CONTACT, BugzillaReportElement.STATUS_WHITEBOARD, BugzillaReportElement.DEADLINE};
        int n = reportElements.length;
        int n2 = 0;
        while (n2 < n) {
            BugzillaReportElement element = bugzillaReportElementArray[n2];
            RepositoryTaskAttribute reportAttribute = BugzillaClient.makeNewAttribute(element);
            existingReport.addAttribute(element.getKeyString(), reportAttribute);
            ++n2;
        }
    }

    public static String getBugUrlWithoutLogin(String repositoryUrl, String id) {
        String url = String.valueOf(repositoryUrl) + "/show_bug.cgi?id=" + id;
        return url;
    }

    public static String getCharsetFromString(String string) {
        int charsetStartIndex = string.indexOf(ATTR_CHARSET);
        if (charsetStartIndex != -1) {
            int charsetEndIndex = string.indexOf("\"", charsetStartIndex);
            if (charsetEndIndex == -1) {
                charsetEndIndex = string.length();
            }
            String charsetString = string.substring(charsetStartIndex + 8, charsetEndIndex);
            if (Charset.availableCharsets().containsKey(charsetString)) {
                return charsetString;
            }
        }
        return null;
    }

    protected static RepositoryTaskAttribute makeNewAttribute(BugzillaReportElement tag) {
        return attributeFactory.createAttribute(tag.getKeyString());
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public RepositoryConfiguration getRepositoryConfiguration() throws IOException, CoreException {
        GzipGetMethod method = null;
        try {
            method = this.getConnectGzip(this.repositoryUrl + "/config.cgi?ctype=rdf");
            if (method == null) {
                throw new IOException("Could not retrieve configuratoin. HttpClient return null method.");
            }
            if (method.getResponseHeader("Content-Type") != null) {
                Header responseTypeHeader = method.getResponseHeader("Content-Type");
                String[] stringArray = VALID_CONFIG_CONTENT_TYPES;
                int n = VALID_CONFIG_CONTENT_TYPES.length;
                int n2 = 0;
                while (n2 < n) {
                    InputStream stream;
                    RepositoryConfigurationFactory configFactory;
                    RepositoryConfiguration configuration;
                    String type = stringArray[n2];
                    if (responseTypeHeader.getValue().toLowerCase(Locale.ENGLISH).contains(type) && (configuration = (configFactory = new RepositoryConfigurationFactory(stream = method.getResponseBodyAsUnzippedStream(), this.characterEncoding)).getConfiguration()) != null) {
                        configuration.setRepositoryUrl(this.repositoryUrl.toString());
                        RepositoryConfiguration repositoryConfiguration = configuration;
                        return repositoryConfiguration;
                    }
                    ++n2;
                }
            }
            this.parseHtmlError(new BufferedReader(new InputStreamReader(method.getResponseBodyAsUnzippedStream(), this.characterEncoding)));
            return null;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public InputStream getAttachmentData(String attachmentId) throws IOException, CoreException {
        String url = this.repositoryUrl + "/attachment.cgi?id=" + attachmentId;
        GzipGetMethod method = this.getConnectGzip(url);
        try {
            return method.getResponseBodyAsUnzippedStream();
        }
        catch (IOException e) {
            method.releaseConnection();
            throw e;
        }
    }

    public void postAttachment(String bugReportID, String comment, ITaskAttachment attachment) throws HttpException, IOException, CoreException {
        block11: {
            WebClientUtil.setupHttpClient((HttpClient)this.httpClient, (Proxy)this.proxy, (String)this.repositoryUrl.toString(), (String)this.htAuthUser, (String)this.htAuthPass);
            if (!this.authenticated && this.hasAuthenticationCredentials()) {
                this.authenticate();
            }
            GzipPostMethod postMethod = null;
            try {
                postMethod = new GzipPostMethod(WebClientUtil.getRequestPath((String)(this.repositoryUrl + "/attachment.cgi")), true);
                postMethod.getParams().setBooleanParameter("http.protocol.expect-continue", true);
                ArrayList<Object> parts = new ArrayList<Object>();
                parts.add(new StringPart("action", VALUE_ACTION_INSERT, this.characterEncoding));
                if (this.username != null && this.password != null) {
                    parts.add(new StringPart("Bugzilla_login", this.username, this.characterEncoding));
                    parts.add(new StringPart("Bugzilla_password", this.password, this.characterEncoding));
                }
                parts.add(new StringPart("bugid", bugReportID, this.characterEncoding));
                if (attachment.getDescription() != null) {
                    parts.add(new StringPart("description", attachment.getDescription(), this.characterEncoding));
                }
                if (comment != null) {
                    parts.add(new StringPart(KEY_COMMENT, comment, this.characterEncoding));
                }
                parts.add(new FilePart("data", (PartSource)new AttachmentPartSource(attachment)));
                if (attachment.isPatch()) {
                    parts.add(new StringPart(ATTRIBUTE_ISPATCH, VALUE_ISPATCH));
                } else {
                    parts.add(new StringPart(ATTRIBUTE_CONTENTTYPEMETHOD, VALUE_CONTENTTYPEMETHOD_MANUAL));
                    parts.add(new StringPart(ATTRIBUTE_CONTENTTYPEENTRY, attachment.getContentType()));
                }
                postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[1]), postMethod.getParams()));
                postMethod.setDoAuthentication(true);
                int status = this.httpClient.executeMethod((HttpMethod)postMethod);
                if (status == 200) {
                    InputStreamReader reader = new InputStreamReader(postMethod.getResponseBodyAsUnzippedStream(), postMethod.getResponseCharSet());
                    BufferedReader bufferedReader = new BufferedReader(reader);
                    this.parseHtmlError(bufferedReader);
                    break block11;
                }
                postMethod.getResponseBodyNoop();
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, this.repositoryUrl.toString(), "Http error: " + HttpStatus.getStatusText((int)status)));
            }
            finally {
                if (postMethod != null) {
                    postMethod.releaseConnection();
                }
            }
        }
    }

    private GzipPostMethod postFormData(String formUrl, NameValuePair[] formData) throws IOException, CoreException {
        GzipPostMethod postMethod = null;
        WebClientUtil.setupHttpClient((HttpClient)this.httpClient, (Proxy)this.proxy, (String)this.repositoryUrl.toString(), (String)this.htAuthUser, (String)this.htAuthPass);
        if (!this.authenticated && this.hasAuthenticationCredentials()) {
            this.authenticate();
        }
        postMethod = new GzipPostMethod(WebClientUtil.getRequestPath((String)(String.valueOf(this.repositoryUrl.toString()) + formUrl)), true);
        postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.characterEncoding);
        this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
        postMethod.setRequestBody(formData);
        postMethod.setDoAuthentication(true);
        int status = this.httpClient.executeMethod((HttpMethod)postMethod);
        if (status == 200) {
            return postMethod;
        }
        postMethod.getResponseBodyNoop();
        postMethod.releaseConnection();
        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), new IOException("Communication error occurred during upload. \n\n" + HttpStatus.getStatusText((int)status))));
    }

    public String postTaskData(RepositoryTaskData taskData) throws IOException, CoreException {
        NameValuePair[] formData = null;
        String prefix = null;
        String prefix2 = null;
        String postfix = null;
        String postfix2 = null;
        if (taskData == null) {
            return null;
        }
        if (taskData.isNew()) {
            formData = this.getPairsForNew(taskData);
            prefix = "Bug ";
            prefix2 = "Issue ";
            postfix = " posted";
            postfix2 = " Submitted";
        } else {
            formData = this.getPairsForExisting(taskData);
        }
        String result = null;
        GzipPostMethod method = null;
        try {
            method = taskData.isNew() ? this.postFormData(POST_BUG_CGI, formData) : this.postFormData(PROCESS_BUG_CGI, formData);
            if (method == null) {
                throw new IOException("Could not post form, client returned null method.");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(method.getResponseBodyAsUnzippedStream(), method.getRequestCharSet()));
            in.mark(1028);
            HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)in, null);
            boolean existingBugPosted = false;
            boolean isTitle = false;
            String title = "";
            HtmlStreamTokenizer.Token token = tokenizer.nextToken();
            while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HtmlTag.Type.TITLE && !((HtmlTag)token.getValue()).isEndTag()) {
                    isTitle = true;
                } else if (isTitle) {
                    if (token.getType() != HtmlStreamTokenizer.Token.TAG) {
                        title = String.valueOf(title) + ((StringBuffer)token.getValue()).toString().toLowerCase(Locale.ENGLISH) + " ";
                    } else if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HtmlTag.Type.TITLE && ((HtmlTag)token.getValue()).isEndTag()) {
                        boolean found = false;
                        Iterator<String> iterator = this.bugzillaLanguageSettings.getResponseForCommand("processed").iterator();
                        while (iterator.hasNext() && !found) {
                            String value = iterator.next().toLowerCase(Locale.ENGLISH);
                            boolean bl = found = found || title.indexOf(value) != -1;
                        }
                        if (!taskData.isNew() && found) {
                            existingBugPosted = true;
                            break;
                        }
                        if (!taskData.isNew() || prefix == null || prefix2 == null || postfix == null || postfix2 == null) break;
                        int startIndex = -1;
                        int startIndexPrefix = title.toLowerCase(Locale.ENGLISH).indexOf(prefix.toLowerCase(Locale.ENGLISH));
                        int startIndexPrefix2 = title.toLowerCase(Locale.ENGLISH).indexOf(prefix2.toLowerCase(Locale.ENGLISH));
                        if (startIndexPrefix == -1 && startIndexPrefix2 == -1) break;
                        startIndex = startIndexPrefix != -1 ? startIndexPrefix + prefix.length() : startIndexPrefix2 + prefix2.length();
                        int stopIndex = title.toLowerCase(Locale.ENGLISH).indexOf(postfix.toLowerCase(Locale.ENGLISH), startIndex);
                        if (stopIndex == -1) {
                            stopIndex = title.toLowerCase(Locale.ENGLISH).indexOf(postfix2.toLowerCase(Locale.ENGLISH), startIndex);
                        }
                        if (stopIndex <= -1) break;
                        result = title.substring(startIndex, stopIndex).trim();
                        break;
                    }
                }
                token = tokenizer.nextToken();
            }
            if (!taskData.isNew() && !existingBugPosted || taskData.isNew() && result == null) {
                try {
                    in.reset();
                }
                catch (IOException iOException) {}
                this.parseHtmlError(in);
            }
            String string = result;
            return string;
        }
        catch (ParseException parseException) {
            this.authenticated = false;
            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 7, "Unable to parse response from " + this.repositoryUrl.toString() + "."));
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private NameValuePair[] getPairsForNew(RepositoryTaskData taskData) {
        HashMap<String, NameValuePair> fields = new HashMap<String, NameValuePair>();
        for (RepositoryTaskAttribute a : taskData.getAttributes()) {
            if (a == null || a.getId() == null || a.getId().compareTo("") == 0) continue;
            String value = null;
            value = a.getValue();
            if (value == null) continue;
            if (a.getId().equals(BugzillaReportElement.NEWCC.getKeyString())) {
                RepositoryTaskAttribute b = new RepositoryTaskAttribute(BugzillaReportElement.CC.getKeyString(), BugzillaReportElement.CC.toString(), false);
                for (String val : a.getValues()) {
                    if (val == null) continue;
                    b.addValue(val);
                }
                a = b;
                this.cleanIfShortLogin(a);
            } else {
                this.cleanQAContact(a);
            }
            fields.put(a.getId(), new NameValuePair(a.getId(), value));
        }
        if (taskData.getDescription().length() != 0) {
            fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, taskData.getDescription()));
        }
        return fields.values().toArray(new NameValuePair[fields.size()]);
    }

    private void cleanQAContact(RepositoryTaskAttribute a) {
        if (a.getId().equals(BugzillaReportElement.QA_CONTACT.getKeyString())) {
            this.cleanIfShortLogin(a);
        }
    }

    private void cleanIfShortLogin(RepositoryTaskAttribute a) {
        int atIndex;
        if (VAL_TRUE.equals(this.configParameters.get("bugzilla.shortLoginEnabled")) && a.getValue() != null && a.getValue().length() > 0 && (atIndex = a.getValue().indexOf("@")) != -1) {
            String newValue = a.getValue().substring(0, atIndex);
            a.setValue(newValue);
        }
    }

    private NameValuePair[] getPairsForExisting(RepositoryTaskData model) {
        HashMap<String, NameValuePair> fields = new HashMap<String, NameValuePair>();
        fields.put(KEY_FORM_NAME, new NameValuePair(KEY_FORM_NAME, VAL_PROCESS_BUG));
        for (RepositoryTaskAttribute a : model.getAttributes()) {
            if (a == null) continue;
            if (a.getId().equals(BugzillaReportElement.QA_CONTACT.getKeyString()) || a.getId().equals(BugzillaReportElement.ASSIGNED_TO.getKeyString())) {
                this.cleanIfShortLogin(a);
            } else if (a.getId().equals(BugzillaReportElement.REPORTER.getKeyString()) || a.getId().equals(BugzillaReportElement.CC.getKeyString()) || a.getId().equals("task.common.removecc") || a.getId().equals(BugzillaReportElement.CREATION_TS.getKeyString())) continue;
            if (a.getId() == null || a.getId().compareTo("") == 0) continue;
            String value = a.getValue();
            if (a.getId().equals(BugzillaReportElement.DELTA_TS.getKeyString())) {
                value = BugzillaClient.stripTimeZone(value);
            }
            fields.put(a.getId(), new NameValuePair(a.getId(), value != null ? value : ""));
        }
        fields.put(KEY_ID, new NameValuePair(KEY_ID, model.getAttributeValue(BugzillaReportElement.BUG_ID.getKeyString())));
        RepositoryOperation o = model.getSelectedOperation();
        if (o == null) {
            fields.put(KEY_KNOB, new NameValuePair(KEY_KNOB, VAL_NONE));
        } else {
            String sel;
            fields.put(KEY_KNOB, new NameValuePair(KEY_KNOB, o.getKnobName()));
            if (o.hasOptions()) {
                sel = o.getOptionValue(o.getOptionSelection());
                fields.put(o.getOptionName(), new NameValuePair(o.getOptionName(), sel));
            } else if (o.isInput()) {
                sel = o.getInputValue();
                fields.put(o.getInputName(), new NameValuePair(o.getInputName(), sel));
            }
        }
        if (model.getAttribute(BugzillaReportElement.SHORT_DESC.getKeyString()) != null) {
            fields.put(KEY_SHORT_DESC, new NameValuePair(KEY_SHORT_DESC, model.getAttribute(BugzillaReportElement.SHORT_DESC.getKeyString()).getValue()));
        }
        if (model.getNewComment().length() != 0) {
            fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, model.getNewComment()));
        } else if (o != null && o.getKnobName().equals(IBugzillaConstants.BUGZILLA_OPERATION.duplicate.toString())) {
            fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, ""));
        }
        List removeCC = model.getAttributeValues("task.common.removecc");
        if (removeCC != null && removeCC.size() > 0) {
            String[] s = new String[removeCC.size()];
            fields.put(KEY_CC, new NameValuePair(KEY_CC, BugzillaClient.toCommaSeparatedList(removeCC.toArray(s))));
            fields.put(KEY_REMOVECC, new NameValuePair(KEY_REMOVECC, VAL_TRUE));
        }
        return fields.values().toArray(new NameValuePair[fields.size()]);
    }

    public static String stripTimeZone(String longTime) {
        String[] values;
        String result = longTime;
        if (longTime != null && (values = longTime.split(" ")) != null && values.length > 2) {
            result = String.valueOf(values[0]) + " " + values[1];
        }
        return result;
    }

    private static String toCommaSeparatedList(String[] strings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            buffer.append(strings[i]);
            if (i != strings.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    /*
     * Exception decompiling
     */
    public void parseHtmlError(BufferedReader in) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public TaskHistory getHistory(String taskId) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<String, RepositoryTaskData> getTaskData(Set<String> taskIds) throws IOException, CoreException {
        GzipPostMethod method = null;
        HashMap<String, RepositoryTaskData> taskDataMap = new HashMap<String, RepositoryTaskData>();
        while (taskIds.size() > 0) {
            try {
                HashSet<String> idsToRetrieve = new HashSet<String>();
                Iterator<String> itr = taskIds.iterator();
                int x = 0;
                while (itr.hasNext() && x < 100) {
                    idsToRetrieve.add(itr.next());
                    ++x;
                }
                NameValuePair[] formData = new NameValuePair[idsToRetrieve.size() + 2];
                if (idsToRetrieve.size() == 0) {
                    HashMap<String, RepositoryTaskData> hashMap = taskDataMap;
                    return hashMap;
                }
                itr = idsToRetrieve.iterator();
                int x2 = 0;
                while (itr.hasNext()) {
                    String taskId = itr.next();
                    formData[x2] = new NameValuePair(KEY_ID, taskId);
                    RepositoryTaskData taskData = new RepositoryTaskData((AbstractAttributeFactory)new BugzillaAttributeFactory(), "bugzilla", this.repositoryUrl.toString(), taskId);
                    BugzillaClient.setupExistingBugAttributes(this.repositoryUrl.toString(), taskData);
                    taskDataMap.put(taskId, taskData);
                    ++x2;
                }
                formData[x2++] = new NameValuePair("ctype", "xml");
                formData[x2] = new NameValuePair("excludefield", "attachmentdata");
                method = this.postFormData("/show_bug.cgi", formData);
                if (method == null) {
                    throw new IOException("Could not post form, client returned null method.");
                }
                boolean parseable = false;
                if (method.getResponseHeader("Content-Type") != null) {
                    Header responseTypeHeader = method.getResponseHeader("Content-Type");
                    String[] stringArray = VALID_CONFIG_CONTENT_TYPES;
                    int n = VALID_CONFIG_CONTENT_TYPES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String type = stringArray[n2];
                        if (responseTypeHeader.getValue().toLowerCase(Locale.ENGLISH).contains(type)) {
                            MultiBugReportFactory factory = new MultiBugReportFactory(method.getResponseBodyAsUnzippedStream(), this.characterEncoding);
                            factory.populateReport(taskDataMap);
                            taskIds.removeAll(idsToRetrieve);
                            parseable = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (parseable) continue;
                this.parseHtmlError(new BufferedReader(new InputStreamReader(method.getResponseBodyAsUnzippedStream(), this.characterEncoding)));
                break;
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return taskDataMap;
    }

    public String getConfigurationTimestamp() throws CoreException {
        if (!this.lastModifiedSupported) {
            return null;
        }
        String lastModified = null;
        HeadMethod method = null;
        try {
            try {
                method = this.connectHead(this.repositoryUrl + "/config.cgi?ctype=rdf");
                Header lastModifiedHeader = method.getResponseHeader("Last-Modified");
                if (lastModifiedHeader != null && lastModifiedHeader.getValue() != null && lastModifiedHeader.getValue().length() > 0) {
                    lastModified = lastModifiedHeader.getValue();
                } else {
                    this.lastModifiedSupported = false;
                }
            }
            catch (Exception e) {
                this.lastModifiedSupported = false;
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Error retrieving configuration timestamp", (Throwable)e));
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return lastModified;
    }

    private HeadMethod connectHead(String requestURL) throws IOException, CoreException {
        WebClientUtil.setupHttpClient((HttpClient)this.httpClient, (Proxy)this.proxy, (String)requestURL, (String)this.htAuthUser, (String)this.htAuthPass);
        int attempt = 0;
        while (attempt < 2) {
            int code;
            if (!this.authenticated && this.hasAuthenticationCredentials()) {
                this.authenticate();
            }
            HeadMethod headMethod = new HeadMethod(WebClientUtil.getRequestPath((String)requestURL));
            if (requestURL.contains(QUERY_DELIMITER)) {
                headMethod.setQueryString(requestURL.substring(requestURL.indexOf(QUERY_DELIMITER)));
            }
            headMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.characterEncoding);
            headMethod.setDoAuthentication(true);
            try {
                code = this.httpClient.executeMethod((HttpMethod)headMethod);
            }
            catch (IOException e) {
                headMethod.getResponseBody();
                headMethod.releaseConnection();
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), e));
            }
            if (code == 200) {
                return headMethod;
            }
            if (code != 401 && code != 403) {
                if (code == 407) {
                    this.authenticated = false;
                    headMethod.getResponseBody();
                    headMethod.releaseConnection();
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Proxy authentication required"));
                }
                headMethod.getResponseBody();
                headMethod.releaseConnection();
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, "Http error: " + HttpStatus.getStatusText((int)code)));
            }
            headMethod.getResponseBody();
            headMethod.releaseConnection();
            this.authenticated = false;
            this.authenticate();
            ++attempt;
        }
        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 7, "All connection attempts to " + this.repositoryUrl.toString() + " failed. Please verify connection and authentication information."));
    }
}

