/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;

public class BugzillaAttributeFactory
extends AbstractAttributeFactory {
    private static final String DATE_FORMAT_1 = "yyyy-MM-dd HH:mm";
    private static final String DATE_FORMAT_2 = "yyyy-MM-dd HH:mm:ss";
    private static final String delta_ts_format = "yyyy-MM-dd HH:mm:ss";
    private static final String creation_ts_format = "yyyy-MM-dd HH:mm";
    public static final String comment_creation_ts_format = "yyyy-MM-dd HH:mm";
    private static final String attachment_creation_ts_format = "yyyy-MM-dd HH:mm";
    private static final long serialVersionUID = 5087501781682994759L;

    public String mapCommonAttributeKey(String key) {
        if (key.equals("task.common.newcc")) {
            return BugzillaReportElement.NEWCC.getKeyString();
        }
        if (key.equals("task.common.comment.date")) {
            return BugzillaReportElement.BUG_WHEN.getKeyString();
        }
        if (key.equals("task.common.comment.author")) {
            return BugzillaReportElement.WHO.getKeyString();
        }
        if (key.equals("task.common.comment.author.name")) {
            return BugzillaReportElement.WHO_NAME.getKeyString();
        }
        if (key.equals("task.common.user.cc")) {
            return BugzillaReportElement.CC.getKeyString();
        }
        if (key.equals("task.common.comment.text")) {
            return BugzillaReportElement.THETEXT.getKeyString();
        }
        if (key.equals("task.common.date.created")) {
            return BugzillaReportElement.CREATION_TS.getKeyString();
        }
        if (key.equals("task.common.description")) {
            return BugzillaReportElement.DESC.getKeyString();
        }
        if (key.equals("task.common.attachment.id")) {
            return BugzillaReportElement.ATTACHID.getKeyString();
        }
        if (key.equals("task.common.attachment.type")) {
            return BugzillaReportElement.TYPE.getKeyString();
        }
        if (key.equals("task.common.attachment.ctype")) {
            return BugzillaReportElement.CTYPE.getKeyString();
        }
        if (key.equals("task.common.user.assigned")) {
            return BugzillaReportElement.ASSIGNED_TO.getKeyString();
        }
        if (key.equals("task.common.user.assigned.name")) {
            return BugzillaReportElement.ASSIGNED_TO_NAME.getKeyString();
        }
        if (key.equals("task.common.resolution")) {
            return BugzillaReportElement.RESOLUTION.getKeyString();
        }
        if (key.equals("task.common.status")) {
            return BugzillaReportElement.BUG_STATUS.getKeyString();
        }
        if (key.equals("task.common.date.modified")) {
            return BugzillaReportElement.DELTA_TS.getKeyString();
        }
        if (key.equals("task.common.user.reporter")) {
            return BugzillaReportElement.REPORTER.getKeyString();
        }
        if (key.equals("task.common.user.reporter.name")) {
            return BugzillaReportElement.REPORTER_NAME.getKeyString();
        }
        if (key.equals("task.common.summary")) {
            return BugzillaReportElement.SHORT_DESC.getKeyString();
        }
        if (key.equals("task.common.product")) {
            return BugzillaReportElement.PRODUCT.getKeyString();
        }
        if (key.equals("task.common.keywords")) {
            return BugzillaReportElement.KEYWORDS.getKeyString();
        }
        if (key.equals("task.common.attachment.date")) {
            return BugzillaReportElement.DATE.getKeyString();
        }
        if (key.equals("task.common.attachment.size")) {
            return BugzillaReportElement.SIZE.getKeyString();
        }
        if (key.equals("task.common.addselfcc")) {
            return BugzillaReportElement.ADDSELFCC.getKeyString();
        }
        if (key.equals("task.common.priority")) {
            return BugzillaReportElement.PRIORITY.getKeyString();
        }
        if (key.equals("task.common.comment.new")) {
            return BugzillaReportElement.NEW_COMMENT.getKeyString();
        }
        if (key.equals("task.common.component")) {
            return BugzillaReportElement.COMPONENT.getKeyString();
        }
        return key;
    }

    public boolean isHidden(String key) {
        try {
            return BugzillaReportElement.valueOf(key.trim().toUpperCase(Locale.ENGLISH)).isHidden();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public String getName(String key) {
        try {
            return BugzillaReportElement.valueOf(key.trim().toUpperCase(Locale.ENGLISH)).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "<unknown>";
        }
    }

    public boolean isReadOnly(String key) {
        try {
            return BugzillaReportElement.valueOf(key.trim().toUpperCase(Locale.ENGLISH)).isReadOnly();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
    }

    public Date getDateForAttributeType(String attributeKey, String dateString) {
        if (dateString == null || dateString.equals("")) {
            return null;
        }
        try {
            String mappedKey = this.mapCommonAttributeKey(attributeKey);
            Date parsedDate = null;
            if (mappedKey.equals(BugzillaReportElement.DELTA_TS.getKeyString())) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateString);
            } else if (mappedKey.equals(BugzillaReportElement.CREATION_TS.getKeyString())) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(dateString);
            } else if (mappedKey.equals(BugzillaReportElement.BUG_WHEN.getKeyString())) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(dateString);
            } else if (mappedKey.equals(BugzillaReportElement.DATE.getKeyString())) {
                parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(dateString);
            }
            return parsedDate;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

