/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class BugzillaAttachmentHandler
extends AbstractAttachmentHandler {
    private BugzillaRepositoryConnector connector;

    public BugzillaAttachmentHandler(BugzillaRepositoryConnector connector) {
        this.connector = connector;
    }

    public InputStream getAttachmentAsStream(TaskRepository repository, RepositoryAttachment attachment, IProgressMonitor monitor) throws CoreException {
        try {
            BugzillaClient client = this.connector.getClientManager().getClient(repository);
            return client.getAttachmentData(attachment.getId());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, repository.getUrl(), e));
        }
    }

    public void uploadAttachment(TaskRepository repository, AbstractTask task, ITaskAttachment attachment, String comment, IProgressMonitor monitor) throws CoreException {
        try {
            String bugId = task.getTaskId();
            BugzillaClient client = this.connector.getClientManager().getClient(repository);
            client.postAttachment(bugId, comment, attachment);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, repository.getUrl(), e));
        }
    }

    public boolean canDownloadAttachment(TaskRepository repository, AbstractTask task) {
        return true;
    }

    public boolean canUploadAttachment(TaskRepository repository, AbstractTask task) {
        return true;
    }

    public boolean canDeprecate(TaskRepository repository, RepositoryAttachment attachment) {
        return false;
    }

    public void updateAttachment(TaskRepository repository, RepositoryAttachment attachment) throws CoreException {
    }
}

