/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddExtensionCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.SpecificationForExtensionsSchema;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddExtensionElementCommand
extends AddExtensionCommand {
    XSDElementDeclaration element;
    Element appInfo;
    Element newElement;

    public AddExtensionElementCommand(String label, XSDConcreteComponent input, XSDElementDeclaration element) {
        super(label);
        this.component = input;
        this.element = element;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.component.getElement());
            super.execute();
            this.addAnnotationSet(this.component.getSchema(), this.extensionsSchemaSpec);
            this.formatChild(this.component.getElement());
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.endRecording();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.endRecording();
    }

    public void undo() {
        super.undo();
        XSDAnnotation xsdAnnotation = XSDCommonUIUtils.getInputXSDAnnotation(this.component, false);
        xsdAnnotation.getElement().removeChild(this.appInfo);
        EList appInfos = xsdAnnotation.getApplicationInformation();
        appInfos.remove(this.appInfo);
        xsdAnnotation.updateElement();
    }

    public void setSchemaProperties(SpecificationForExtensionsSchema spec) {
        this.extensionsSchemaSpec = spec;
    }

    public void addAnnotationSet(XSDSchema xsdSchema, SpecificationForExtensionsSchema spec) {
        XSDAnnotation xsdAnnotation = XSDCommonUIUtils.getInputXSDAnnotation(this.component, true);
        this.addAnnotationSet(spec, xsdAnnotation);
    }

    private void addAnnotationSet(SpecificationForExtensionsSchema spec, XSDAnnotation xsdAnnotation) {
        XSDSchema schema = xsdAnnotation.getSchema();
        Element schemaElement = schema.getElement();
        if (xsdAnnotation.getApplicationInformation().size() == 0) {
            this.appInfo = xsdAnnotation.createApplicationInformation(null);
            xsdAnnotation.getElement().appendChild(this.appInfo);
            EList appInfos = xsdAnnotation.getApplicationInformation();
            appInfos.add(this.appInfo);
        } else {
            this.appInfo = (Element)xsdAnnotation.getApplicationInformation().get(0);
        }
        String prefix = this.addNamespaceDeclarationIfRequired(schemaElement, "p", spec.getNamespaceURI());
        if (this.appInfo != null) {
            Document doc = this.appInfo.getOwnerDocument();
            this.newElement = doc.createElementNS(spec.getNamespaceURI(), this.element.getName());
            this.newElement.setPrefix(prefix);
            this.appInfo.appendChild(this.newElement);
            xsdAnnotation.updateElement();
        }
    }

    public Object getNewObject() {
        return this.newElement;
    }

    protected String createUniquePrefix(XSDConcreteComponent component) {
        String prefix = "p";
        Map prefMapper = component.getSchema().getQNamePrefixToNamespaceMap();
        if (prefMapper.get(prefix) != null) {
            int i = 1;
            while (prefMapper.get(String.valueOf(prefix) + i) != null) {
                ++i;
            }
            prefix = String.valueOf(prefix) + i;
        }
        return prefix;
    }

    private String addNamespaceDeclarationIfRequired(Element schemaElement, String prefixHint, String namespace) {
        String prefix = null;
        NamespaceTable namespaceTable = new NamespaceTable(schemaElement.getOwnerDocument());
        namespaceTable.addElement(schemaElement);
        prefix = namespaceTable.getPrefixForURI(namespace);
        if (prefix == null) {
            String basePrefix;
            prefix = basePrefix = prefixHint;
            String xmlnsColon = "xmlns:";
            String attributeName = String.valueOf(xmlnsColon) + prefix;
            int count = 0;
            while (schemaElement.getAttribute(attributeName) != null) {
                prefix = String.valueOf(basePrefix) + ++count;
                attributeName = String.valueOf(xmlnsColon) + prefix;
            }
            schemaElement.setAttribute(attributeName, namespace);
        }
        return prefix;
    }
}

