/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;

public class SourceValidationQuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public boolean canFix(Annotation annotation) {
        Object fixInfo;
        if (annotation instanceof TemporaryAnnotation && (fixInfo = ((TemporaryAnnotation)annotation).getAdditionalFixInfo()) instanceof IQuickAssistProcessor) {
            return ((IQuickAssistProcessor)fixInfo).canFix(annotation);
        }
        return false;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        int documentOffset = quickAssistContext.getOffset();
        int length = viewer != null ? viewer.getSelectedRange().y : 0;
        TextInvocationContext context = new TextInvocationContext(viewer, documentOffset, length);
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        List proposals = this.computeProposals((IQuickAssistInvocationContext)context, model);
        if (proposals.isEmpty()) {
            return null;
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private boolean isAtPosition(int offset, Position pos) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }

    private List computeProposals(IQuickAssistInvocationContext context, IAnnotationModel model) {
        int offset = context.getOffset();
        ArrayList proposalsList = new ArrayList();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position pos;
            Annotation annotation = (Annotation)iter.next();
            if (!this.canFix(annotation) || !this.isAtPosition(offset, pos = model.getPosition(annotation))) continue;
            context = new TextInvocationContext(context.getSourceViewer(), pos.getOffset(), pos.getLength());
            this.collectProposals(annotation, context, proposalsList);
        }
        return proposalsList;
    }

    private void collectProposals(Annotation annotation, IQuickAssistInvocationContext invocationContext, List proposalsList) {
        ICompletionProposal[] proposals;
        TemporaryAnnotation temporaryAnno = (TemporaryAnnotation)annotation;
        Object fixInfo = temporaryAnno.getAdditionalFixInfo();
        if (fixInfo instanceof IQuickAssistProcessor && (proposals = ((IQuickAssistProcessor)fixInfo).computeQuickAssistProposals(invocationContext)) != null && proposals.length > 0) {
            proposalsList.addAll(Arrays.asList(proposals));
        }
    }

    public String getErrorMessage() {
        return null;
    }
}

