/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.web.core.AuthenticationCredentials;
import org.eclipse.mylyn.web.core.AuthenticationType;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public abstract class AbstractRepositorySettingsPage
extends WizardPage {
    protected static final String PREFS_PAGE_ID_NET_PROXY = "org.eclipse.ui.net.NetPreferences";
    protected static final String LABEL_REPOSITORY_LABEL = "Label: ";
    protected static final String LABEL_SERVER = "Server: ";
    protected static final String LABEL_USER = "User ID: ";
    protected static final String LABEL_PASSWORD = "Password: ";
    protected static final String URL_PREFIX_HTTPS = "https://";
    protected static final String URL_PREFIX_HTTP = "http://";
    protected static final String INVALID_REPOSITORY_URL = "Repository url is invalid.";
    protected static final String INVALID_LOGIN = "Unable to authenticate with repository. Login credentials invalid.";
    protected AbstractRepositoryConnector connector;
    protected StringFieldEditor repositoryLabelEditor;
    protected Combo serverUrlCombo;
    private String serverVersion = "unknown";
    protected StringFieldEditor repositoryUserNameEditor;
    protected StringFieldEditor repositoryPasswordEditor;
    protected StringFieldEditor httpAuthUserNameEditor;
    protected StringFieldEditor httpAuthPasswordEditor;
    protected StringFieldEditor proxyHostnameEditor;
    protected StringFieldEditor proxyPortEditor;
    protected StringFieldEditor proxyUserNameEditor;
    protected StringFieldEditor proxyPasswordEditor;
    protected TaskRepository repository;
    private Button validateServerButton;
    private Combo otherEncodingCombo;
    private Button defaultEncoding;
    protected Button anonymousButton;
    private String oldUsername;
    private String oldPassword;
    private String oldHttpAuthUserId;
    private String oldHttpAuthPassword;
    private boolean needsAnonymousLogin;
    private boolean needsTimeZone;
    private boolean needsEncoding;
    private boolean needsHttpAuth;
    private boolean needsValidation;
    private boolean needsAdvanced;
    protected Composite compositeContainer;
    private Composite advancedComp;
    private Composite httpAuthComp;
    private Composite proxyAuthComp;
    private ExpandableComposite advancedExpComposite;
    private ExpandableComposite httpAuthExpComposite;
    private ExpandableComposite proxyExpComposite;
    private Set<String> repositoryUrls;
    private String originalUrl;
    private Button otherEncoding;
    private Button httpAuthButton;
    private boolean needsProxy;
    private Button systemProxyButton;
    private String oldProxyUsername = "";
    private String oldProxyPassword = "";
    private String oldProxyHostname = "";
    private String oldProxyPort = "";
    private Button proxyAuthButton;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Hyperlink createAccountHyperlink;
    private Hyperlink manageAccountHyperlink;
    private Button savePasswordButton;
    private Button saveHttpPasswordButton;
    private Button saveProxyPasswordButton;
    private Button disconnectedButton;

    public AbstractRepositorySettingsPage(String title, String description, AbstractRepositoryConnectorUi repositoryUi) {
        super(title);
        AbstractRepositoryConnector connector;
        super.setTitle(title);
        super.setDescription(description);
        this.connector = connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repositoryUi.getConnectorKind());
        this.setNeedsAnonymousLogin(false);
        this.setNeedsEncoding(true);
        this.setNeedsTimeZone(true);
        this.setNeedsProxy(true);
        this.setNeedsValidation(true);
        this.setNeedsAdvanced(true);
    }

    public void dispose() {
        super.dispose();
        if (this.toolkit != null && this.toolkit.getColors() != null) {
            this.toolkit.dispose();
        }
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout2;
        GridData gridData_2;
        if (this.repository != null) {
            this.originalUrl = this.repository.getUrl();
            this.oldUsername = this.repository.getUserName();
            this.oldPassword = this.repository.getPassword();
            if (this.repository.getHttpUser() != null && this.repository.getHttpPassword() != null) {
                this.oldHttpAuthUserId = this.repository.getHttpUser();
                this.oldHttpAuthPassword = this.repository.getHttpPassword();
            } else {
                this.oldHttpAuthPassword = "";
                this.oldHttpAuthUserId = "";
            }
            this.oldProxyHostname = this.repository.getProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname");
            this.oldProxyPort = this.repository.getProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port");
            if (this.oldProxyHostname == null) {
                this.oldProxyHostname = "";
            }
            if (this.oldProxyPort == null) {
                this.oldProxyPort = "";
            }
            this.oldProxyUsername = this.repository.getProxyUsername();
            this.oldProxyPassword = this.repository.getProxyPassword();
            if (this.oldProxyUsername == null) {
                this.oldProxyUsername = "";
            }
            if (this.oldProxyPassword == null) {
                this.oldProxyPassword = "";
            }
        } else {
            this.oldUsername = "";
            this.oldPassword = "";
            this.oldHttpAuthPassword = "";
            this.oldHttpAuthUserId = "";
        }
        this.compositeContainer = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        this.compositeContainer.setLayout((Layout)layout);
        new Label(this.compositeContainer, 0).setText(LABEL_SERVER);
        this.serverUrlCombo = new Combo(this.compositeContainer, 4);
        this.serverUrlCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRepositorySettingsPage.this.isValidUrl(AbstractRepositorySettingsPage.this.serverUrlCombo.getText());
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        this.serverUrlCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AbstractRepositorySettingsPage.this.updateHyperlinks();
            }
        });
        this.serverUrlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRepositorySettingsPage.this.isValidUrl(AbstractRepositorySettingsPage.this.serverUrlCombo.getText());
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        GridDataFactory.fillDefaults().hint(300, -1).grab(true, false).applyTo((Control)this.serverUrlCombo);
        this.repositoryLabelEditor = new StringFieldEditor("", LABEL_REPOSITORY_LABEL, StringFieldEditor.UNLIMITED, this.compositeContainer){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        if (this.needsAnonymousLogin()) {
            this.anonymousButton = new Button(this.compositeContainer, 32);
            GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)this.anonymousButton);
            this.anonymousButton.setText("Anonymous Access");
            this.anonymousButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractRepositorySettingsPage.this.setAnonymous(AbstractRepositorySettingsPage.this.anonymousButton.getSelection());
                    AbstractRepositorySettingsPage.this.isPageComplete();
                }
            });
        }
        this.repositoryUserNameEditor = new StringFieldEditor("", LABEL_USER, StringFieldEditor.UNLIMITED, this.compositeContainer){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                AbstractRepositorySettingsPage.this.isPageComplete();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.repositoryPasswordEditor = new RepositoryStringFieldEditor("", LABEL_PASSWORD, StringFieldEditor.UNLIMITED, this.compositeContainer){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                AbstractRepositorySettingsPage.this.isPageComplete();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.savePasswordButton = new Button(this.compositeContainer, 32);
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)this.savePasswordButton);
        this.savePasswordButton.setText("Save Password");
        if (this.repository != null) {
            try {
                String repositoryLabel = this.repository.getProperty("label");
                if (repositoryLabel != null && repositoryLabel.length() > 0) {
                    this.repositoryLabelEditor.setStringValue(repositoryLabel);
                }
                this.serverUrlCombo.setText(this.repository.getUrl());
                this.repositoryUserNameEditor.setStringValue(this.repository.getUserName());
                this.repositoryPasswordEditor.setStringValue(this.repository.getPassword());
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not set field value", t));
            }
        }
        if (this.needsAnonymousLogin()) {
            if (this.repository != null) {
                this.setAnonymous(this.repository.isAnonymous());
            } else {
                this.setAnonymous(true);
            }
        }
        if (this.repository != null) {
            this.savePasswordButton.setSelection(this.repository.getSavePassword(AuthenticationType.REPOSITORY));
        } else {
            this.savePasswordButton.setSelection(false);
        }
        if (this.needsAdvanced() || this.needsEncoding()) {
            this.advancedExpComposite = this.toolkit.createExpandableComposite(this.compositeContainer, 290);
            this.advancedExpComposite.clientVerticalSpacing = 0;
            gridData_2 = new GridData(4, 4, true, false);
            gridData_2.horizontalIndent = -5;
            this.advancedExpComposite.setLayoutData((Object)gridData_2);
            this.advancedExpComposite.setFont(this.compositeContainer.getFont());
            this.advancedExpComposite.setBackground(this.compositeContainer.getBackground());
            this.advancedExpComposite.setText("Additional Settings");
            this.advancedExpComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    AbstractRepositorySettingsPage.this.getControl().getShell().pack();
                }
            });
            GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)this.advancedExpComposite);
            this.advancedComp = this.toolkit.createComposite((Composite)this.advancedExpComposite, 0);
            gridLayout2 = new GridLayout();
            gridLayout2.numColumns = 2;
            gridLayout2.verticalSpacing = 5;
            this.advancedComp.setLayout((Layout)gridLayout2);
            this.advancedComp.setBackground(this.compositeContainer.getBackground());
            this.advancedExpComposite.setClient((Control)this.advancedComp);
            this.createAdditionalControls(this.advancedComp);
            if (this.needsEncoding()) {
                Label encodingLabel = new Label(this.advancedComp, 256);
                encodingLabel.setText("Character encoding:");
                GridDataFactory.fillDefaults().align(1, 128).applyTo((Control)encodingLabel);
                Composite encodingContainer = new Composite(this.advancedComp, 0);
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.marginWidth = 0;
                gridLayout.marginHeight = 0;
                encodingContainer.setLayout((Layout)gridLayout);
                this.defaultEncoding = new Button(encodingContainer, 16);
                this.defaultEncoding.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
                this.defaultEncoding.setText("Default (UTF-8)");
                this.defaultEncoding.setSelection(true);
                this.otherEncoding = new Button(encodingContainer, 16);
                this.otherEncoding.setText("Other:");
                this.otherEncodingCombo = new Combo(encodingContainer, 8);
                for (String encoding : Charset.availableCharsets().keySet()) {
                    if (encoding.equals("UTF-8")) continue;
                    this.otherEncodingCombo.add(encoding);
                }
                this.setDefaultEncoding();
                this.otherEncoding.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (AbstractRepositorySettingsPage.this.otherEncoding.getSelection()) {
                            AbstractRepositorySettingsPage.this.defaultEncoding.setSelection(false);
                            AbstractRepositorySettingsPage.this.otherEncodingCombo.setEnabled(true);
                        } else {
                            AbstractRepositorySettingsPage.this.defaultEncoding.setSelection(true);
                            AbstractRepositorySettingsPage.this.otherEncodingCombo.setEnabled(false);
                        }
                    }
                });
                if (this.repository != null) {
                    try {
                        String repositoryEncoding = this.repository.getCharacterEncoding();
                        if (repositoryEncoding != null) {
                            if (this.otherEncodingCombo.getItemCount() > 0 && this.otherEncodingCombo.indexOf(repositoryEncoding) > -1) {
                                this.otherEncodingCombo.setEnabled(true);
                                this.otherEncoding.setSelection(true);
                                this.defaultEncoding.setSelection(false);
                                this.otherEncodingCombo.select(this.otherEncodingCombo.indexOf(repositoryEncoding));
                            } else {
                                this.setDefaultEncoding();
                            }
                        }
                    }
                    catch (Throwable t) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not set field value", t));
                    }
                }
            }
        }
        if (this.needsHttpAuth()) {
            this.httpAuthExpComposite = this.toolkit.createExpandableComposite(this.compositeContainer, 290);
            this.httpAuthExpComposite.clientVerticalSpacing = 0;
            gridData_2 = new GridData(4, 4, true, false);
            gridData_2.horizontalIndent = -5;
            this.httpAuthExpComposite.setLayoutData((Object)gridData_2);
            this.httpAuthExpComposite.setFont(this.compositeContainer.getFont());
            this.httpAuthExpComposite.setBackground(this.compositeContainer.getBackground());
            this.httpAuthExpComposite.setText("Http Authentication");
            this.httpAuthExpComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    AbstractRepositorySettingsPage.this.getControl().getShell().pack();
                }
            });
            GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)this.httpAuthExpComposite);
            this.httpAuthComp = this.toolkit.createComposite((Composite)this.httpAuthExpComposite, 0);
            gridLayout2 = new GridLayout();
            gridLayout2.numColumns = 2;
            gridLayout2.verticalSpacing = 0;
            this.httpAuthComp.setLayout((Layout)gridLayout2);
            this.httpAuthComp.setBackground(this.compositeContainer.getBackground());
            this.httpAuthExpComposite.setClient((Control)this.httpAuthComp);
            this.httpAuthButton = new Button(this.httpAuthComp, 32);
            GridDataFactory.fillDefaults().align(16384, 128).span(2, -1).applyTo((Control)this.httpAuthButton);
            this.httpAuthButton.setText("Enabled");
            this.httpAuthButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractRepositorySettingsPage.this.setHttpAuth(AbstractRepositorySettingsPage.this.httpAuthButton.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.httpAuthUserNameEditor = new StringFieldEditor("", LABEL_USER, StringFieldEditor.UNLIMITED, this.httpAuthComp){

                protected boolean doCheckState() {
                    return true;
                }

                protected void valueChanged() {
                    super.valueChanged();
                    if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                        AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                    }
                }
            };
            this.httpAuthPasswordEditor = new RepositoryStringFieldEditor("", LABEL_PASSWORD, StringFieldEditor.UNLIMITED, this.httpAuthComp);
            ((RepositoryStringFieldEditor)this.httpAuthPasswordEditor).getTextControl().setEchoChar('*');
            this.saveHttpPasswordButton = new Button(this.httpAuthComp, 32);
            GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)this.saveHttpPasswordButton);
            this.saveHttpPasswordButton.setText("Save Http Password");
            this.httpAuthUserNameEditor.setEnabled(this.httpAuthButton.getSelection(), this.httpAuthComp);
            this.httpAuthPasswordEditor.setEnabled(this.httpAuthButton.getSelection(), this.httpAuthComp);
            this.saveHttpPasswordButton.setEnabled(this.httpAuthButton.getSelection());
            if (this.repository != null) {
                this.saveHttpPasswordButton.setSelection(this.repository.getSavePassword(AuthenticationType.HTTP));
            } else {
                this.saveHttpPasswordButton.setSelection(false);
            }
            this.setHttpAuth(this.oldHttpAuthPassword != null && this.oldHttpAuthUserId != null && !this.oldHttpAuthUserId.equals(""));
            this.httpAuthExpComposite.setExpanded(this.httpAuthButton.getSelection());
        }
        if (this.needsProxy()) {
            this.addProxySection();
        }
        this.addStatusSection();
        Composite managementComposite = new Composite(this.compositeContainer, 0);
        GridLayout managementLayout = new GridLayout(4, false);
        managementLayout.marginHeight = 0;
        managementLayout.marginWidth = 0;
        managementLayout.horizontalSpacing = 10;
        managementComposite.setLayout((Layout)managementLayout);
        managementComposite.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        if (this.needsValidation()) {
            this.validateServerButton = new Button(managementComposite, 8);
            GridDataFactory.swtDefaults().span(2, -1).grab(false, false).applyTo((Control)this.validateServerButton);
            this.validateServerButton.setText("Validate Settings");
            this.validateServerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractRepositorySettingsPage.this.validateSettings();
                }
            });
        }
        this.createAccountHyperlink = this.toolkit.createHyperlink(managementComposite, "Create new account", 0);
        this.createAccountHyperlink.setBackground(managementComposite.getBackground());
        this.createAccountHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String accountCreationUrl;
                TaskRepository repository = AbstractRepositorySettingsPage.this.createTaskRepository();
                if (repository != null && (accountCreationUrl = TasksUiPlugin.getConnectorUi(AbstractRepositorySettingsPage.this.connector.getConnectorKind()).getAccountCreationUrl(repository)) != null) {
                    TasksUiUtil.openUrl(accountCreationUrl, false);
                }
            }
        });
        this.manageAccountHyperlink = this.toolkit.createHyperlink(managementComposite, "Change account settings", 0);
        this.manageAccountHyperlink.setBackground(managementComposite.getBackground());
        this.manageAccountHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String accountManagementUrl;
                TaskRepository repository = AbstractRepositorySettingsPage.this.getRepository();
                if (repository == null && AbstractRepositorySettingsPage.this.getServerUrl() != null && AbstractRepositorySettingsPage.this.getServerUrl().length() > 0) {
                    repository = AbstractRepositorySettingsPage.this.createTaskRepository();
                }
                if (repository != null && (accountManagementUrl = TasksUiPlugin.getConnectorUi(AbstractRepositorySettingsPage.this.connector.getConnectorKind()).getAccountManagementUrl(repository)) != null) {
                    TasksUiUtil.openUrl(accountManagementUrl, false);
                }
            }
        });
        ((RepositoryStringFieldEditor)this.repositoryPasswordEditor).getTextControl().setEchoChar('*');
        if (this.needsAnonymousLogin() && this.repository != null) {
            this.setAnonymous(this.isAnonymousAccess());
        }
        this.updateHyperlinks();
        this.setControl((Control)this.compositeContainer);
    }

    private void addProxySection() {
        this.proxyExpComposite = this.toolkit.createExpandableComposite(this.compositeContainer, 290);
        this.proxyExpComposite.clientVerticalSpacing = 0;
        GridData gridData_2 = new GridData(4, 4, true, false);
        gridData_2.horizontalIndent = -5;
        this.proxyExpComposite.setLayoutData((Object)gridData_2);
        this.proxyExpComposite.setFont(this.compositeContainer.getFont());
        this.proxyExpComposite.setBackground(this.compositeContainer.getBackground());
        this.proxyExpComposite.setText("Proxy Server Configuration");
        this.proxyExpComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                AbstractRepositorySettingsPage.this.getControl().getShell().pack();
            }
        });
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)this.proxyExpComposite);
        this.proxyAuthComp = this.toolkit.createComposite((Composite)this.proxyExpComposite, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.verticalSpacing = 0;
        this.proxyAuthComp.setLayout((Layout)gridLayout2);
        this.proxyAuthComp.setBackground(this.compositeContainer.getBackground());
        this.proxyExpComposite.setClient((Control)this.proxyAuthComp);
        Composite settingsComposite = new Composite(this.proxyAuthComp, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 2;
        gridLayout3.verticalSpacing = 0;
        settingsComposite.setLayout((Layout)gridLayout3);
        this.systemProxyButton = new Button(settingsComposite, 32);
        GridDataFactory.fillDefaults().align(16384, 128).span(2, -1).applyTo((Control)settingsComposite);
        this.systemProxyButton.setText("Use global Network Connections preferences");
        Hyperlink changeProxySettingsLink = this.toolkit.createHyperlink(settingsComposite, "Change Settings", 0);
        changeProxySettingsLink.setBackground(this.compositeContainer.getBackground());
        changeProxySettingsLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)AbstractRepositorySettingsPage.this.getShell(), (String)AbstractRepositorySettingsPage.PREFS_PAGE_ID_NET_PROXY, (String[])new String[]{AbstractRepositorySettingsPage.PREFS_PAGE_ID_NET_PROXY}, null);
                dlg.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.systemProxyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRepositorySettingsPage.this.setUseDefaultProxy(AbstractRepositorySettingsPage.this.systemProxyButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.proxyHostnameEditor = new StringFieldEditor("", "Proxy host address: ", StringFieldEditor.UNLIMITED, this.proxyAuthComp){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.proxyHostnameEditor.setStringValue(this.oldProxyHostname);
        this.proxyPortEditor = new RepositoryStringFieldEditor("", "Proxy host port: ", StringFieldEditor.UNLIMITED, this.proxyAuthComp);
        this.proxyPortEditor.setStringValue(this.oldProxyPort);
        this.proxyHostnameEditor.setEnabled(this.systemProxyButton.getSelection(), this.proxyAuthComp);
        this.proxyPortEditor.setEnabled(this.systemProxyButton.getSelection(), this.proxyAuthComp);
        this.proxyAuthButton = new Button(this.proxyAuthComp, 32);
        GridDataFactory.fillDefaults().align(16384, 128).span(2, -1).applyTo((Control)this.proxyAuthButton);
        this.proxyAuthButton.setText("Enable proxy authentication");
        this.proxyAuthButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractRepositorySettingsPage.this.setProxyAuth(AbstractRepositorySettingsPage.this.proxyAuthButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.proxyUserNameEditor = new StringFieldEditor("", LABEL_USER, StringFieldEditor.UNLIMITED, this.proxyAuthComp){

            protected boolean doCheckState() {
                return true;
            }

            protected void valueChanged() {
                super.valueChanged();
                if (AbstractRepositorySettingsPage.this.getWizard() != null) {
                    AbstractRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }
        };
        this.proxyPasswordEditor = new RepositoryStringFieldEditor("", LABEL_PASSWORD, StringFieldEditor.UNLIMITED, this.proxyAuthComp);
        ((RepositoryStringFieldEditor)this.proxyPasswordEditor).getTextControl().setEchoChar('*');
        this.saveProxyPasswordButton = new Button(this.proxyAuthComp, 32);
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)this.saveProxyPasswordButton);
        this.saveProxyPasswordButton.setText("Save Proxy Password");
        this.saveProxyPasswordButton.setEnabled(this.proxyAuthButton.getSelection());
        if (this.repository != null) {
            this.saveProxyPasswordButton.setSelection(this.repository.getSavePassword(AuthenticationType.PROXY));
        } else {
            this.saveProxyPasswordButton.setSelection(false);
        }
        this.setProxyAuth(this.oldProxyUsername != null && this.oldProxyPassword != null && !this.oldProxyUsername.equals(""));
        this.setUseDefaultProxy(this.repository != null ? this.repository.isDefaultProxyEnabled() : true);
        this.proxyExpComposite.setExpanded(!this.systemProxyButton.getSelection());
    }

    private void addStatusSection() {
        ExpandableComposite statusComposite = this.toolkit.createExpandableComposite(this.compositeContainer, 290);
        statusComposite.clientVerticalSpacing = 0;
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = -5;
        statusComposite.setLayoutData((Object)gd);
        statusComposite.setFont(this.compositeContainer.getFont());
        statusComposite.setBackground(this.compositeContainer.getBackground());
        statusComposite.setText("Status");
        statusComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                AbstractRepositorySettingsPage.this.getControl().getShell().pack();
            }
        });
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)statusComposite);
        Composite composite = this.toolkit.createComposite((Composite)statusComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setBackground(this.compositeContainer.getBackground());
        statusComposite.setClient((Control)composite);
        this.disconnectedButton = new Button(composite, 32);
        this.disconnectedButton.setText("Disconnected");
        GridDataFactory.fillDefaults().align(16384, 128).span(2, -1).applyTo((Control)this.disconnectedButton);
        this.disconnectedButton.setSelection(this.repository != null ? this.repository.isOffline() : false);
        statusComposite.setExpanded(this.disconnectedButton.getSelection());
    }

    protected void setEncoding(String encoding) {
        if (encoding.equals("UTF-8")) {
            this.setDefaultEncoding();
        } else if (this.otherEncodingCombo.indexOf(encoding) != -1) {
            this.defaultEncoding.setSelection(false);
            this.otherEncodingCombo.setEnabled(true);
            this.otherEncoding.setSelection(true);
            this.otherEncodingCombo.select(this.otherEncodingCombo.indexOf(encoding));
        } else {
            this.setDefaultEncoding();
        }
    }

    private void setDefaultEncoding() {
        this.defaultEncoding.setSelection(true);
        this.otherEncoding.setSelection(false);
        this.otherEncodingCombo.setEnabled(false);
        if (this.otherEncodingCombo.getItemCount() > 0) {
            this.otherEncodingCombo.select(0);
        }
    }

    public void setAnonymous(boolean selected) {
        if (!this.needsAnonymousLogin) {
            return;
        }
        this.anonymousButton.setSelection(selected);
        if (selected) {
            this.oldUsername = this.repositoryUserNameEditor.getStringValue();
            this.oldPassword = this.repositoryPasswordEditor.getStringValue();
            this.repositoryUserNameEditor.setStringValue("");
            this.repositoryPasswordEditor.setStringValue("");
        } else {
            this.repositoryUserNameEditor.setStringValue(this.oldUsername);
            this.repositoryPasswordEditor.setStringValue(this.oldPassword);
        }
        this.repositoryUserNameEditor.setEnabled(!selected, this.compositeContainer);
        this.repositoryPasswordEditor.setEnabled(!selected, this.compositeContainer);
        this.savePasswordButton.setEnabled(!selected);
        if (this.getWizard() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    public void setHttpAuth(boolean selected) {
        if (!this.needsHttpAuth) {
            return;
        }
        this.httpAuthButton.setSelection(selected);
        if (!selected) {
            this.oldHttpAuthUserId = this.httpAuthUserNameEditor.getStringValue();
            this.oldHttpAuthPassword = this.httpAuthPasswordEditor.getStringValue();
            this.httpAuthUserNameEditor.setStringValue(null);
            this.httpAuthPasswordEditor.setStringValue(null);
        } else {
            this.httpAuthUserNameEditor.setStringValue(this.oldHttpAuthUserId);
            this.httpAuthPasswordEditor.setStringValue(this.oldHttpAuthPassword);
        }
        this.httpAuthUserNameEditor.setEnabled(selected, this.httpAuthComp);
        this.httpAuthPasswordEditor.setEnabled(selected, this.httpAuthComp);
        this.saveHttpPasswordButton.setEnabled(selected);
    }

    public boolean getHttpAuth() {
        return this.httpAuthButton.getSelection();
    }

    public void setUseDefaultProxy(boolean selected) {
        if (!this.needsProxy) {
            return;
        }
        this.systemProxyButton.setSelection(selected);
        if (selected) {
            this.oldProxyHostname = this.proxyHostnameEditor.getStringValue();
            this.oldProxyPort = this.proxyPortEditor.getStringValue();
        } else {
            this.proxyHostnameEditor.setStringValue(this.oldProxyHostname);
            this.proxyPortEditor.setStringValue(this.oldProxyPort);
        }
        this.proxyHostnameEditor.setEnabled(!selected, this.proxyAuthComp);
        this.proxyPortEditor.setEnabled(!selected, this.proxyAuthComp);
        this.proxyAuthButton.setEnabled(!selected);
        this.setProxyAuth(this.proxyAuthButton.getSelection());
    }

    public void setProxyAuth(boolean selected) {
        this.proxyAuthButton.setSelection(selected);
        this.proxyAuthButton.setEnabled(!this.systemProxyButton.getSelection());
        if (!selected) {
            this.oldProxyUsername = this.proxyUserNameEditor.getStringValue();
            this.oldProxyPassword = this.proxyPasswordEditor.getStringValue();
            this.proxyUserNameEditor.setStringValue(null);
            this.proxyPasswordEditor.setStringValue(null);
        } else {
            this.proxyUserNameEditor.setStringValue(this.oldProxyUsername);
            this.proxyPasswordEditor.setStringValue(this.oldProxyPassword);
        }
        this.proxyUserNameEditor.setEnabled(selected && !this.systemProxyButton.getSelection(), this.proxyAuthComp);
        this.proxyPasswordEditor.setEnabled(selected && !this.systemProxyButton.getSelection(), this.proxyAuthComp);
        this.saveProxyPasswordButton.setEnabled(selected && !this.systemProxyButton.getSelection());
    }

    public boolean getProxyAuth() {
        return this.proxyAuthButton.getSelection();
    }

    protected abstract void createAdditionalControls(Composite var1);

    protected abstract boolean isValidUrl(String var1);

    void updateHyperlinks() {
        if (this.getServerUrl() != null && this.getServerUrl().length() > 0) {
            TaskRepository repository = this.createTaskRepository();
            String accountCreationUrl = TasksUiPlugin.getConnectorUi(this.connector.getConnectorKind()).getAccountCreationUrl(repository);
            this.createAccountHyperlink.setEnabled(accountCreationUrl != null);
            this.createAccountHyperlink.setVisible(accountCreationUrl != null);
            String accountManagementUrl = TasksUiPlugin.getConnectorUi(this.connector.getConnectorKind()).getAccountManagementUrl(repository);
            this.manageAccountHyperlink.setEnabled(accountManagementUrl != null);
            this.manageAccountHyperlink.setVisible(accountManagementUrl != null);
        } else {
            this.createAccountHyperlink.setEnabled(false);
            this.createAccountHyperlink.setVisible(false);
            this.manageAccountHyperlink.setEnabled(false);
            this.manageAccountHyperlink.setVisible(false);
        }
    }

    public String getRepositoryLabel() {
        return this.repositoryLabelEditor.getStringValue();
    }

    public String getServerUrl() {
        return TaskRepositoryManager.stripSlashes((String)this.serverUrlCombo.getText());
    }

    public String getUserName() {
        return this.repositoryUserNameEditor.getStringValue();
    }

    public String getPassword() {
        return this.repositoryPasswordEditor.getStringValue();
    }

    public String getHttpAuthUserId() {
        if (this.needsHttpAuth()) {
            return this.httpAuthUserNameEditor.getStringValue();
        }
        return "";
    }

    public String getHttpAuthPassword() {
        if (this.needsHttpAuth()) {
            return this.httpAuthPasswordEditor.getStringValue();
        }
        return "";
    }

    public String getProxyHostname() {
        if (this.needsProxy()) {
            return this.proxyHostnameEditor.getStringValue();
        }
        return "";
    }

    public String getProxyPort() {
        if (this.needsProxy()) {
            return this.proxyPortEditor.getStringValue();
        }
        return "";
    }

    public Boolean getUseDefaultProxy() {
        if (this.needsProxy()) {
            return this.systemProxyButton.getSelection();
        }
        return true;
    }

    public String getProxyUserName() {
        if (this.needsProxy()) {
            return this.proxyUserNameEditor.getStringValue();
        }
        return "";
    }

    public String getProxyPassword() {
        if (this.needsProxy()) {
            return this.proxyPasswordEditor.getStringValue();
        }
        return "";
    }

    public void init(IWorkbench workbench) {
    }

    public boolean isAnonymousAccess() {
        if (this.anonymousButton != null) {
            return this.anonymousButton.getSelection();
        }
        return false;
    }

    public boolean isPageComplete() {
        String errorMessage = null;
        String url = this.getServerUrl();
        errorMessage = this.isUniqueUrl(url);
        if (errorMessage == null && !this.isValidUrl(url)) {
            errorMessage = "Enter a valid server url";
        }
        if (errorMessage == null) {
            errorMessage = this.credentialsComplete();
        }
        this.setErrorMessage(errorMessage);
        return errorMessage == null;
    }

    private String credentialsComplete() {
        if (this.needsAnonymousLogin() && !this.anonymousButton.getSelection() && (this.repositoryUserNameEditor.getStringValue().trim().equals("") || this.repositoryPasswordEditor.getStringValue().trim().equals(""))) {
            return "Repository user name and password must not be blank";
        }
        return null;
    }

    protected String isUniqueUrl(String urlString) {
        if (!urlString.equals(this.originalUrl)) {
            if (this.repositoryUrls == null) {
                List repositories = TasksUiPlugin.getRepositoryManager().getAllRepositories();
                this.repositoryUrls = new HashSet<String>(repositories.size());
                for (TaskRepository repository : repositories) {
                    this.repositoryUrls.add(repository.getUrl());
                }
            }
            if (this.repositoryUrls.contains(urlString)) {
                return "Repository already exists.";
            }
        }
        return null;
    }

    public void setRepository(TaskRepository repository) {
        this.repository = repository;
    }

    public void setVersion(String previousVersion) {
        this.serverVersion = previousVersion == null ? "unknown" : previousVersion;
    }

    public String getVersion() {
        return this.serverVersion;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }

    public String getCharacterEncoding() {
        if (this.defaultEncoding == null) {
            return null;
        }
        if (this.defaultEncoding.getSelection()) {
            return "UTF-8";
        }
        if (this.otherEncodingCombo.getSelectionIndex() > -1) {
            return this.otherEncodingCombo.getItem(this.otherEncodingCombo.getSelectionIndex());
        }
        return "UTF-8";
    }

    public TaskRepository createTaskRepository() {
        TaskRepository repository = new TaskRepository(this.connector.getConnectorKind(), this.getServerUrl());
        this.applyTo(repository);
        return repository;
    }

    public void applyTo(TaskRepository repository) {
        AuthenticationCredentials webCredentials;
        repository.setVersion(this.getVersion());
        if (this.needsEncoding()) {
            repository.setCharacterEncoding(this.getCharacterEncoding());
        }
        if (this.isAnonymousAccess()) {
            repository.setCredentials(AuthenticationType.REPOSITORY, null, this.getSavePassword().booleanValue());
        } else {
            AuthenticationCredentials credentials = new AuthenticationCredentials(this.getUserName(), this.getPassword());
            repository.setCredentials(AuthenticationType.REPOSITORY, credentials, this.getSavePassword().booleanValue());
        }
        repository.setRepositoryLabel(this.getRepositoryLabel());
        repository.setAnonymous(this.isAnonymousAccess());
        if (this.needsHttpAuth()) {
            if (this.getHttpAuth()) {
                webCredentials = new AuthenticationCredentials(this.getHttpAuthUserId(), this.getHttpAuthPassword());
                repository.setCredentials(AuthenticationType.HTTP, webCredentials, this.getSaveHttpPassword().booleanValue());
            } else {
                repository.setCredentials(AuthenticationType.HTTP, null, this.getSaveHttpPassword().booleanValue());
            }
        }
        if (this.needsProxy()) {
            repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.usedefault", String.valueOf(this.getUseDefaultProxy()));
            repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname", this.getProxyHostname());
            repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port", this.getProxyPort());
            if (this.getProxyAuth()) {
                webCredentials = new AuthenticationCredentials(this.getProxyUserName(), this.getProxyPassword());
                repository.setCredentials(AuthenticationType.PROXY, webCredentials, this.getSaveProxyPassword().booleanValue());
            } else {
                repository.setCredentials(AuthenticationType.PROXY, null, this.getSaveProxyPassword().booleanValue());
            }
        }
        repository.setOffline(this.disconnectedButton.getSelection());
    }

    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    public boolean needsEncoding() {
        return this.needsEncoding;
    }

    public boolean needsTimeZone() {
        return this.needsTimeZone;
    }

    public boolean needsAnonymousLogin() {
        return this.needsAnonymousLogin;
    }

    public boolean needsAdvanced() {
        return this.needsAdvanced;
    }

    public void setNeedsEncoding(boolean needsEncoding) {
        this.needsEncoding = needsEncoding;
    }

    public void setNeedsTimeZone(boolean needsTimeZone) {
        this.needsTimeZone = needsTimeZone;
    }

    public void setNeedsAdvanced(boolean needsAdvanced) {
        this.needsAdvanced = needsAdvanced;
    }

    public boolean needsHttpAuth() {
        return this.needsHttpAuth;
    }

    public void setNeedsHttpAuth(boolean needsHttpAuth) {
        this.needsHttpAuth = needsHttpAuth;
    }

    public void setNeedsProxy(boolean needsProxy) {
        this.needsProxy = needsProxy;
    }

    public boolean needsProxy() {
        return this.needsProxy;
    }

    public void setNeedsAnonymousLogin(boolean needsAnonymousLogin) {
        this.needsAnonymousLogin = needsAnonymousLogin;
    }

    public void setNeedsValidation(boolean needsValidation) {
        this.needsValidation = needsValidation;
    }

    public boolean needsValidation() {
        return this.needsValidation;
    }

    public void updateProperties(TaskRepository repository) {
    }

    public void setUrl(String url) {
        this.serverUrlCombo.setText(url);
    }

    public void setUserId(String id) {
        this.repositoryUserNameEditor.setStringValue(id);
    }

    public void setPassword(String pass) {
        this.repositoryPasswordEditor.setStringValue(pass);
    }

    public Boolean getSavePassword() {
        return this.savePasswordButton.getSelection();
    }

    public Boolean getSaveProxyPassword() {
        if (this.needsProxy()) {
            return this.saveProxyPasswordButton.getSelection();
        }
        return false;
    }

    public Boolean getSaveHttpPassword() {
        if (this.needsHttpAuth()) {
            return this.saveHttpPasswordButton.getSelection();
        }
        return false;
    }

    protected void validateSettings() {
        final Validator validator = this.getValidator(this.createTaskRepository());
        if (validator == null) {
            return;
        }
        try {
            this.getWizard().getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Validating server settings", -1);
                    try {
                        try {
                            validator.run(monitor);
                            if (validator.getStatus() == null) {
                                validator.setStatus(Status.OK_STATUS);
                            }
                        }
                        catch (CoreException e) {
                            validator.setStatus(e.getStatus());
                            monitor.done();
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Internal error validating repository", e.getCause()));
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.applyValidatorResult(validator);
        this.getWizard().getContainer().updateButtons();
    }

    protected void applyValidatorResult(Validator validator) {
        IStatus status = validator.getStatus();
        String message = status.getMessage();
        if (message == null || message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                if (status == Status.OK_STATUS) {
                    message = this.getUserName().length() > 0 ? "Authentication credentials are valid." : "Repository is valid.";
                }
                this.setMessage(message, 1);
                break;
            }
            case 1: {
                this.setMessage(message, 1);
                break;
            }
            case 2: {
                this.setMessage(message, 2);
                break;
            }
            default: {
                this.setMessage(message, 3);
            }
        }
        this.setErrorMessage(null);
    }

    protected abstract Validator getValidator(TaskRepository var1);

    private static class RepositoryStringFieldEditor
    extends StringFieldEditor {
        public RepositoryStringFieldEditor(String name, String labelText, int style, Composite parent) {
            super(name, labelText, style, parent);
        }

        public void refreshValidState() {
            try {
                super.refreshValidState();
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Problem refreshing password field", (Throwable)e));
            }
        }

        public Text getTextControl() {
            return super.getTextControl();
        }
    }

    public abstract class Validator {
        private IStatus status;

        public abstract void run(IProgressMonitor var1) throws CoreException;

        public IStatus getStatus() {
            return this.status;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }
    }
}

