/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.search.AbstractRepositoryQueryPage;

public abstract class AbstractEditQueryWizard
extends Wizard {
    private static final String TITLE = "Edit Repository Query";
    protected final TaskRepository repository;
    protected AbstractRepositoryQuery query;
    protected AbstractRepositoryQueryPage page;

    public AbstractEditQueryWizard(TaskRepository repository, AbstractRepositoryQuery query) {
        this.repository = repository;
        this.query = query;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TITLE);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public boolean performFinish() {
        AbstractRepositoryQuery queryToRun;
        if (this.query != null) {
            TasksUiPlugin.getTaskListManager().getTaskList().deleteQuery(this.query);
        }
        AbstractRepositoryQuery abstractRepositoryQuery = queryToRun = this.page != null ? this.page.getQuery() : this.query;
        if (queryToRun != null) {
            TasksUiPlugin.getTaskListManager().getTaskList().addQuery(queryToRun);
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
            if (connector != null) {
                TasksUiPlugin.getSynchronizationManager().synchronize(connector, queryToRun, null, true);
            }
        }
        return true;
    }

    public String getQuerySummary() {
        if (this.query != null) {
            return this.query.getSummary();
        }
        return null;
    }
}

