/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorInputFactory;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class TaskEditorInput
implements IEditorInput,
IPersistableElement {
    private static final int MAX_LABEL_LENGTH = 60;
    private AbstractTask task;
    private String summary;
    private boolean newTask = false;

    public TaskEditorInput(AbstractTask task, boolean newTask) {
        this.newTask = newTask;
        this.task = task;
        this.summary = this.truncateDescription(task.getSummary());
    }

    private String truncateDescription(String description) {
        if (description == null || description.length() <= 60) {
            return description;
        }
        return String.valueOf(description.substring(0, 60)) + "...";
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.getLabel();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.summary;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IEditorInput.class) {
            return this;
        }
        return null;
    }

    public AbstractTask getTask() {
        return this.task;
    }

    public String getLabel() {
        if (this.task != null) {
            AbstractTask repositoryTask = this.task;
            String idLabel = repositoryTask.getTaskKey();
            this.summary = "";
            if (idLabel != null) {
                this.summary = String.valueOf(this.summary) + idLabel + ": ";
            }
            this.summary = String.valueOf(this.summary) + this.truncateDescription(this.task.getSummary());
        } else if (this.task != null) {
            this.summary = this.truncateDescription(this.task.getSummary());
        }
        return this.summary;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.task == null ? 0 : this.task.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskEditorInput other = (TaskEditorInput)obj;
        return !(this.task == null ? other.task != null : !this.task.equals((Object)other.task));
    }

    public boolean isNewTask() {
        return this.newTask;
    }

    public String getFactoryId() {
        return "org.eclipse.mylyn.tasks.ui.elementFactories.task.editor";
    }

    public void saveState(IMemento memento) {
        TaskEditorInputFactory.saveState(memento, this);
    }
}

