/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import java.io.File;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Control;

class RepositoryTaskEditorDropListener
implements DropTargetListener {
    private final AbstractRepositoryTaskEditor AbstractTaskEditor;
    private final FileTransfer fileTransfer;
    private final TextTransfer textTransfer;
    private final Control control;

    public RepositoryTaskEditorDropListener(AbstractRepositoryTaskEditor AbstractTaskEditor, FileTransfer fileTransfer, TextTransfer textTransfer, Control control) {
        this.AbstractTaskEditor = AbstractTaskEditor;
        this.fileTransfer = fileTransfer;
        this.textTransfer = textTransfer;
        this.control = control;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
        int i = 0;
        while (i < event.dataTypes.length) {
            if (this.fileTransfer.isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                if (event.detail == 1) break;
                event.detail = 0;
                break;
            }
            ++i;
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 9;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = event.detail == 16 || (event.operations & 1) != 0 ? 1 : 0;
        if (this.fileTransfer.isSupportedType(event.currentDataType) && event.detail != 1) {
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        String[] files;
        NewAttachmentWizard naw;
        AbstractTask task;
        if (this.textTransfer.isSupportedType(event.currentDataType)) {
            String text = (String)event.data;
            task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(this.AbstractTaskEditor.repository.getUrl(), this.AbstractTaskEditor.taskData.getId());
            if (task == null) {
                return;
            }
            this.AbstractTaskEditor.setGlobalBusy(true);
            naw = new NewAttachmentWizard(this.AbstractTaskEditor.repository, task, text);
            this.openDialog(naw, null);
        }
        if (this.fileTransfer.isSupportedType(event.currentDataType) && (files = (String[])event.data).length > 0) {
            task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(this.AbstractTaskEditor.repository.getUrl(), this.AbstractTaskEditor.taskData.getId());
            if (task == null) {
                return;
            }
            naw = new NewAttachmentWizard(this.AbstractTaskEditor.repository, task, new File(files[0]));
            String error = null;
            if (files.length > 1) {
                error = "Note that only the first file dragged will be attached.";
            }
            this.openDialog(naw, error);
        }
    }

    private void openDialog(NewAttachmentWizard naw, String message) {
        int result;
        this.AbstractTaskEditor.setGlobalBusy(true);
        NewAttachmentWizardDialog dialog = new NewAttachmentWizardDialog(this.control.getShell(), (IWizard)naw, true);
        naw.setDialog(dialog);
        dialog.create();
        if (message != null) {
            dialog.setMessage(message, 2);
        }
        if ((result = dialog.open()) != 0) {
            this.AbstractTaskEditor.setGlobalBusy(false);
        }
    }
}

