/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskListSaveManager;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskListWriter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener2;
import org.eclipse.mylyn.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.tasks.core.ITaskTimingListener;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListManager
implements IPropertyChangeListener {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long ROLLOVER_DELAY = 1800000L;
    public static final String ARCHIVE_CATEGORY_DESCRIPTION = "Archive";
    @Deprecated
    public static final String[] ESTIMATE_TIMES = new String[]{"0 Hours", "1 Hours", "2 Hours", "3 Hours", "4 Hours", "5 Hours", "6 Hours", "7 Hours", "8 Hours", "9 Hours", "10 Hours"};
    private List<ITaskActivityListener> activityListeners = new ArrayList<ITaskActivityListener>();
    private TaskListWriter taskListWriter;
    private File taskListFile;
    private TaskListSaveManager taskListSaveManager;
    private final TaskList taskList = new TaskList();
    private TaskActivationHistory taskActivityHistory = new TaskActivationHistory();
    private boolean taskListInitialized = false;
    private Timer timer;
    public Date startTime = new Date();
    private final ITaskListChangeListener CHANGE_LISTENER = new ITaskListChangeListener(){

        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                if (!(taskContainerDelta.getContainer() instanceof AbstractTask)) continue;
                switch (taskContainerDelta.getKind()) {
                    case REMOVED: {
                        TaskListManager.this.resetAndRollOver();
                        return;
                    }
                }
            }
        }
    };

    public TaskListManager(TaskListWriter taskListWriter, File file) {
        this.taskListFile = file;
        this.taskListWriter = taskListWriter;
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new RolloverCheck(), 1800000L, 1800000L);
        this.taskList.addChangeListener(this.CHANGE_LISTENER);
    }

    public void init() {
    }

    public void dispose() {
    }

    public TaskList resetTaskList() {
        this.resetAndRollOver();
        this.taskList.reset();
        this.prepareOrphanContainers();
        this.taskListInitialized = true;
        return this.taskList;
    }

    private void prepareOrphanContainers() {
        for (TaskRepository repository : TasksUiPlugin.getRepositoryManager().getAllRepositories()) {
            if (repository.getConnectorKind().equals("local")) continue;
            this.taskList.addOrphanContainer(new UnmatchedTaskContainer(repository.getConnectorKind(), repository.getUrl()));
        }
    }

    public void refactorRepositoryUrl(String oldUrl, String newUrl) {
        if (oldUrl == null || newUrl == null || oldUrl.equals(newUrl)) {
            return;
        }
        List activeTasks = this.taskList.getActiveTasks();
        for (AbstractTask task : new ArrayList(activeTasks)) {
            this.deactivateTask(task);
        }
        this.refactorOfflineHandles(oldUrl, newUrl);
        this.taskList.refactorRepositoryUrl(oldUrl, newUrl);
        this.refactorMetaContextHandles(oldUrl, newUrl);
        File dataDir = new File(TasksUiPlugin.getDefault().getDataDirectory(), "contexts");
        if (dataDir.exists() && dataDir.isDirectory()) {
            File[] fileArray = dataDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                int dotIndex = file.getName().lastIndexOf(".xml");
                if (dotIndex != -1) {
                    try {
                        String storedUrl;
                        String storedHandle = URLDecoder.decode(file.getName().substring(0, dotIndex), "UTF-8");
                        int delimIndex = storedHandle.lastIndexOf("-");
                        if (delimIndex != -1 && oldUrl.equals(storedUrl = storedHandle.substring(0, delimIndex))) {
                            String id = RepositoryTaskHandleUtil.getTaskId((String)storedHandle);
                            String newHandle = RepositoryTaskHandleUtil.getHandle((String)newUrl, (String)id);
                            File newFile = ContextCorePlugin.getContextManager().getFileForContext(newHandle);
                            file.renameTo(newFile);
                        }
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not move context file: " + file.getName(), (Throwable)e));
                    }
                }
                ++n2;
            }
        }
        this.saveTaskList();
    }

    private void refactorMetaContextHandles(String oldRepositoryUrl, String newRepositoryUrl) {
        InteractionContext metaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        ContextCorePlugin.getContextManager().resetActivityHistory();
        InteractionContext newMetaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        for (InteractionEvent event : metaContext.getInteractionHistory()) {
            String taskId;
            String storedUrl;
            if (event.getStructureHandle() != null && (storedUrl = RepositoryTaskHandleUtil.getRepositoryUrl((String)event.getStructureHandle())) != null && oldRepositoryUrl.equals(storedUrl) && (taskId = RepositoryTaskHandleUtil.getTaskId((String)event.getStructureHandle())) != null) {
                String newHandle = RepositoryTaskHandleUtil.getHandle((String)newRepositoryUrl, (String)taskId);
                event = new InteractionEvent(event.getKind(), event.getStructureKind(), newHandle, event.getOriginId(), event.getNavigation(), event.getDelta(), event.getInterestContribution(), event.getDate(), event.getEndDate());
            }
            newMetaContext.parseEvent(event);
        }
        ContextCorePlugin.getContextManager().saveActivityContext();
        this.initActivityHistory();
    }

    private void refactorOfflineHandles(String oldRepositoryUrl, String newRepositoryUrl) {
        TaskDataManager taskDataManager = TasksUiPlugin.getTaskDataManager();
        for (AbstractTask task : this.taskList.getAllTasks()) {
            AbstractTask repositoryTask;
            if (task == null || !(repositoryTask = task).getRepositoryUrl().equals(oldRepositoryUrl)) continue;
            RepositoryTaskData newTaskData = taskDataManager.getNewTaskData(repositoryTask.getRepositoryUrl(), repositoryTask.getTaskId());
            RepositoryTaskData oldTaskData = taskDataManager.getOldTaskData(repositoryTask.getRepositoryUrl(), repositoryTask.getTaskId());
            Set edits = taskDataManager.getEdits(repositoryTask.getRepositoryUrl(), repositoryTask.getTaskId());
            taskDataManager.remove(repositoryTask.getRepositoryUrl(), repositoryTask.getTaskId());
            if (newTaskData != null) {
                newTaskData.setRepositoryURL(newRepositoryUrl);
                taskDataManager.setNewTaskData(newTaskData);
            }
            if (oldTaskData != null) {
                oldTaskData.setRepositoryURL(newRepositoryUrl);
                taskDataManager.setOldTaskData(oldTaskData);
            }
            if (edits.isEmpty()) continue;
            taskDataManager.saveEdits(newRepositoryUrl, repositoryTask.getTaskId(), edits);
        }
        TasksUiPlugin.getTaskDataManager().saveNow();
    }

    public boolean readExistingOrCreateNewList() {
        try {
            if (this.taskListFile.exists()) {
                this.prepareOrphanContainers();
                this.taskListWriter.readTaskList(this.taskList, this.taskListFile, TasksUiPlugin.getTaskDataManager());
            } else {
                this.resetTaskList();
            }
            this.taskListInitialized = true;
            this.resetAndRollOver();
            for (ITaskActivityListener listener : new ArrayList<ITaskActivityListener>(this.activityListeners)) {
                listener.taskListRead();
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not read task list, consider restoring via view menu", t));
            return false;
        }
        return true;
    }

    public void initActivityHistory() {
        this.resetAndRollOver();
        this.taskActivityHistory.loadPersistentHistory();
    }

    public synchronized void saveTaskList() {
        try {
            if (this.taskListInitialized && this.taskListSaveManager != null) {
                this.taskListSaveManager.saveTaskList(true, false);
            } else {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Task list save attempted before initialization"));
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not save task list", (Throwable)e));
        }
    }

    public TaskList getTaskList() {
        return this.taskList;
    }

    public void addActivityListener(ITaskActivityListener listener) {
        this.activityListeners.add(listener);
    }

    public void removeActivityListener(ITaskActivityListener listener) {
        this.activityListeners.remove(listener);
    }

    public void addTimingListener(ITaskTimingListener listener) {
        TasksUiPlugin.getTaskActivityManager().addTimingListener(listener);
    }

    public void removeTimingListener(ITaskTimingListener listener) {
        TasksUiPlugin.getTaskActivityManager().removeTimingListener(listener);
    }

    public void activateTask(AbstractTask task) {
        this.activateTask(task, true);
    }

    public void activateTask(AbstractTask task, boolean addToHistory) {
        this.deactivateAllTasks();
        for (ITaskActivityListener listener : new ArrayList<ITaskActivityListener>(this.activityListeners)) {
            try {
                if (!(listener instanceof ITaskActivityListener2)) continue;
                ((ITaskActivityListener2)listener).preTaskActivated(task);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Task activity listener failed: " + listener, t));
            }
        }
        try {
            this.taskList.setActive(task, true);
            if (addToHistory) {
                this.taskActivityHistory.addTask(task);
            }
            for (ITaskActivityListener listener : new ArrayList<ITaskActivityListener>(this.activityListeners)) {
                try {
                    listener.taskActivated(task);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Task activity listener failed: " + listener, t));
                }
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not activate task", t));
        }
    }

    public void deactivateAllTasks() {
        List activeTasks = this.taskList.getActiveTasks();
        for (AbstractTask task : activeTasks) {
            this.deactivateTask(task);
        }
    }

    public void deactivateTask(AbstractTask task) {
        if (task == null) {
            return;
        }
        if (task.isActive()) {
            for (ITaskActivityListener listener : new ArrayList<ITaskActivityListener>(this.activityListeners)) {
                try {
                    if (!(listener instanceof ITaskActivityListener2)) continue;
                    ((ITaskActivityListener2)listener).preTaskDeactivated(task);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Notification failed for: " + listener, t));
                }
            }
            this.taskList.setActive(task, false);
            for (ITaskActivityListener listener : new ArrayList<ITaskActivityListener>(this.activityListeners)) {
                try {
                    listener.taskDeactivated(task);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Notification failed for: " + listener, t));
                }
            }
        }
    }

    public void setTaskListFile(File file) {
        this.taskListFile = file;
    }

    public void copyDataDirContentsTo(String newDataDir) {
        this.taskListSaveManager.copyDataDirContentsTo(newDataDir);
    }

    public boolean isTaskListInitialized() {
        return this.taskListInitialized;
    }

    public TaskListWriter getTaskListWriter() {
        return this.taskListWriter;
    }

    public File getTaskListFile() {
        return this.taskListFile;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.planning.start.hour") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.planning.end.hour")) {
            TaskActivityManager.getInstance().setEndHour(TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour"));
        }
    }

    public void resetAndRollOver() {
        this.resetAndRollOver(new Date());
    }

    public void resetAndRollOver(Date startDate) {
        if (!TaskActivityManager.getInstance().isInitialized()) {
            TaskActivityManager.getInstance().init(TasksUiPlugin.getRepositoryManager(), this.taskList);
            TaskActivityManager.getInstance().setEndHour(TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour"));
        }
        this.startTime = startDate;
        if (this.isTaskListInitialized()) {
            TaskActivityManager.getInstance().reloadTimingData(startDate);
        }
        for (ITaskActivityListener listener : this.activityListeners) {
            listener.activityChanged(null);
        }
    }

    public TaskActivationHistory getTaskActivationHistory() {
        return this.taskActivityHistory;
    }

    public AbstractTask getTaskForElement(AbstractTaskContainer element, boolean force) {
        AbstractTask task = null;
        if (element instanceof AbstractTask) {
            task = (AbstractTask)element;
        }
        return task;
    }

    protected void setTaskListSaveManager(TaskListSaveManager taskListSaveManager) {
        this.taskListSaveManager = taskListSaveManager;
        this.taskList.addChangeListener((ITaskListChangeListener)taskListSaveManager);
    }

    public LocalTask createNewLocalTask(String summary) {
        if (summary == null) {
            summary = "New Task";
        }
        LocalTask newTask = new LocalTask("" + this.taskList.getNextLocalTaskId(), summary);
        newTask.setPriority(AbstractTask.PriorityLevel.P3.toString());
        TasksUiPlugin.getTaskActivityManager().scheduleNewTask((AbstractTask)newTask);
        Object selectedObject = null;
        TaskListView view = TaskListView.getFromActivePerspective();
        if (view != null) {
            selectedObject = ((IStructuredSelection)view.getViewer().getSelection()).getFirstElement();
        }
        if (selectedObject instanceof TaskCategory) {
            this.taskList.addTask((AbstractTask)newTask, (AbstractTaskContainer)((TaskCategory)selectedObject));
        } else if (selectedObject instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)selectedObject;
            AbstractTaskCategory container = TaskCategory.getParentTaskCategory((AbstractTask)task);
            if (container instanceof TaskCategory) {
                this.taskList.addTask((AbstractTask)newTask, (AbstractTaskContainer)container);
            } else if (view != null && view.getDrilledIntoCategory() instanceof TaskCategory) {
                this.taskList.addTask((AbstractTask)newTask, view.getDrilledIntoCategory());
            } else {
                this.taskList.addTask((AbstractTask)newTask, (AbstractTaskContainer)TasksUiPlugin.getTaskListManager().getTaskList().getDefaultCategory());
            }
        } else if (view != null && view.getDrilledIntoCategory() instanceof TaskCategory) {
            this.taskList.addTask((AbstractTask)newTask, view.getDrilledIntoCategory());
        } else {
            if (view != null && view.getDrilledIntoCategory() != null) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Mylyn Information", (String)"The new task has been added to the root of the list, since tasks can not be added to a query.");
            }
            this.taskList.addTask((AbstractTask)newTask, (AbstractTaskContainer)TasksUiPlugin.getTaskListManager().getTaskList().getDefaultCategory());
        }
        return newTask;
    }

    public List<AbstractRepositoryQuery> insertQueries(List<AbstractRepositoryQuery> queries) {
        ArrayList<AbstractRepositoryQuery> badQueries = new ArrayList<AbstractRepositoryQuery>();
        for (AbstractRepositoryQuery query : queries) {
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(query.getRepositoryKind(), query.getRepositoryUrl());
            if (repository == null) {
                badQueries.add(query);
                continue;
            }
            String handle = this.resolveIdentifiersConflict(query);
            query.setHandleIdentifier(handle);
            TasksUiPlugin.getTaskListManager().getTaskList().addQuery(query);
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
            if (connector == null) continue;
            TasksUiPlugin.getSynchronizationManager().synchronize(connector, query, null, true);
        }
        return badQueries;
    }

    public String resolveIdentifiersConflict(AbstractRepositoryQuery query) {
        String patternStr = "\\[(\\d+)\\]$";
        Pattern pattern = Pattern.compile(patternStr);
        Set existingQueries = this.getTaskList().getQueries();
        HashMap<String, AbstractRepositoryQuery> queryMap = new HashMap<String, AbstractRepositoryQuery>();
        for (AbstractRepositoryQuery existingQuery : existingQueries) {
            queryMap.put(existingQuery.getHandleIdentifier(), existingQuery);
        }
        String handle = query.getHandleIdentifier();
        while (queryMap.get(handle) != null) {
            Matcher matcher = pattern.matcher(handle);
            boolean matchFound = matcher.find();
            if (matchFound) {
                int index = Integer.parseInt(matcher.group(1));
                handle = matcher.replaceAll("[" + ++index + "]");
                continue;
            }
            handle = String.valueOf(handle) + "[1]";
        }
        return handle;
    }

    public Set<AbstractTask> getScheduledForThisWeek() {
        Calendar startWeek = TaskActivityUtil.getStartOfCurrentWeek();
        Calendar endWeek = TaskActivityUtil.getEndOfCurrentWeek();
        return TaskActivityManager.getInstance().getScheduledTasks(startWeek, endWeek);
    }

    public boolean isScheduledAfterThisWeek(AbstractTask task) {
        return TaskActivityManager.getInstance().isScheduledAfterThisWeek(task);
    }

    public boolean isScheduledForLater(AbstractTask task) {
        return TaskActivityManager.getInstance().isScheduledForFuture(task);
    }

    public boolean isScheduledForThisWeek(AbstractTask task) {
        return TaskActivityManager.getInstance().isScheduledForThisWeek(task);
    }

    public boolean isScheduledForToday(AbstractTask task) {
        return TaskActivityManager.getInstance().isScheduledForToday(task);
    }

    public boolean isOwnedByUser(AbstractTask task) {
        return TasksUiPlugin.getRepositoryManager().isOwnedByUser(task);
    }

    public void setScheduledFor(AbstractTask task, Date reminderDate) {
        TaskActivityManager.getInstance().setScheduledFor(task, reminderDate);
    }

    public void setDueDate(AbstractTask task, Date dueDate) {
        TaskActivityManager.getInstance().setDueDate(task, dueDate);
    }

    public boolean isOverdue(AbstractTask task) {
        return TaskActivityManager.getInstance().isOverdue(task);
    }

    public boolean isActiveThisWeek(AbstractTask task) {
        return TaskActivityManager.getInstance().isActiveThisWeek(task);
    }

    public boolean isCompletedToday(AbstractTask task) {
        return TaskActivityManager.getInstance().isCompletedToday(task);
    }

    @Deprecated
    public void parseFutureReminders() {
    }

    public long getElapsedTime(AbstractTask task) {
        return TasksUiPlugin.getTaskActivityManager().getElapsedTime(task);
    }

    public void snapToStartOfDay(Calendar cal) {
        TaskActivityUtil.snapStartOfDay((Calendar)cal);
    }

    public void snapToStartOfHour(Calendar cal) {
        TaskActivityUtil.snapStartOfHour((Calendar)cal);
    }

    public void snapToEndOfHour(Calendar cal) {
        TaskActivityUtil.snapEndOfHour((Calendar)cal);
    }

    public void snapToEndOfDay(Calendar cal) {
        TaskActivityUtil.snapEndOfDay((Calendar)cal);
    }

    public void snapToNextDay(Calendar cal) {
        TaskActivityUtil.snapNextDay((Calendar)cal);
    }

    public void snapToStartOfWeek(Calendar cal) {
        TaskActivityUtil.snapStartOfWorkWeek((Calendar)cal);
    }

    public void snapToEndOfWeek(Calendar cal) {
        TaskActivityUtil.snapEndOfWeek((Calendar)cal);
    }

    public Calendar setSecheduledIn(Calendar calendar, int days) {
        return TaskActivityUtil.snapForwardNumDays((Calendar)calendar, (int)days);
    }

    public Calendar setScheduledEndOfDay(Calendar calendar) {
        return TaskActivityUtil.snapEndOfWorkDay((Calendar)calendar);
    }

    public void setScheduledNextWeek(Calendar calendar) {
        TaskActivityUtil.snapNextWorkWeek((Calendar)calendar);
    }

    public List<ScheduledTaskContainer> getDateRanges() {
        return TasksUiPlugin.getTaskActivityManager().getDateRanges();
    }

    public List<ScheduledTaskContainer> getActivityWeekDays() {
        return TasksUiPlugin.getTaskActivityManager().getActivityWeekDays();
    }

    public boolean isWeekDay(ScheduledTaskContainer dateRangeTaskContainer) {
        return TasksUiPlugin.getTaskActivityManager().isWeekDay(dateRangeTaskContainer);
    }

    public ScheduledTaskContainer getActivityThisWeek() {
        return TasksUiPlugin.getTaskActivityManager().getActivityThisWeek();
    }

    public ScheduledTaskContainer getActivityPast() {
        return TasksUiPlugin.getTaskActivityManager().getActivityPast();
    }

    public ScheduledTaskContainer getActivityFuture() {
        return TasksUiPlugin.getTaskActivityManager().getActivityFuture();
    }

    public ScheduledTaskContainer getActivityNextWeek() {
        return TasksUiPlugin.getTaskActivityManager().getActivityNextWeek();
    }

    public ScheduledTaskContainer getActivityPrevious() {
        return TasksUiPlugin.getTaskActivityManager().getActivityPrevious();
    }

    public int getStartHour() {
        return TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour");
    }

    public static void scheduleNewTask(AbstractTask newTask) {
        newTask.setCreationDate(new Date());
        Calendar newTaskSchedule = Calendar.getInstance();
        int scheduledEndHour = TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour");
        if (newTaskSchedule.get(11) >= scheduledEndHour) {
            TasksUiPlugin.getTaskListManager().setSecheduledIn(newTaskSchedule, 1);
        } else {
            TasksUiPlugin.getTaskListManager().setScheduledEndOfDay(newTaskSchedule);
        }
        TasksUiPlugin.getTaskActivityManager().setScheduledFor(newTask, newTaskSchedule.getTime());
    }

    private class RolloverCheck
    extends TimerTask {
        private RolloverCheck() {
        }

        public void run() {
            if (!Platform.isRunning() || ContextCorePlugin.getDefault() == null) {
                return;
            }
            Calendar now = GregorianCalendar.getInstance();
            ScheduledTaskContainer thisWeek = TasksUiPlugin.getTaskActivityManager().getActivityThisWeek();
            if (!thisWeek.includes(now)) {
                TaskListManager.this.resetAndRollOver();
            }
        }
    }
}

