/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskFactory;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SynchronizeTaskJob
extends Job {
    private static final String LABEL_SYNCHRONIZING = "Synchronizing task ";
    private static final String LABEL_SYNCHRONIZE_TASK = "Task Synchronization";
    private final AbstractRepositoryConnector connector;
    private Set<AbstractTask> repositoryTasks;
    private boolean forced = false;
    private AbstractTaskDataHandler taskDataHandler;
    private Map<TaskRepository, Set<AbstractTask>> repToTasks;

    public SynchronizeTaskJob(AbstractRepositoryConnector connector, Set<AbstractTask> repositoryTasks) {
        super("Task Synchronization (" + repositoryTasks.size() + " tasks)");
        this.connector = connector;
        this.repositoryTasks = repositoryTasks;
        this.taskDataHandler = connector.getTaskDataHandler();
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    /*
     * Unable to fully structure code
     */
    public IStatus run(IProgressMonitor monitor) {
        try {
            this.repToTasks = new HashMap<TaskRepository, Set<AbstractTask>>();
            monitor.beginTask("Synchronizing task ", this.repositoryTasks.size());
            this.setProperty(IProgressConstants.ICON_PROPERTY, TasksUiImages.REPOSITORY_SYNCHRONIZE);
            for (AbstractTask repositoryTask : this.repositoryTasks) {
                if (monitor.isCanceled()) break;
                if (this.taskDataHandler != null && this.taskDataHandler.canGetMultiTaskData()) {
                    repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryTask.getConnectorKind(), repositoryTask.getRepositoryUrl());
                    if (repository == null) {
                        repositoryTask.setSynchronizationStatus((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", 0, "Associated repository could not be found. Ensure proper repository configuration of " + repositoryTask.getRepositoryUrl() + " in " + "Task Repositories" + ".", null));
                        continue;
                    }
                    tasks = this.repToTasks.get(repository);
                    if (tasks == null) {
                        tasks = new HashSet<AbstractTask>();
                        this.repToTasks.put(repository, tasks);
                    }
                    repositoryTask.setSynchronizationStatus(null);
                    tasks.add(repositoryTask);
                    repositoryTask.setSynchronizing(true);
                    TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(repositoryTask, false);
                    continue;
                }
                this.synchronizeTask(monitor, repositoryTask);
            }
            if (monitor.isCanceled()) {
                for (AbstractTask repositoryTask : this.repositoryTasks) {
                    repositoryTask.setSynchronizing(false);
                    TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(repositoryTask, false);
                }
                var9_8 = Status.CANCEL_STATUS;
                return var9_8;
            }
            try {
                for (TaskRepository repository : this.repToTasks.keySet()) {
                    tasksToSynch = this.repToTasks.get(repository);
                    try {
                        this.synchronizeTasks((IProgressMonitor)new SubProgressMonitor(monitor, tasksToSynch.size()), repository, tasksToSynch);
                        continue;
                    }
                    catch (CoreException e) {
                        ** for (task : tasksToSynch)
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.updateStatus(repository, task, e.getStatus());
                        continue;
                    }
lbl42:
                    // 1 sources

                    if (!this.forced) continue;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            StatusHandler.displayStatus((String)"Task Synchronization Failed", (IStatus)e.getStatus());
                        }
                    });
                }
            }
            catch (OperationCanceledException v0) {
                var9_9 = Status.CANCEL_STATUS;
                return var9_9;
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Synchronization failed", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void synchronizeTask(IProgressMonitor monitor, AbstractTask task) {
        block7: {
            monitor.subTask(task.getSummary());
            task.setSynchronizationStatus(null);
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
            try {
                if (repository == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", 0, "Associated repository could not be found. Ensure proper repository configuration of " + task.getRepositoryUrl() + " in " + "Task Repositories" + ".", null));
                }
                TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(task, false);
                if (this.taskDataHandler != null) {
                    String taskId = task.getTaskId();
                    RepositoryTaskData downloadedTaskData = this.taskDataHandler.getTaskData(repository, taskId, monitor);
                    if (downloadedTaskData != null) {
                        this.updateTask(monitor, repository, task, downloadedTaskData);
                    } else {
                        this.updateFromRepository(repository, task, monitor);
                    }
                } else {
                    this.updateFromRepository(repository, task, monitor);
                }
            }
            catch (CoreException e) {
                this.updateStatus(repository, task, e.getStatus());
                if (!this.forced) break block7;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        StatusHandler.displayStatus((String)"Task Synchronization Failed", (IStatus)e.getStatus());
                    }
                });
            }
        }
        monitor.worked(1);
    }

    private void updateStatus(TaskRepository repository, AbstractTask task, IStatus status) {
        if (!this.forced && repository != null && repository.isOffline()) {
            task.setSynchronizing(false);
        } else {
            task.setSynchronizationStatus(status);
        }
    }

    private void synchronizeTasks(IProgressMonitor monitor, TaskRepository repository, Set<AbstractTask> tasks) throws CoreException {
        monitor.subTask("Synchronizing tasks from: " + repository.getRepositoryLabel());
        HashSet<String> taskIds = new HashSet<String>();
        HashMap<String, AbstractTask> idToTask = new HashMap<String, AbstractTask>();
        for (AbstractTask task : tasks) {
            taskIds.add(task.getTaskId());
            idToTask.put(task.getTaskId(), task);
        }
        Set newTaskData = this.taskDataHandler.getMultiTaskData(repository, taskIds, (IProgressMonitor)new SubProgressMonitor(monitor, tasks.size()));
        if (newTaskData != null && newTaskData.size() > 0) {
            for (RepositoryTaskData taskData : newTaskData) {
                block7: {
                    AbstractTask task;
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException("Synchronization cancelled by user");
                    }
                    if (taskData == null || (task = (AbstractTask)idToTask.remove(taskData.getId())) == null) continue;
                    try {
                        this.updateTask((IProgressMonitor)new SubProgressMonitor(monitor, 1), repository, task, taskData);
                    }
                    catch (CoreException e) {
                        this.updateStatus(repository, task, e.getStatus());
                        if (!this.forced) break block7;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                StatusHandler.displayStatus((String)"Task Synchronization Failed", (IStatus)e.getStatus());
                            }
                        });
                    }
                }
                monitor.worked(1);
            }
        }
        if (newTaskData != null) {
            newTaskData.size();
            tasks.size();
        }
    }

    private void updateFromRepository(TaskRepository repository, AbstractTask task, IProgressMonitor monitor) throws CoreException {
        this.connector.updateTaskFromRepository(repository, task, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        task.setStale(false);
        task.setSynchronizing(false);
        if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING || task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT) {
            TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(task, true);
        } else {
            TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(task, false);
        }
    }

    private void updateTask(IProgressMonitor monitor, TaskRepository repository, AbstractTask repositoryTask, RepositoryTaskData downloadedTaskData) throws CoreException {
        if (downloadedTaskData == null) {
            return;
        }
        Date oldDueDate = repositoryTask.getDueDate();
        TaskFactory factory = new TaskFactory(repository, true, this.forced);
        repositoryTask = factory.createTask(downloadedTaskData, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (oldDueDate == null && repositoryTask.getDueDate() != null || oldDueDate != null && repositoryTask.getDueDate() == null) {
            TasksUiPlugin.getTaskActivityManager().setDueDate(repositoryTask, repositoryTask.getDueDate());
        } else if (oldDueDate != null && repositoryTask.getDueDate() != null && oldDueDate.compareTo(repositoryTask.getDueDate()) != 0) {
            TasksUiPlugin.getTaskActivityManager().setDueDate(repositoryTask, repositoryTask.getDueDate());
        }
        repositoryTask.setSynchronizing(false);
        repositoryTask.setStale(false);
        if (repositoryTask.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING || repositoryTask.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT) {
            TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(repositoryTask, true);
        } else {
            TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(repositoryTask, false);
        }
    }
}

