/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.workingsets;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class TaskWorkingSetElementFactory
implements IElementFactory {
    static final String HANDLE_TASK = "handle.task";
    static final String HANDLE_PROJECT = "handle.task";

    public IAdaptable createElement(IMemento memento) {
        String projectHandle;
        String taskHandle = memento.getString("handle.task");
        if (taskHandle != null) {
            TaskList taskList = TasksUiPlugin.getTaskListManager().getTaskList();
            for (AbstractTaskContainer element : taskList.getRootElements()) {
                if (!element.getHandleIdentifier().equals(taskHandle)) continue;
                return element;
            }
        }
        if ((projectHandle = memento.getString("handle.task")) != null) {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectHandle);
                if (project != null) {
                    return project;
                }
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not not determine project for handle: " + projectHandle, t));
            }
        }
        return null;
    }
}

