/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewLocalTaskWizard
extends Wizard
implements INewWizard {
    private final TaskSelection taskSelection;

    public NewLocalTaskWizard(TaskSelection taskSelection) {
        this.taskSelection = taskSelection;
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        this.setNeedsProgressMonitor(true);
    }

    public NewLocalTaskWizard() {
        this(null);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setForcePreviousAndNextButtons(false);
    }

    public void addPages() {
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performFinish() {
        LocalTask task = TasksUiPlugin.getTaskListManager().createNewLocalTask(null);
        if (this.taskSelection != null) {
            task.setSummary(this.taskSelection.getTaskData().getSummary());
            task.setNotes(this.taskSelection.getTaskData().getDescription());
        }
        if (task != null) {
            TasksUiUtil.openEditor((AbstractTask)task, true);
            return true;
        }
        return false;
    }
}

