/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.File;
import org.eclipse.mylyn.internal.tasks.core.LocalAttachment;
import org.eclipse.mylyn.internal.tasks.ui.wizards.IImageCreator;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class ImageAttachment
extends LocalAttachment {
    private static final long serialVersionUID = 28264291629999181L;
    private IImageCreator imageCreator;
    private boolean dirty = true;

    public ImageAttachment(IImageCreator imageCreator) {
        this.imageCreator = imageCreator;
    }

    public void setContentType(String contentType) {
    }

    public String getContentType() {
        return "image/jpeg";
    }

    public String getFilename() {
        return "screenshot.jpg";
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void ensureImageFileWasCreated() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        this.createContents();
    }

    private void createContents() {
        Image image = this.imageCreator.createImage();
        try {
            String path = TasksUiPlugin.getDefault().getDefaultDataDirectory();
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{image.getImageData()};
            String fileName = String.valueOf(path) + "/" + this.getFilename();
            loader.save(fileName, 4);
            this.setFile(new File(fileName));
            this.setFilePath(fileName);
        }
        finally {
            image.dispose();
        }
    }

    public void clearImageFile() {
        String path = TasksUiPlugin.getDefault().getDefaultDataDirectory();
        new File(String.valueOf(path) + "/" + this.getFilename()).delete();
    }
}

