/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.ContextUiUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.ContextRetrieveWizardPage;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class ContextRetrieveWizard
extends Wizard {
    public static final String TITLE = "Task Repository";
    public static final String WIZARD_TITLE = "Retrieve context";
    private final TaskRepository repository;
    private final AbstractTask task;
    private ContextRetrieveWizardPage wizardPage;

    public ContextRetrieveWizard(AbstractTask task) {
        this.repository = TasksUiPlugin.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        this.task = task;
        this.setWindowTitle(TITLE);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY_CONTEXT);
    }

    public void addPages() {
        this.wizardPage = new ContextRetrieveWizardPage(this.repository, this.task);
        this.addPage((IWizardPage)this.wizardPage);
        super.addPages();
    }

    public final boolean performFinish() {
        RepositoryAttachment attachment = this.wizardPage.getSelectedContext();
        return ContextUiUtil.downloadContext(this.task, attachment, (IRunnableContext)this.getContainer());
    }
}

