/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ContextAttachWizardPage
extends WizardPage {
    private static final String DESCRIPTION = "Attaches local context to repository task";
    private TaskRepository repository;
    private AbstractTask task;
    private Text commentText;
    private boolean complete = true;

    protected ContextAttachWizardPage(TaskRepository repository, AbstractTask task) {
        super("Attach context");
        this.repository = repository;
        this.task = task;
        this.setDescription(DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Text summary = new Text(composite, 0);
        summary.setText("Task: " + this.task.getSummary());
        summary.setEditable(false);
        Text repositoryText = new Text(composite, 0);
        repositoryText.setText("Repository: " + this.repository.getUrl());
        repositoryText.setEditable(false);
        new Label(composite, 0).setText("Comment: ");
        this.commentText = new Text(composite, 2626);
        this.commentText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.commentText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ContextAttachWizardPage.this.getWizard().getContainer().updateButtons();
            }

            public void keyReleased(KeyEvent e) {
                ContextAttachWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.setControl((Control)composite);
        if (this.task.getSynchronizationState() != AbstractTask.RepositoryTaskSyncState.SYNCHRONIZED) {
            this.setErrorMessage("Task must be synchronized before attaching context");
            this.complete = false;
            this.getWizard().getContainer().updateButtons();
        }
        this.commentText.setFocus();
    }

    public String getComment() {
        return this.commentText.getText();
    }

    public boolean isPageComplete() {
        return this.complete;
    }
}

