/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TaskListColorsAndFonts;
import org.eclipse.mylyn.internal.tasks.ui.TaskListHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.ActivateTaskDialogAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ActivateTaskHistoryDropDownAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenTaskListElementAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskDeactivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskWorkingSetAction;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractFilteredTree;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListToolTip;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.WorkweekProgressBar;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.search.internal.ui.SearchDialog;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.internal.ObjectActionContributorManager;

public class TaskListFilteredTree
extends AbstractFilteredTree {
    private static final String LABEL_ACTIVE_NONE = "Activate...  ";
    private static final String LABEL_SETS_EDIT = "Edit Task Working Sets...";
    private static final String LABEL_SETS_MULTIPLE = "<multiple>";
    public static final String LABEL_SEARCH = "Search repository for key or summary...";
    private TaskListHyperlink workingSetLink;
    private TaskListHyperlink activeTaskLink;
    private WorkweekProgressBar taskProgressBar;
    private int totalTasks;
    private int completeTime;
    private int completeTasks;
    private int incompleteTime;
    private IWorkingSet currentWorkingSet;
    private MenuManager activeTaskMenuManager = null;
    private Menu activeTaskMenu = null;
    private CopyTaskDetailsAction copyTaskDetailsAction = new CopyTaskDetailsAction();
    private TaskListToolTip taskListToolTip;
    private ITaskListChangeListener changeListener;

    public TaskListFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter);
        this.hookContextMenu();
    }

    public void dispose() {
        if (this.changeListener != null) {
            TasksUiPlugin.getTaskListManager().getTaskList().removeChangeListener(this.changeListener);
        }
        super.dispose();
        this.taskListToolTip.dispose();
    }

    private void hookContextMenu() {
        this.activeTaskMenuManager = new MenuManager("#PopupMenu");
        this.activeTaskMenuManager.setRemoveAllWhenShown(true);
        this.activeTaskMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskListFilteredTree.this.fillContextMenu(manager, TasksUiPlugin.getTaskListManager().getTaskList().getActiveTask());
            }
        });
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        Composite container = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 0;
        gridData.horizontalIndent = 0;
        container.setLayoutData((Object)gridData);
        container.setLayout((Layout)new TreeColumnLayout());
        return super.doCreateTreeViewer(container, style);
    }

    protected Composite createProgressComposite(Composite container) {
        Composite progressComposite = new Composite(container, 0);
        GridLayout progressLayout = new GridLayout(1, false);
        progressLayout.marginWidth = 4;
        progressLayout.marginHeight = 0;
        progressLayout.marginBottom = 0;
        progressLayout.horizontalSpacing = 0;
        progressLayout.verticalSpacing = 0;
        progressComposite.setLayout((Layout)progressLayout);
        progressComposite.setLayoutData((Object)new GridData(4, -1, true, false, 4, 1));
        this.taskProgressBar = new WorkweekProgressBar(progressComposite);
        this.taskProgressBar.setLayoutData(new GridData(4, 4, true, true));
        this.updateTaskProgressBar();
        TasksUiPlugin.getTaskListManager().getTaskList().addChangeListener(new ITaskListChangeListener(){

            public void containersChanged(Set<TaskContainerDelta> containers) {
                for (TaskContainerDelta taskContainerDelta : containers) {
                    if (!(taskContainerDelta.getContainer() instanceof AbstractTask)) continue;
                    TaskListFilteredTree.this.updateTaskProgressBar();
                    break;
                }
            }
        });
        TasksUiPlugin.getTaskListManager().addActivityListener(new ITaskActivityListener(){

            public void activityChanged(ScheduledTaskContainer week) {
                TaskListFilteredTree.this.updateTaskProgressBar();
            }

            public void taskActivated(AbstractTask task) {
            }

            public void taskDeactivated(AbstractTask task) {
            }

            public void taskListRead() {
            }
        });
        return progressComposite;
    }

    protected Composite createSearchComposite(Composite container) {
        Composite searchComposite = new Composite(container, 0);
        GridLayout searchLayout = new GridLayout(1, false);
        searchLayout.marginWidth = 8;
        searchLayout.marginHeight = 0;
        searchLayout.marginBottom = 0;
        searchLayout.horizontalSpacing = 0;
        searchLayout.verticalSpacing = 0;
        searchComposite.setLayout((Layout)searchLayout);
        searchComposite.setLayoutData((Object)new GridData(4, -1, true, false, 4, 1));
        final TaskListHyperlink searchLink = new TaskListHyperlink(searchComposite, 16384);
        searchLink.setText(LABEL_SEARCH);
        searchLink.setForeground(TaskListColorsAndFonts.COLOR_HYPERLINK_WIDGET);
        searchLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                new SearchDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.eclipse.mylyn.tasks.ui.search.page").open();
            }

            public void linkEntered(HyperlinkEvent e) {
                searchLink.setUnderlined(true);
            }

            public void linkExited(HyperlinkEvent e) {
                searchLink.setUnderlined(false);
            }
        });
        return searchComposite;
    }

    private void updateTaskProgressBar() {
        if (this.taskProgressBar.isDisposed()) {
            return;
        }
        Set<AbstractTask> tasksThisWeek = TasksUiPlugin.getTaskListManager().getScheduledForThisWeek();
        this.totalTasks = tasksThisWeek.size();
        this.completeTime = 0;
        this.completeTasks = 0;
        this.incompleteTime = 0;
        for (AbstractTask task : tasksThisWeek) {
            if (task.isCompleted()) {
                ++this.completeTasks;
                if (task.getEstimateTimeHours() > 0) {
                    this.completeTime += task.getEstimateTimeHours();
                    continue;
                }
                ++this.completeTime;
                continue;
            }
            if (task.getEstimateTimeHours() > 0) {
                this.incompleteTime += task.getEstimateTimeHours();
                continue;
            }
            ++this.incompleteTime;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (PlatformUI.isWorkbenchRunning() && !TaskListFilteredTree.this.taskProgressBar.isDisposed()) {
                    TaskListFilteredTree.this.taskProgressBar.reset(TaskListFilteredTree.this.completeTime, TaskListFilteredTree.this.completeTime + TaskListFilteredTree.this.incompleteTime);
                    TaskListFilteredTree.this.taskProgressBar.setToolTipText("Workweek Progress\n     Estimated hours: " + TaskListFilteredTree.this.completeTime + " of " + (TaskListFilteredTree.this.completeTime + TaskListFilteredTree.this.incompleteTime) + " estimated" + "\n     Scheduled tasks: " + TaskListFilteredTree.this.completeTasks + " of " + TaskListFilteredTree.this.totalTasks + " scheduled");
                }
            }
        });
    }

    protected Composite createActiveWorkingSetComposite(Composite container) {
        final ImageHyperlink workingSetButton = new ImageHyperlink(container, 0x800000);
        workingSetButton.setImage(TasksUiImages.getImage(TasksUiImages.TOOLBAR_ARROW_RIGHT));
        workingSetButton.setToolTipText("Select Working Set");
        this.workingSetLink = new TaskListHyperlink(container, 16384);
        this.workingSetLink.setText("All");
        this.workingSetLink.setUnderlined(false);
        this.workingSetLink.setForeground(TaskListColorsAndFonts.COLOR_HYPERLINK_WIDGET);
        final TaskWorkingSetAction workingSetAction = new TaskWorkingSetAction();
        workingSetButton.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                workingSetAction.getMenu((Control)workingSetButton).setVisible(true);
            }

            public void linkEntered(HyperlinkEvent e) {
                workingSetButton.setImage(TasksUiImages.getImage(TasksUiImages.TOOLBAR_ARROW_DOWN));
            }

            public void linkExited(HyperlinkEvent e) {
                workingSetButton.setImage(TasksUiImages.getImage(TasksUiImages.TOOLBAR_ARROW_RIGHT));
            }
        });
        this.workingSetLink.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                TaskListFilteredTree.this.workingSetLink.setUnderlined(true);
            }

            public void mouseExit(MouseEvent e) {
                TaskListFilteredTree.this.workingSetLink.setUnderlined(false);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.indicateActiveTaskWorkingSet();
        this.workingSetLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TaskListFilteredTree.this.currentWorkingSet != null) {
                    workingSetAction.run(TaskListFilteredTree.this.currentWorkingSet);
                } else {
                    workingSetAction.run();
                }
            }
        });
        return this.workingSetLink;
    }

    protected Composite createActiveTaskComposite(final Composite container) {
        final ImageHyperlink activeTaskButton = new ImageHyperlink(container, 16384);
        activeTaskButton.setImage(TasksUiImages.getImage(TasksUiImages.TOOLBAR_ARROW_RIGHT));
        activeTaskButton.setToolTipText("Select Active Task");
        this.activeTaskLink = new TaskListHyperlink(container, 16384);
        this.changeListener = new ITaskListChangeListener(){

            public void containersChanged(Set<TaskContainerDelta> containers) {
                for (TaskContainerDelta taskContainerDelta : containers) {
                    if (!(taskContainerDelta.getContainer() instanceof AbstractTask)) continue;
                    final AbstractTask changedTask = (AbstractTask)taskContainerDelta.getContainer();
                    if (Platform.isRunning() && PlatformUI.getWorkbench() != null && Display.getCurrent() == null) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (changedTask.isActive()) {
                                    TaskListFilteredTree.this.indicateActiveTask(changedTask);
                                }
                            }
                        });
                        continue;
                    }
                    if (Display.getCurrent() == null || !changedTask.isActive()) continue;
                    TaskListFilteredTree.this.indicateActiveTask(changedTask);
                }
            }
        };
        TasksUiPlugin.getTaskListManager().getTaskList().addChangeListener(this.changeListener);
        this.activeTaskLink.setText(LABEL_ACTIVE_NONE);
        this.activeTaskLink.setForeground(TaskListColorsAndFonts.COLOR_HYPERLINK_WIDGET);
        this.activeTaskLink.setToolTipText("");
        this.taskListToolTip = new TaskListToolTip((Control)this.activeTaskLink);
        AbstractTask activeTask = TasksUiPlugin.getTaskListManager().getTaskList().getActiveTask();
        if (activeTask != null) {
            this.indicateActiveTask(activeTask);
        }
        final ActivateTaskHistoryDropDownAction action = new ActivateTaskHistoryDropDownAction(TasksUiPlugin.getTaskListManager().getTaskActivationHistory(), true);
        activeTaskButton.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                action.getMenu((Control)activeTaskButton).setVisible(true);
            }

            public void linkEntered(HyperlinkEvent e) {
                activeTaskButton.setImage(TasksUiImages.getImage(TasksUiImages.TOOLBAR_ARROW_DOWN));
            }

            public void linkExited(HyperlinkEvent e) {
                activeTaskButton.setImage(TasksUiImages.getImage(TasksUiImages.TOOLBAR_ARROW_RIGHT));
            }
        });
        this.activeTaskLink.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                if (TaskListFilteredTree.this.activeTaskMenu != null) {
                    TaskListFilteredTree.this.activeTaskMenu.dispose();
                }
                TaskListFilteredTree.this.activeTaskMenu = TaskListFilteredTree.this.activeTaskMenuManager.createContextMenu((Control)container);
                TaskListFilteredTree.this.activeTaskMenu.setVisible(true);
            }
        });
        this.activeTaskLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    AbstractTask activeTask = TasksUiPlugin.getTaskListManager().getTaskList().getActiveTask();
                    if (activeTask == null) {
                        ActivateTaskDialogAction activateAction = new ActivateTaskDialogAction();
                        activateAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        activateAction.run(null);
                    } else {
                        TasksUiUtil.refreshAndOpenTaskListElement((AbstractTaskContainer)activeTask);
                    }
                }
            }
        });
        return this.activeTaskLink;
    }

    protected void textChanged() {
        super.textChanged();
        if (this.getFilterString() != null && !this.getFilterString().trim().equals("")) {
            this.setShowSearch(true);
        } else {
            this.setShowSearch(false);
        }
    }

    public void indicateActiveTaskWorkingSet() {
        Set<IWorkingSet> activeSets = TaskListView.getActiveWorkingSets();
        if (this.filterComposite.isDisposed() || activeSets == null) {
            return;
        }
        if (activeSets.size() == 0) {
            this.workingSetLink.setText("All");
            this.workingSetLink.setToolTipText(LABEL_SETS_EDIT);
            this.currentWorkingSet = null;
        } else if (activeSets.size() > 1) {
            this.workingSetLink.setText(LABEL_SETS_MULTIPLE);
            this.workingSetLink.setToolTipText(LABEL_SETS_EDIT);
            this.currentWorkingSet = null;
        } else {
            Object[] array = activeSets.toArray();
            IWorkingSet workingSet = (IWorkingSet)array[0];
            this.workingSetLink.setText(workingSet.getLabel());
            this.workingSetLink.setToolTipText(LABEL_SETS_EDIT);
            this.currentWorkingSet = workingSet;
        }
        this.filterComposite.layout();
    }

    public void indicateActiveTask(AbstractTask task) {
        if (Display.getCurrent() != null) {
            if (this.filterComposite.isDisposed()) {
                return;
            }
            this.activeTaskLink.setTask(task);
            this.filterComposite.layout();
        }
    }

    public String getActiveTaskLabelText() {
        return this.activeTaskLink.getText();
    }

    public void indicateNoActiveTask() {
        if (this.filterComposite.isDisposed()) {
            return;
        }
        this.activeTaskLink.setTask(null);
        this.activeTaskLink.setText(LABEL_ACTIVE_NONE);
        this.activeTaskLink.setToolTipText("");
        this.filterComposite.layout();
    }

    public void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    private void fillContextMenu(IMenuManager manager, final AbstractTask activeTask) {
        if (activeTask != null) {
            StructuredSelection selection = new StructuredSelection((Object)activeTask);
            this.copyTaskDetailsAction.selectionChanged((IStructuredSelection)selection);
            manager.add((IAction)new OpenTaskListElementAction(null){

                public void run() {
                    TasksUiUtil.refreshAndOpenTaskListElement((AbstractTaskContainer)activeTask);
                }
            });
            if (activeTask.isActive()) {
                manager.add((IAction)new TaskDeactivateAction(){

                    public void run() {
                        super.run(activeTask);
                    }
                });
            } else {
                manager.add((IAction)new TaskActivateAction(){

                    public void run() {
                        super.run(activeTask);
                    }
                });
            }
            manager.add((IContributionItem)new Separator());
            for (String menuPath : TasksUiPlugin.getDefault().getDynamicMenuMap().keySet()) {
                for (IDynamicSubMenuContributor contributor : TasksUiPlugin.getDefault().getDynamicMenuMap().get(menuPath)) {
                    if (!"tasks".equals(menuPath)) continue;
                    ArrayList<AbstractTaskContainer> selectedElements = new ArrayList<AbstractTaskContainer>();
                    selectedElements.add((AbstractTaskContainer)activeTask);
                    MenuManager subMenuManager = contributor.getSubMenuManager(selectedElements);
                    if (subMenuManager == null) continue;
                    manager.add((IContributionItem)subMenuManager);
                }
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.copyTaskDetailsAction);
            manager.add((IContributionItem)new Separator());
            ObjectActionContributorManager.getManager().contributeObjectActions(null, manager, new ISelectionProvider(){

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    return new StructuredSelection((Object)activeTask);
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection selection) {
                }
            });
        }
    }
}

