/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractTaskRepositoryAction;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class ResetRepositoryConfigurationAction
extends AbstractTaskRepositoryAction {
    private static final String ID = "org.eclipse.mylyn.tasklist.repositories.reset";

    public ResetRepositoryConfigurationAction() {
        super("Update Attributes");
        this.setId(ID);
        this.setEnabled(false);
    }

    public void run() {
        try {
            IStructuredSelection selection = this.getStructuredSelection();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                AbstractRepositoryConnector connector;
                final TaskRepository repository = this.getTaskRepository(iter.next());
                if (repository == null || (connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind())) == null) continue;
                final String jobName = "Updating attributes for: " + repository.getUrl();
                Job updateJob = new Job(jobName){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask(jobName, -1);
                        ResetRepositoryConfigurationAction.this.performUpdate(repository, connector, monitor);
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                updateJob.schedule();
            }
        }
        catch (Exception e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e));
        }
    }

    public void performUpdate(TaskRepository repository, AbstractRepositoryConnector connector, IProgressMonitor monitor) {
        try {
            connector.updateAttributes(repository, monitor);
        }
        catch (CoreException ce) {
            StatusHandler.displayStatus((String)"Error updating attributes", (IStatus)ce.getStatus());
        }
    }
}

