/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskListWriter;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListPresentation;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTaskListFactory;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.ui.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractTaskRepositoryLinkProvider;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksUiExtensionReader {
    public static final String EXTENSION_REPOSITORIES = "org.eclipse.mylyn.tasks.ui.repositories";
    public static final String EXTENSION_REPOSITORY_LINKS_PROVIDERS = "org.eclipse.mylyn.tasks.ui.projectLinkProviders";
    public static final String EXTENSION_TEMPLATES = "org.eclipse.mylyn.tasks.core.templates";
    public static final String EXTENSION_TMPL_REPOSITORY = "repository";
    public static final String ELMNT_TMPL_LABEL = "label";
    public static final String ELMNT_TMPL_URLREPOSITORY = "urlRepository";
    public static final String ELMNT_TMPL_REPOSITORYKIND = "repositoryKind";
    public static final String ELMNT_TMPL_CHARACTERENCODING = "characterEncoding";
    public static final String ELMNT_TMPL_ANONYMOUS = "anonymous";
    public static final String ELMNT_TMPL_VERSION = "version";
    public static final String ELMNT_TMPL_URLNEWTASK = "urlNewTask";
    public static final String ELMNT_TMPL_URLTASK = "urlTask";
    public static final String ELMNT_TMPL_URLTASKQUERY = "urlTaskQuery";
    public static final String ELMNT_TMPL_NEWACCOUNTURL = "urlNewAccount";
    public static final String ELMNT_TMPL_ADDAUTO = "addAutomatically";
    public static final String ELMNT_REPOSITORY_CONNECTOR = "connectorCore";
    public static final String ATTR_USER_MANAGED = "userManaged";
    public static final String ATTR_CUSTOM_NOTIFICATIONS = "customNotifications";
    public static final String ELMNT_REPOSITORY_LINK_PROVIDER = "linkProvider";
    public static final String ELMNT_REPOSITORY_UI = "connectorUi";
    public static final String ELMNT_EXTERNALIZER = "taskListFactory";
    public static final String ATTR_BRANDING_ICON = "brandingIcon";
    public static final String ATTR_OVERLAY_ICON = "overlayIcon";
    public static final String ELMNT_TYPE = "type";
    public static final String ELMNT_QUERY_PAGE = "queryPage";
    public static final String ELMNT_SETTINGS_PAGE = "settingsPage";
    public static final String EXTENSION_TASK_CONTRIBUTOR = "org.eclipse.mylyn.tasks.ui.actions";
    public static final String ATTR_ACTION_CONTRIBUTOR_CLASS = "taskHandlerClass";
    public static final String DYNAMIC_POPUP_ELEMENT = "dynamicPopupMenu";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_MENU_PATH = "menuPath";
    public static final String EXTENSION_EDITORS = "org.eclipse.mylyn.tasks.ui.editors";
    public static final String ELMNT_EDITOR_FACTORY = "editorFactory";
    public static final String ELMNT_HYPERLINK_LISTENER = "hyperlinkListener";
    public static final String ELMNT_HYPERLINK_DETECTOR = "hyperlinkDetector";
    public static final String EXTENSION_DUPLICATE_DETECTORS = "org.eclipse.mylyn.tasks.ui.duplicateDetectors";
    public static final String ELMNT_DUPLICATE_DETECTOR = "detector";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_KIND = "kind";
    private static final String EXTENSION_PRESENTATIONS = "org.eclipse.mylyn.tasks.ui.presentations";
    public static final String ELMNT_PRESENTATION = "presentation";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_PRIMARY = "primary";
    public static final String ATTR_ID = "id";
    private static boolean coreExtensionsRead = false;

    public static void initStartupExtensions(TaskListWriter delegatingExternalizer) {
        ArrayList<AbstractTaskListFactory> externalizers = new ArrayList<AbstractTaskListFactory>();
        if (!coreExtensionsRead) {
            int j;
            IConfigurationElement[] elements;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint repositoriesExtensionPoint = registry.getExtensionPoint(EXTENSION_REPOSITORIES);
            IExtension[] repositoryExtensions = repositoriesExtensionPoint.getExtensions();
            int i = 0;
            while (i < repositoryExtensions.length) {
                IConfigurationElement[] elements2 = repositoryExtensions[i].getConfigurationElements();
                int j2 = 0;
                while (j2 < elements2.length) {
                    if (elements2[j2].getName().equals(ELMNT_REPOSITORY_CONNECTOR)) {
                        TasksUiExtensionReader.readRepositoryConnectorCore(elements2[j2]);
                    } else if (elements2[j2].getName().equals(ELMNT_EXTERNALIZER)) {
                        TasksUiExtensionReader.readExternalizer(elements2[j2], externalizers);
                    }
                    ++j2;
                }
                ++i;
            }
            delegatingExternalizer.setDelegateExternalizers(externalizers);
            IExtensionPoint templatesExtensionPoint = registry.getExtensionPoint(EXTENSION_TEMPLATES);
            IExtension[] templateExtensions = templatesExtensionPoint.getExtensions();
            int i2 = 0;
            while (i2 < templateExtensions.length) {
                IConfigurationElement[] elements3 = templateExtensions[i2].getConfigurationElements();
                int j3 = 0;
                while (j3 < elements3.length) {
                    if (elements3[j3].getName().equals(EXTENSION_TMPL_REPOSITORY)) {
                        TasksUiExtensionReader.readRepositoryTemplate(elements3[j3]);
                    }
                    ++j3;
                }
                ++i2;
            }
            IExtensionPoint presentationsExtensionPoint = registry.getExtensionPoint(EXTENSION_PRESENTATIONS);
            IExtension[] presentations = presentationsExtensionPoint.getExtensions();
            int i3 = 0;
            while (i3 < presentations.length) {
                IConfigurationElement[] elements4 = presentations[i3].getConfigurationElements();
                int j4 = 0;
                while (j4 < elements4.length) {
                    TasksUiExtensionReader.readPresentation(elements4[j4]);
                    ++j4;
                }
                ++i3;
            }
            IExtensionPoint editorsExtensionPoint = registry.getExtensionPoint(EXTENSION_EDITORS);
            IExtension[] editors = editorsExtensionPoint.getExtensions();
            int i4 = 0;
            while (i4 < editors.length) {
                elements = editors[i4].getConfigurationElements();
                j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals(ELMNT_EDITOR_FACTORY)) {
                        TasksUiExtensionReader.readEditorFactory(elements[j]);
                    }
                    ++j;
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < editors.length) {
                elements = editors[i4].getConfigurationElements();
                j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals(ELMNT_HYPERLINK_DETECTOR)) {
                        TasksUiExtensionReader.readHyperlinkDetector(elements[j]);
                    }
                    ++j;
                }
                ++i4;
            }
            coreExtensionsRead = true;
        }
    }

    public static void initWorkbenchUiExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint repositoriesExtensionPoint = registry.getExtensionPoint(EXTENSION_REPOSITORIES);
        IExtension[] repositoryExtensions = repositoriesExtensionPoint.getExtensions();
        int i = 0;
        while (i < repositoryExtensions.length) {
            IConfigurationElement[] elements = repositoryExtensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals(ELMNT_REPOSITORY_UI)) {
                    TasksUiExtensionReader.readRepositoryConnectorUi(elements[j]);
                }
                ++j;
            }
            ++i;
        }
        IExtensionPoint linkProvidersExtensionPoint = registry.getExtensionPoint(EXTENSION_REPOSITORY_LINKS_PROVIDERS);
        IExtension[] linkProvidersExtensions = linkProvidersExtensionPoint.getExtensions();
        int i2 = 0;
        while (i2 < linkProvidersExtensions.length) {
            IConfigurationElement[] elements = linkProvidersExtensions[i2].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals(ELMNT_REPOSITORY_LINK_PROVIDER)) {
                    TasksUiExtensionReader.readLinkProvider(elements[j]);
                }
                ++j;
            }
            ++i2;
        }
        IExtensionPoint duplicateDetectorsExtensionPoint = registry.getExtensionPoint(EXTENSION_DUPLICATE_DETECTORS);
        IExtension[] dulicateDetectorsExtensions = duplicateDetectorsExtensionPoint.getExtensions();
        int i3 = 0;
        while (i3 < dulicateDetectorsExtensions.length) {
            IConfigurationElement[] elements = dulicateDetectorsExtensions[i3].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals(ELMNT_DUPLICATE_DETECTOR)) {
                    TasksUiExtensionReader.readDuplicateDetector(elements[j]);
                }
                ++j;
            }
            ++i3;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_TASK_CONTRIBUTOR);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i4 = 0;
        while (i4 < extensions.length) {
            IConfigurationElement[] elements = extensions[i4].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals(DYNAMIC_POPUP_ELEMENT)) {
                    TasksUiExtensionReader.readDynamicPopupContributor(elements[j]);
                }
                ++j;
            }
            ++i4;
        }
    }

    private static void readPresentation(IConfigurationElement element) {
        try {
            String name = element.getAttribute(ATTR_NAME);
            String iconPath = element.getAttribute(ATTR_ICON);
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)iconPath);
            AbstractTaskListPresentation presentation = (AbstractTaskListPresentation)element.createExecutableExtension(ATTR_CLASS);
            presentation.setImageDescriptor(imageDescriptor);
            presentation.setName(name);
            String primary = element.getAttribute(ATTR_PRIMARY);
            if (primary != null && primary.equals("true")) {
                presentation.setPrimary(true);
            }
            TaskListView.addPresentation(presentation);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load presentation extension", (Throwable)e));
        }
    }

    private static void readDuplicateDetector(IConfigurationElement element) {
        try {
            Object obj = element.createExecutableExtension(ATTR_CLASS);
            if (obj instanceof AbstractDuplicateDetector) {
                AbstractDuplicateDetector duplicateDetector = (AbstractDuplicateDetector)obj;
                duplicateDetector.setName(element.getAttribute(ATTR_NAME));
                duplicateDetector.setKind(element.getAttribute(ATTR_KIND));
                TasksUiPlugin.getDefault().addDuplicateDetector(duplicateDetector);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load duplicate detector " + obj.getClass().getCanonicalName()));
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load duplicate detector", (Throwable)e));
        }
    }

    private static void readLinkProvider(IConfigurationElement element) {
        try {
            Object repositoryLinkProvider = element.createExecutableExtension(ATTR_CLASS);
            if (repositoryLinkProvider instanceof AbstractTaskRepositoryLinkProvider) {
                TasksUiPlugin.getDefault().addRepositoryLinkProvider((AbstractTaskRepositoryLinkProvider)repositoryLinkProvider);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load repository link provider " + repositoryLinkProvider.getClass().getCanonicalName()));
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load repository link provider", (Throwable)e));
        }
    }

    private static void readHyperlinkDetector(IConfigurationElement element) {
        try {
            Object hyperlinkDetector = element.createExecutableExtension(ATTR_CLASS);
            if (hyperlinkDetector instanceof IHyperlinkDetector) {
                TasksUiPlugin.getDefault().addTaskHyperlinkDetector((IHyperlinkDetector)hyperlinkDetector);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load hyperlink detector " + hyperlinkDetector.getClass().getCanonicalName()));
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load hyperlink detector", (Throwable)e));
        }
    }

    private static void readEditorFactory(IConfigurationElement element) {
        try {
            Object editor = element.createExecutableExtension(ATTR_CLASS);
            if (editor instanceof AbstractTaskEditorFactory) {
                TasksUiPlugin.getDefault().addContextEditor((AbstractTaskEditorFactory)editor);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load editor " + editor.getClass().getCanonicalName() + " must implement " + AbstractTaskEditorFactory.class.getCanonicalName()));
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load editor", (Throwable)e));
        }
    }

    private static void readRepositoryConnectorCore(IConfigurationElement element) {
        try {
            String type = element.getAttribute(ELMNT_TYPE);
            Object connectorCore = element.createExecutableExtension(ATTR_CLASS);
            if (connectorCore instanceof AbstractRepositoryConnector && type != null) {
                AbstractRepositoryConnector repositoryConnector = (AbstractRepositoryConnector)connectorCore;
                TasksUiPlugin.getRepositoryManager().addRepositoryConnector(repositoryConnector);
                String userManagedString = element.getAttribute(ATTR_USER_MANAGED);
                if (userManagedString != null) {
                    boolean userManaged = Boolean.parseBoolean(userManagedString);
                    repositoryConnector.setUserManaged(userManaged);
                }
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load connector core " + connectorCore.getClass().getCanonicalName()));
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load connector core", (Throwable)e));
        }
    }

    private static void readRepositoryConnectorUi(IConfigurationElement element) {
        try {
            Object connectorUiObject = element.createExecutableExtension(ATTR_CLASS);
            if (connectorUiObject instanceof AbstractRepositoryConnectorUi) {
                ImageDescriptor descriptor;
                String overlayIconPath;
                ImageDescriptor descriptor2;
                String iconPath;
                AbstractRepositoryConnectorUi connectorUi = (AbstractRepositoryConnectorUi)connectorUiObject;
                TasksUiPlugin.getDefault().addRepositoryConnectorUi(connectorUi);
                String customNotificationsString = element.getAttribute(ATTR_CUSTOM_NOTIFICATIONS);
                if (customNotificationsString != null) {
                    boolean customNotifications = Boolean.parseBoolean(customNotificationsString);
                    connectorUi.setCustomNotificationHandling(customNotifications);
                }
                if ((iconPath = element.getAttribute(ATTR_BRANDING_ICON)) != null && (descriptor2 = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)iconPath)) != null) {
                    TasksUiPlugin.getDefault().addBrandingIcon(connectorUi.getConnectorKind(), TasksUiImages.getImage(descriptor2));
                }
                if ((overlayIconPath = element.getAttribute(ATTR_OVERLAY_ICON)) != null && (descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)overlayIconPath)) != null) {
                    TasksUiPlugin.getDefault().addOverlayIcon(connectorUi.getConnectorKind(), descriptor);
                }
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load connector ui " + connectorUiObject.getClass().getCanonicalName()));
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load connector ui", (Throwable)e));
        }
    }

    private static void readRepositoryTemplate(IConfigurationElement element) {
        boolean anonymous = false;
        boolean addAuto = false;
        String label = element.getAttribute(ELMNT_TMPL_LABEL);
        String serverUrl = element.getAttribute(ELMNT_TMPL_URLREPOSITORY);
        String repKind = element.getAttribute(ELMNT_TMPL_REPOSITORYKIND);
        String version = element.getAttribute(ELMNT_TMPL_VERSION);
        String newTaskUrl = element.getAttribute(ELMNT_TMPL_URLNEWTASK);
        String taskPrefix = element.getAttribute(ELMNT_TMPL_URLTASK);
        String taskQueryUrl = element.getAttribute(ELMNT_TMPL_URLTASKQUERY);
        String newAccountUrl = element.getAttribute(ELMNT_TMPL_NEWACCOUNTURL);
        String encoding = element.getAttribute(ELMNT_TMPL_CHARACTERENCODING);
        addAuto = Boolean.parseBoolean(element.getAttribute(ELMNT_TMPL_ADDAUTO));
        anonymous = Boolean.parseBoolean(element.getAttribute(ELMNT_TMPL_ANONYMOUS));
        if (serverUrl != null && label != null && repKind != null && TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repKind) != null) {
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repKind);
            RepositoryTemplate template = new RepositoryTemplate(label, serverUrl, encoding, version, newTaskUrl, taskPrefix, taskQueryUrl, newAccountUrl, anonymous, addAuto);
            connector.addTemplate(template);
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                String name = configElement.getAttribute(ATTR_NAME);
                String value = configElement.getAttribute("value");
                if (name != null && !name.equals("") && value != null) {
                    template.addAttribute(name, value);
                }
                ++n2;
            }
        } else {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load repository template extension " + element.getName()));
        }
    }

    private static void readDynamicPopupContributor(IConfigurationElement element) {
        try {
            Object dynamicPopupContributor = element.createExecutableExtension(ATTR_CLASS);
            String menuPath = element.getAttribute(ATTR_MENU_PATH);
            if (dynamicPopupContributor instanceof IDynamicSubMenuContributor) {
                TasksUiPlugin.getDefault().addDynamicPopupContributor(menuPath, (IDynamicSubMenuContributor)dynamicPopupContributor);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load dynamic popup menu: " + dynamicPopupContributor.getClass().getCanonicalName() + " must implement " + IDynamicSubMenuContributor.class.getCanonicalName()));
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load dynamic popup menu extension", (Throwable)e));
        }
    }

    private static void readExternalizer(IConfigurationElement element, List<AbstractTaskListFactory> externalizers) {
        try {
            Object externalizerObject = element.createExecutableExtension(ATTR_CLASS);
            if (externalizerObject instanceof AbstractTaskListFactory) {
                AbstractTaskListFactory externalizer = (AbstractTaskListFactory)externalizerObject;
                externalizers.add(externalizer);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load externalizer: " + externalizerObject.getClass().getCanonicalName() + " must implement " + AbstractTaskListFactory.class.getCanonicalName()));
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load task handler extension", (Throwable)e));
        }
    }
}

