/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.internal.tasks.ui.util.BackgroundSaveTimer;
import org.eclipse.mylyn.internal.tasks.ui.util.IBackgroundSaveListener;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.tasks.ui.TaskListManager;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListSaveManager
implements ITaskListChangeListener,
IBackgroundSaveListener {
    private static final int DEFAULT_SAVE_INTERVAL = 60000;
    private BackgroundSaveTimer saveTimer = new BackgroundSaveTimer(this);
    private TaskListSaverJob taskListSaverJob;
    private boolean initializationWarningDialogShow = false;

    public TaskListSaveManager() {
        this.saveTimer.setSaveIntervalMillis(60000);
        this.saveTimer.start();
        this.taskListSaverJob = new TaskListSaverJob();
        this.taskListSaverJob.schedule();
    }

    @Override
    public void saveRequested() {
        if (TasksUiPlugin.getDefault() != null && Platform.isRunning()) {
            try {
                this.taskListSaverJob.runRequested();
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not auto save task list", (Throwable)e));
            }
        }
    }

    public void saveTaskList(boolean saveContext, boolean async) {
        if (TasksUiPlugin.getDefault() != null && TasksUiPlugin.getDefault().isInitialized()) {
            TaskListManager taskListManager = TasksUiPlugin.getTaskListManager();
            if (async) {
                if (saveContext) {
                    for (AbstractTask task : taskListManager.getTaskList().getActiveTasks()) {
                        this.taskListSaverJob.addTaskContext(task);
                    }
                }
                this.taskListSaverJob.requestSave();
            } else {
                this.taskListSaverJob.waitSaveCompleted();
                InteractionContextManager contextManager = ContextCorePlugin.getContextManager();
                if (saveContext) {
                    for (AbstractTask task : new ArrayList(taskListManager.getTaskList().getActiveTasks())) {
                        contextManager.saveContext(task.getHandleIdentifier());
                    }
                }
                this.internalSaveTaskList();
            }
        } else if (PlatformUI.getWorkbench() != null && !PlatformUI.getWorkbench().isClosing()) {
            StatusHandler.fail((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Possible task list initialization failure, not saving list"));
            if (!this.initializationWarningDialogShow) {
                this.initializationWarningDialogShow = true;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null) {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Mylyn Information", (String)"If task list is blank, Mylyn Task List may have failed to initialize.\n\nFirst, try restarting to see if that corrects the problem.\n\nThen, check the Error Log view for messages, and the FAQ for solutions.\n\nhttp://eclipse.org/mylyn");
                        }
                    }
                });
            }
        }
    }

    private synchronized void internalSaveTaskList() {
        TaskListManager taskListManager = TasksUiPlugin.getTaskListManager();
        taskListManager.getTaskListWriter().writeTaskList(taskListManager.getTaskList(), taskListManager.getTaskListFile());
    }

    public void copyDataDirContentsTo(String targetFolderPath) {
        this.saveTaskList(true, false);
        File mainDataDir = new File(TasksUiPlugin.getDefault().getDataDirectory());
        File[] fileArray = mainDataDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File currFile = fileArray[n2];
            if (currFile.isFile()) {
                File destFile = new File(String.valueOf(targetFolderPath) + File.separator + currFile.getName());
                this.copy(currFile, destFile);
            } else if (currFile.isDirectory()) {
                File destDir = new File(String.valueOf(targetFolderPath) + File.separator + currFile.getName());
                if (!destDir.exists() && !destDir.mkdir()) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Unable to create destination context folder: " + destDir.getAbsolutePath()));
                } else {
                    File[] fileArray2 = currFile.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File file = fileArray2[n4];
                        File destFile = new File(destDir, file.getName());
                        if (destFile.exists()) {
                            destFile.delete();
                        }
                        this.copy(file, destFile);
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private boolean copy(File src, File dst) {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void taskActivated(AbstractTask task) {
    }

    public void tasksActivated(List<AbstractTask> tasks) {
    }

    public void taskDeactivated(AbstractTask task) {
        this.saveTaskList(true, true);
    }

    public void localInfoChanged(AbstractTask task) {
        this.saveTaskList(false, true);
    }

    public void repositoryInfoChanged(AbstractTask task) {
    }

    public void tasklistRead() {
    }

    public BackgroundSaveTimer getSaveTimer() {
        return this.saveTimer;
    }

    public void containersChanged(Set<TaskContainerDelta> containers) {
        this.saveTaskList(false, true);
    }

    public void synchronizationCompleted() {
    }

    private class TaskListSaverJob
    extends Job {
        private final Queue<AbstractTask> taskQueue;
        private volatile boolean saveRequested;
        private volatile boolean saveCompleted;

        TaskListSaverJob() {
            super("Task List Saver");
            this.taskQueue = new LinkedList<AbstractTask>();
            this.saveRequested = false;
            this.saveCompleted = true;
            this.setPriority(30);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (true) {
                if (this.saveRequested) {
                    this.saveRequested = false;
                    this.saveCompleted = false;
                    InteractionContextManager contextManager = ContextCorePlugin.getContextManager();
                    while (!this.taskQueue.isEmpty()) {
                        AbstractTask task = this.taskQueue.poll();
                        if (task == null) continue;
                        contextManager.saveContext(task.getHandleIdentifier());
                    }
                    TaskListSaveManager.this.internalSaveTaskList();
                }
                if (this.saveRequested) continue;
                TaskListSaverJob taskListSaverJob = this;
                synchronized (taskListSaverJob) {
                    this.saveCompleted = true;
                    ((Object)((Object)this)).notifyAll();
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        void addTaskContext(AbstractTask task) {
            this.taskQueue.add(task);
        }

        void requestSave() {
            this.saveRequested = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runRequested() {
            TaskListSaverJob taskListSaverJob = this;
            synchronized (taskListSaverJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitSaveCompleted() {
            while (!this.saveCompleted) {
                TaskListSaverJob taskListSaverJob = this;
                synchronized (taskListSaverJob) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

