/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.TaskTransfer;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDragSourceListener
extends DragSourceAdapter {
    static final String DELIM = ", ";
    private IStructuredSelection selection;
    private final ISelectionProvider selectionProvider;

    public TaskDragSourceListener(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.selectionProvider.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.selection = (IStructuredSelection)selection;
        } else {
            this.selection = null;
            event.doit = false;
        }
    }

    private List<File> createTaskFiles(IStructuredSelection selection) {
        File tempDir = new File(String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + File.separator + "temp");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        ArrayList<AbstractRepositoryQuery> queries = new ArrayList<AbstractRepositoryQuery>();
        ArrayList<AbstractTask> tasks = new ArrayList<AbstractTask>();
        for (Object element : selection) {
            if (element instanceof AbstractRepositoryQuery) {
                queries.add((AbstractRepositoryQuery)element);
                continue;
            }
            if (!(element instanceof AbstractTask)) continue;
            tasks.add((AbstractTask)element);
        }
        ArrayList<File> taskFiles = new ArrayList<File>(queries.size() + tasks.size());
        try {
            File file;
            String encodedName;
            for (AbstractRepositoryQuery query : queries) {
                encodedName = URLEncoder.encode(query.getHandleIdentifier(), "UTF-8");
                file = File.createTempFile(encodedName, ".xml.zip", tempDir);
                file.deleteOnExit();
                TasksUiPlugin.getTaskListManager().getTaskListWriter().writeQueries(Collections.singletonList(query), file);
                taskFiles.add(file);
            }
            for (AbstractTask task : tasks) {
                encodedName = URLEncoder.encode(task.getHandleIdentifier(), "UTF-8");
                file = File.createTempFile(encodedName, ".xml.zip", tempDir);
                file.deleteOnExit();
                TasksUiPlugin.getTaskListManager().getTaskListWriter().writeTask(task, file);
                taskFiles.add(file);
            }
            return taskFiles;
        }
        catch (IOException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Cannot create a temp query file for Drag&Drop", (Throwable)e));
            return null;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.selection == null || this.selection.isEmpty()) {
            return;
        }
        if (TaskTransfer.getInstance().isSupportedType(event.dataType)) {
            ArrayList<AbstractTask> tasks = new ArrayList<AbstractTask>();
            for (AbstractTaskContainer element : this.selection) {
                if (!(element instanceof AbstractTask)) continue;
                tasks.add((AbstractTask)element);
            }
            event.data = tasks.toArray(new AbstractTask[0]);
        } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
            List<File> files = this.createTaskFiles(this.selection);
            if (files != null && !files.isEmpty()) {
                String[] paths = new String[files.size()];
                int i = 0;
                for (File file : files) {
                    paths[i++] = file.getAbsolutePath();
                }
                event.data = paths;
            }
        } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            if (this.selection.getFirstElement() instanceof RepositoryTaskData) {
                RepositoryTaskData taskData = (RepositoryTaskData)this.selection.getFirstElement();
                AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(taskData.getRepositoryKind());
                event.data = connector != null ? connector.getTaskUrl(taskData.getRepositoryUrl(), taskData.getId()) : taskData.getSummary();
            } else {
                event.data = CopyTaskDetailsAction.getTextForTask(this.selection.getFirstElement());
            }
        }
    }
}

