/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.ui.util.IBackgroundSaveListener;
import org.eclipse.mylyn.monitor.core.ActivityTimerThread;
import org.eclipse.mylyn.monitor.core.IActivityTimerListener;
import org.eclipse.mylyn.monitor.core.StatusHandler;

public class BackgroundSaveTimer
implements IActivityTimerListener {
    private static final int DEFAULT_SAVE_INTERVAL = 60000;
    private int saveInterval = 60000;
    private IBackgroundSaveListener listener = null;
    private ActivityTimerThread timer = null;

    public BackgroundSaveTimer(IBackgroundSaveListener listener) {
        this.listener = listener;
        this.timer = new ActivityTimerThread(this.saveInterval);
        this.timer.addListener((IActivityTimerListener)this);
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        this.timer.kill();
    }

    public void setSaveIntervalMillis(int saveIntervalMillis) {
        this.saveInterval = saveIntervalMillis;
        this.timer.setTimeoutMillis(saveIntervalMillis);
    }

    public int getSaveIntervalMillis() {
        return this.saveInterval;
    }

    public void fireInactive() {
        try {
            this.listener.saveRequested();
        }
        catch (RuntimeException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Could not schedule save job", (Throwable)e));
        }
    }

    public void fireActive(long start, long end) {
    }
}

