/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.core.Person;
import org.eclipse.mylyn.internal.tasks.ui.search.RepositorySearchResultView;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultContentProvider;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.search.RepositorySearchResult;

public class SearchResultTreeContentProvider
extends SearchResultContentProvider {
    private RepositorySearchResultView searchResultsPage;
    private List<Object> elements = new ArrayList<Object>();
    private Map<String, Person> owners = new HashMap<String, Person>();
    private boolean groupByOwner = false;

    public SearchResultTreeContentProvider(RepositorySearchResultView page) {
        this.searchResultsPage = page;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof RepositorySearchResult) {
            this.searchResult = (RepositorySearchResult)((Object)newInput);
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof RepositorySearchResult) {
            if (this.groupByOwner) {
                return this.owners.values().toArray();
            }
            return this.elements.toArray();
        }
        return this.EMPTY_ARR;
    }

    public Object[] getChildren(Object parentElement) {
        if (this.groupByOwner && parentElement instanceof Person) {
            Set children = ((Person)parentElement).getChildren();
            if (children != null) {
                return children.toArray();
            }
            return this.EMPTY_ARR;
        }
        return this.EMPTY_ARR;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.groupByOwner && element instanceof String) {
            Set children = ((Person)element).getChildren();
            if (children != null) {
                return !children.isEmpty();
            }
            return false;
        }
        return !(element instanceof AbstractTask);
    }

    public void elementsChanged(Object[] updatedElements) {
        Object[] objectArray = updatedElements;
        int n = updatedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.elements.add(object);
            if (object instanceof AbstractTask) {
                Person person;
                AbstractTask task = (AbstractTask)object;
                String owner = task.getOwner();
                if (owner == null) {
                    owner = "UNKNOWN";
                }
                if ((person = this.owners.get(owner)) == null) {
                    person = new Person(owner, task.getConnectorKind(), task.getRepositoryUrl());
                    this.owners.put(owner, person);
                }
                person.internalAddChild(task);
            }
            ++n2;
        }
        this.searchResultsPage.getViewer().refresh();
    }

    public void clear() {
        this.elements.clear();
        this.owners.clear();
        this.searchResultsPage.getViewer().refresh();
    }

    public boolean getGroupByOwner() {
        return this.groupByOwner;
    }

    public void setGroupByOwner(boolean grouping) {
        this.groupByOwner = grouping;
        this.searchResultsPage.getViewer().setInput(this.searchResultsPage.getViewer().getInput());
    }
}

