/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.planner;

import java.util.HashSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.ui.planner.ITaskPlannerContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.planner.TaskActivityEditorInput;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;

public class TaskActivityContentProvider
implements ITreeContentProvider,
ITaskPlannerContentProvider {
    private TaskActivityEditorInput editorInput;

    public TaskActivityContentProvider(TaskActivityEditorInput editorInput) {
        this.editorInput = editorInput;
    }

    public Object[] getElements(Object inputElement) {
        return this.editorInput.getCategories().toArray();
    }

    public void removeTask(AbstractTask task) {
        this.editorInput.removeCompletedTask(task);
        this.editorInput.removeInProgressTask(task);
    }

    public void addTask(AbstractTask task) {
    }

    public Object[] getChildren(Object parentElement) {
        HashSet result = new HashSet();
        if (parentElement instanceof AbstractTaskContainer) {
            AbstractTaskContainer parent = (AbstractTaskContainer)parentElement;
            HashSet<AbstractTask> completedChildren = new HashSet<AbstractTask>();
            completedChildren.addAll(this.editorInput.getCompletedTasks());
            completedChildren.retainAll(parent.getChildren());
            result.addAll(completedChildren);
            HashSet<AbstractTask> inProgressChildren = new HashSet<AbstractTask>();
            inProgressChildren.addAll(this.editorInput.getInProgressTasks());
            inProgressChildren.retainAll(parent.getChildren());
            result.addAll(inProgressChildren);
        }
        return result.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }
}

