/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilerExtension;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class TaskSpellingReconcileStrategy
implements IReconcilerExtension,
IReconcilingStrategy {
    public static final int SPELLING_PROBLEM_ID = Integer.MIN_VALUE;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private SpellingContext fSpellingContext = new SpellingContext();
    private IAnnotationModel annotationModel = null;

    public TaskSpellingReconcileStrategy() {
        this.fSpellingContext.setContentType(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"));
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void reconcile(IRegion region) {
        SpellingProblemCollector collector = new SpellingProblemCollector(this.annotationModel);
        EditorsUI.getSpellingService().check(this.fDocument, this.fSpellingContext, (ISpellingProblemCollector)collector, this.fProgressMonitor);
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public String getDocumentPartitioning() {
        return null;
    }

    public void setAnnotationModel(IAnnotationModel model) {
        this.annotationModel = model;
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        private IAnnotationModel fAnnotationModel;
        private Map<TaskFormPage.ErrorAnnotation, Position> fAddAnnotations;

        public SpellingProblemCollector(IAnnotationModel annotationModel) {
            this.fAnnotationModel = annotationModel;
        }

        public void accept(SpellingProblem problem) {
            try {
                int line = TaskSpellingReconcileStrategy.this.fDocument.getLineOfOffset(problem.getOffset()) + 1;
                this.fAddAnnotations.put(new TaskFormPage.ErrorAnnotation(line, null), new Position(problem.getOffset(), problem.getLength()));
            }
            catch (BadLocationException badLocationException) {}
        }

        public void beginCollecting() {
            this.fAddAnnotations = new HashMap<TaskFormPage.ErrorAnnotation, Position>();
        }

        public void endCollecting() {
            ArrayList<Annotation> removeAnnotations = new ArrayList<Annotation>();
            Iterator<Object> iter = this.fAnnotationModel.getAnnotationIterator();
            while (iter.hasNext()) {
                Annotation annotation = (Annotation)iter.next();
                if (!TaskFormPage.ErrorAnnotation.ERROR_TYPE.equals(annotation.getType())) continue;
                removeAnnotations.add(annotation);
            }
            iter = removeAnnotations.iterator();
            while (iter.hasNext()) {
                this.fAnnotationModel.removeAnnotation((Annotation)iter.next());
            }
            for (Annotation annotation : this.fAddAnnotations.keySet()) {
                this.fAnnotationModel.addAnnotation(annotation, this.fAddAnnotations.get(annotation));
            }
            this.fAddAnnotations = null;
        }
    }
}

