/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TaskEditorPeoplePart
extends AbstractTaskEditorPart {
    private static final Font TEXT_FONT = JFaceResources.getDefaultFont();
    private org.eclipse.swt.widgets.List ccList;

    public TaskEditorPeoplePart(AbstractTaskEditorPage taskEditorPage) {
        super(taskEditorPage);
    }

    protected void addAssignedTo(Composite peopleComposite, FormToolkit toolkit) {
        boolean haveRealName = false;
        RepositoryTaskAttribute assignedAttribute = this.getTaskData().getAttribute("task.common.user.assigned.name");
        if (assignedAttribute == null) {
            assignedAttribute = this.getTaskData().getAttribute("task.common.user.assigned");
        } else {
            haveRealName = true;
        }
        if (assignedAttribute != null) {
            Text textField;
            Label label = this.createLabel(peopleComposite, assignedAttribute, toolkit);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
            if (assignedAttribute.isReadOnly()) {
                textField = this.createTextField(peopleComposite, assignedAttribute, 0x800008, toolkit);
            } else {
                textField = this.createTextField(peopleComposite, assignedAttribute, 0x800000, toolkit);
                ContentAssistCommandAdapter adapter = this.getTaskEditorPage().getAttributeEditorToolkit().applyContentAssist(textField, this.getTaskEditorPage().getAttributeEditorToolkit().createContentProposalProvider(assignedAttribute));
                ILabelProvider propsalLabelProvider = this.getTaskEditorPage().getAttributeEditorToolkit().createLabelProposalProvider(assignedAttribute);
                if (propsalLabelProvider != null) {
                    adapter.setLabelProvider(propsalLabelProvider);
                }
                adapter.setProposalAcceptanceStyle(2);
            }
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textField);
            if (haveRealName) {
                textField.setText(String.valueOf(textField.getText()) + " <" + this.getTaskData().getAttributeValue("task.common.user.assigned") + ">");
            }
        }
    }

    protected void addCCList(Composite attributesComposite, FormToolkit toolkit) {
        RepositoryTaskAttribute CCattribute;
        RepositoryTaskAttribute addCCattribute = this.getTaskData().getAttribute("task.common.newcc");
        if (addCCattribute == null) {
            return;
        }
        Label label = this.createLabel(attributesComposite, addCCattribute, toolkit);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        Text text = this.createTextField(attributesComposite, addCCattribute, 0x800000, toolkit);
        GridDataFactory.fillDefaults().hint(150, -1).applyTo((Control)text);
        if (this.getTaskEditorPage().getAttributeEditorToolkit().hasContentAssist(addCCattribute)) {
            ContentAssistCommandAdapter adapter = this.getTaskEditorPage().getAttributeEditorToolkit().applyContentAssist(text, this.getTaskEditorPage().getAttributeEditorToolkit().createContentProposalProvider(addCCattribute));
            ILabelProvider propsalLabelProvider = this.getTaskEditorPage().getAttributeEditorToolkit().createLabelProposalProvider(addCCattribute);
            if (propsalLabelProvider != null) {
                adapter.setLabelProvider(propsalLabelProvider);
            }
            adapter.setProposalAcceptanceStyle(2);
        }
        if ((CCattribute = this.getTaskData().getAttribute("task.common.user.cc")) != null) {
            List removedCCs;
            List ccs;
            label = this.createLabel(attributesComposite, CCattribute, toolkit);
            GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)label);
            this.ccList = new org.eclipse.swt.widgets.List(attributesComposite, 514);
            this.ccList.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            this.ccList.setFont(TEXT_FONT);
            GridData ccListData = new GridData(256);
            ccListData.horizontalSpan = 1;
            ccListData.widthHint = 150;
            ccListData.heightHint = 95;
            this.ccList.setLayoutData((Object)ccListData);
            RepositoryTaskAttribute taskAttribute = this.getTaskData().getAttribute("task.common.user.cc");
            if (this.getTaskEditorPage().getAttributeManager().hasIncomingChanges(taskAttribute)) {
                this.ccList.setBackground(this.getTaskEditorPage().getColorIncoming());
            }
            if ((ccs = this.getTaskData().getCc()) != null) {
                for (String cc : ccs) {
                    this.ccList.add(cc);
                }
            }
            if ((removedCCs = this.getTaskData().getAttributeValues("task.common.removecc")) != null) {
                for (String item : removedCCs) {
                    int i = this.ccList.indexOf(item);
                    if (i == -1) continue;
                    this.ccList.select(i);
                }
            }
            this.ccList.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String[] stringArray = TaskEditorPeoplePart.this.ccList.getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String cc = stringArray[n2];
                        int index = TaskEditorPeoplePart.this.ccList.indexOf(cc);
                        if (TaskEditorPeoplePart.this.ccList.isSelected(index)) {
                            List remove = TaskEditorPeoplePart.this.getTaskData().getAttributeValues("task.common.removecc");
                            if (!remove.contains(cc)) {
                                TaskEditorPeoplePart.this.getTaskData().addAttributeValue("task.common.removecc", cc);
                            }
                        } else {
                            TaskEditorPeoplePart.this.getTaskData().removeAttributeValue("task.common.removecc", cc);
                        }
                        ++n2;
                    }
                    TaskEditorPeoplePart.this.getTaskEditorPage().getAttributeManager().attributeChanged(TaskEditorPeoplePart.this.getTaskData().getAttribute("task.common.removecc"));
                }
            });
            toolkit.createLabel(attributesComposite, "");
            label = toolkit.createLabel(attributesComposite, "(Select to remove)");
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)label);
        }
    }

    protected void addSelfToCC(Composite composite, FormToolkit toolkit) {
        if (this.getTaskRepository().getUserName() == null) {
            return;
        }
        RepositoryTaskAttribute owner = this.getTaskData().getAttribute("task.common.user.assigned");
        if (owner != null && owner.getValue().indexOf(this.getTaskRepository().getUserName()) != -1) {
            return;
        }
        RepositoryTaskAttribute reporter = this.getTaskData().getAttribute("task.common.user.reporter");
        if (reporter != null && reporter.getValue().indexOf(this.getTaskRepository().getUserName()) != -1) {
            return;
        }
        RepositoryTaskAttribute ccAttribute = this.getTaskData().getAttribute("task.common.user.cc");
        if (ccAttribute != null && ccAttribute.getValues().contains(this.getTaskRepository().getUserName())) {
            return;
        }
        toolkit.createLabel(composite, "");
        final Button addSelfButton = toolkit.createButton(composite, "Add me to CC", 32);
        addSelfButton.setSelection("1".equals(this.getTaskData().getAttributeValue("task.common.addselfcc")));
        addSelfButton.setImage(TasksUiImages.getImage(TasksUiImages.PERSON));
        addSelfButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (addSelfButton.getSelection()) {
                    TaskEditorPeoplePart.this.getTaskData().setAttributeValue("task.common.addselfcc", "1");
                } else {
                    TaskEditorPeoplePart.this.getTaskData().setAttributeValue("task.common.addselfcc", "0");
                }
                RepositoryTaskAttribute attribute = TaskEditorPeoplePart.this.getTaskData().getAttribute("task.common.addselfcc");
                TaskEditorPeoplePart.this.getTaskEditorPage().getAttributeManager().attributeChanged(attribute);
            }
        });
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite peopleComposite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 5;
        peopleComposite.setLayout((Layout)layout);
        this.addAssignedTo(peopleComposite, toolkit);
        boolean haveRealName = false;
        RepositoryTaskAttribute reporterAttribute = this.getTaskData().getAttribute("task.common.user.reporter.name");
        if (reporterAttribute == null) {
            reporterAttribute = this.getTaskData().getAttribute("task.common.user.reporter");
        } else {
            haveRealName = true;
        }
        if (reporterAttribute != null) {
            Label label = this.createLabel(peopleComposite, reporterAttribute, toolkit);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
            Text textField = this.createTextField(peopleComposite, reporterAttribute, 0x800008, toolkit);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textField);
            if (haveRealName) {
                textField.setText(String.valueOf(textField.getText()) + " <" + this.getTaskData().getAttributeValue("task.common.user.reporter") + ">");
            }
        }
        this.addSelfToCC(peopleComposite, toolkit);
        this.addCCList(peopleComposite, toolkit);
        toolkit.paintBordersFor(peopleComposite);
        this.setControl((Control)peopleComposite);
    }

    protected Label createLabel(Composite composite, RepositoryTaskAttribute attribute, FormToolkit toolkit) {
        Label label = this.getTaskEditorPage().getAttributeManager().hasOutgoingChanges(attribute) ? toolkit.createLabel(composite, "*" + attribute.getName()) : toolkit.createLabel(composite, attribute.getName());
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        return label;
    }

    protected Text createTextField(Composite composite, RepositoryTaskAttribute attribute, int style, FormToolkit toolkit) {
        Text text;
        String value = attribute == null || attribute.getValue() == null ? "" : attribute.getValue();
        if ((8 & style) == 8) {
            text = new Text(composite, style);
            toolkit.adapt((Control)text, true, true);
            text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            text.setText(value);
        } else {
            text = toolkit.createText(composite, value, style);
        }
        if (attribute != null && !attribute.isReadOnly()) {
            text.setData((Object)attribute);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String newValue = text.getText();
                    RepositoryTaskAttribute attribute = (RepositoryTaskAttribute)text.getData();
                    attribute.setValue(newValue);
                    TaskEditorPeoplePart.this.getTaskEditorPage().getAttributeManager().attributeChanged(attribute);
                }
            });
        }
        if (this.getTaskEditorPage().getAttributeManager().hasIncomingChanges(attribute)) {
            text.setBackground(this.getTaskEditorPage().getColorIncoming());
        }
        return text;
    }
}

